#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
printf '%s' 'name:                 postgrest
version:              10.0.0
visibility:           public
id:                   postgrest-10.0.0-InynYLJWcnvDDl2uHQmJzD
key:                  postgrest-10.0.0-InynYLJWcnvDDl2uHQmJzD
license:              MIT
maintainer:           Steve Chavez <stevechavezast@gmail.com>
author:               Joe Nelson, Adam Baker, Steve Chavez
homepage:             https://postgrest.org
synopsis:             REST API for any Postgres database
description:
    Reads the schema of a PostgreSQL database and creates RESTful routes
    for tables, views, and functions, supporting all HTTP methods that security
    permits.

category:             Executable, PostgreSQL, Network APIs
abi:                  e96c78969b4a25718137621f284108a8
exposed:              True
exposed-modules:
    PostgREST.Admin PostgREST.App PostgREST.AppState PostgREST.Auth
    PostgREST.CLI PostgREST.Config PostgREST.Config.Database
    PostgREST.Config.JSPath PostgREST.Config.PgVersion
    PostgREST.Config.Proxy PostgREST.Cors PostgREST.DbStructure
    PostgREST.DbStructure.Identifiers PostgREST.DbStructure.Proc
    PostgREST.DbStructure.Relationship PostgREST.DbStructure.Table
    PostgREST.Error PostgREST.GucHeader PostgREST.Logger
    PostgREST.MediaType PostgREST.Middleware PostgREST.OpenAPI
    PostgREST.Query.QueryBuilder PostgREST.Query.SqlFragment
    PostgREST.Query.Statements PostgREST.RangeQuery
    PostgREST.Request.ApiRequest PostgREST.Request.DbRequestBuilder
    PostgREST.Request.MutateQuery PostgREST.Request.Preferences
    PostgREST.Request.QueryParams PostgREST.Request.ReadQuery
    PostgREST.Request.Types PostgREST.Unix PostgREST.Version
    PostgREST.Workers

hidden-modules:       Paths_postgrest
import-dirs:          /usr/lib/ghc-9.4.8/site-local/postgrest-10.0.0
library-dirs:         /usr/lib/ghc-9.4.8/site-local/postgrest-10.0.0
library-dirs-static:  /usr/lib/ghc-9.4.8/site-local/postgrest-10.0.0
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/postgrest
hs-libraries:         HSpostgrest-10.0.0-InynYLJWcnvDDl2uHQmJzD
depends:
    HTTP-4000.4.1-9AYSU07EKBwz0gP6VImrC
    Ranged-sets-0.5.0-8Qlzc22bWMVD5fr3Vp4hy6
    aeson-2.1.2.1-56YME0rnoff9HEf3dDitk2
    auto-update-0.1.6-2TKMPNGPExkJD7f7miJvqv base-4.17.2.1
    base64-bytestring-1.2.1.0-Gcv0cK19O0C10ALYRTEs9u
    bytestring-0.11.5.3 case-insensitive-1.2.1.0-6AEDVQFE46r4UgT1OZ8vwx
    cassava-0.5.4.1-JkDf9zQaTEp5PzU5MGTTIk
    configurator-pg-0.2.10-2bqve83bdm5BHV1bHTabyh containers-0.6.7
    contravariant-extras-0.3.5.4-55ftugxfRMl5DZHT7luCXJ
    cookie-0.4.6-4shfaVKBFn0Hnep1ZY6FZw directory-1.3.7.1
    either-5.0.3-BtcezSfqlh64PFukFhtSzB
    gitrev-1.3.1-KhpMNofwsxABRoyEGWB0ci
    hasql-1.5.0.5-y0VqCS7QWo1UqX9Fmk3rx
    hasql-dynamic-statements-0.3.1.1-40S2T0IYcJ8D7nalAmgPr
    hasql-notifications-0.2.0.5-4y49XDfoeae3FEkW8l8MHw
    hasql-pool-0.5.2.2-Ivh4jtIGfmaE9YOKDIqGa9
    hasql-transaction-1.0.1.1-DppIzNL3TMsEh5tX8UFKGj
    heredoc-0.2.0.0-77nW0mrU6iW6fQsJ6nWzcx
    http-types-0.12.4-GF9q12zDyJCA1fCuHO5qN
    insert-ordered-containers-0.2.5.3-FYiBgGWS7lUC1IA98QkNa1
    interpolatedstring-perl6-1.0.2-FCDUYG3Jgf4EREwwFbLqIm
    jose-0.10-7MpGA4wMnLI7ROBiKA1iq lens-5.3.1-9N2tK9zs7SGKEpVslmdE8u
    lens-aeson-1.2.3-DQhshW5dJWf2FfFaLKQeGc mtl-2.2.2
    network-3.1.4.0-1ps2oXOoyxa7GsNgS88GCq
    network-uri-2.6.4.2-20b9im5hRHiD5kB2vlJ1JL
    optparse-applicative-0.18.1.0-4I1HvF8r6VYLyVAzfeWbyM
    parsec-3.1.16.1 protolude-0.3.5-D2zbRAbGcNc1DNWNYoCiO1
    regex-tdfa-1.3.2.4-76nazsu2jDf2z4IzA4PXWU
    retry-0.9.3.1-FG5DYePVL36Cc5af3OlTPn
    scientific-0.3.8.0-6cXdeLWNyVuBHCExgz4Uaq
    swagger2-2.8.10-HUQqbgO9PxeAIqjR7FflYR text-2.0.2 time-1.12.2
    unix-2.7.3 unordered-containers-0.2.20-90liAnN3BtD8VAzg2AGnlq
    vault-0.3.1.5-7KdWLmTOzL7JMAPxhkt7Oi
    vector-0.13.2.0-Fx80VLFrFKz3Sy2krWU8Ue
    wai-3.2.4-3Rb2R2bry06JIe4wFfvRMb
    wai-cors-0.2.7-Bpbz54VvcObBkYHCsDXNbX
    wai-extra-3.1.17-1eWeWEEVVHB2oyc6kVUeTP
    wai-logger-2.5.0-5MI8Cj744162EpksB3TJQ4
    warp-3.3.30-8PDlMvIdVjIArgEuVld1EH

haddock-interfaces:   /usr/share/doc/postgrest/html/postgrest.haddock
haddock-html:         /usr/share/doc/postgrest/html
' | '/usr/bin/ghc-pkg-9.4.8' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

