#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
printf '%s' 'name:                 postgrest
version:              10.0.0
visibility:           public
id:                   postgrest-10.0.0-HWbLSkqBu7lHVuDFjacCpO
key:                  postgrest-10.0.0-HWbLSkqBu7lHVuDFjacCpO
license:              MIT
maintainer:           Steve Chavez <stevechavezast@gmail.com>
author:               Joe Nelson, Adam Baker, Steve Chavez
homepage:             https://postgrest.org
synopsis:             REST API for any Postgres database
description:
    Reads the schema of a PostgreSQL database and creates RESTful routes
    for tables, views, and functions, supporting all HTTP methods that security
    permits.

category:             Executable, PostgreSQL, Network APIs
abi:                  9eab2e2063dffd4bd81064335a5cbe70
exposed:              True
exposed-modules:
    PostgREST.Admin PostgREST.App PostgREST.AppState PostgREST.Auth
    PostgREST.CLI PostgREST.Config PostgREST.Config.Database
    PostgREST.Config.JSPath PostgREST.Config.PgVersion
    PostgREST.Config.Proxy PostgREST.Cors PostgREST.DbStructure
    PostgREST.DbStructure.Identifiers PostgREST.DbStructure.Proc
    PostgREST.DbStructure.Relationship PostgREST.DbStructure.Table
    PostgREST.Error PostgREST.GucHeader PostgREST.Logger
    PostgREST.MediaType PostgREST.Middleware PostgREST.OpenAPI
    PostgREST.Query.QueryBuilder PostgREST.Query.SqlFragment
    PostgREST.Query.Statements PostgREST.RangeQuery
    PostgREST.Request.ApiRequest PostgREST.Request.DbRequestBuilder
    PostgREST.Request.MutateQuery PostgREST.Request.Preferences
    PostgREST.Request.QueryParams PostgREST.Request.ReadQuery
    PostgREST.Request.Types PostgREST.Unix PostgREST.Version
    PostgREST.Workers

hidden-modules:       Paths_postgrest
import-dirs:          /usr/lib/ghc-9.4.8/site-local/postgrest-10.0.0
library-dirs:         /usr/lib/ghc-9.4.8/site-local/postgrest-10.0.0
library-dirs-static:  /usr/lib/ghc-9.4.8/site-local/postgrest-10.0.0
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/postgrest
hs-libraries:         HSpostgrest-10.0.0-HWbLSkqBu7lHVuDFjacCpO
depends:
    HTTP-4000.4.1-DfdmXPglDtF9oOKX0n1geD
    Ranged-sets-0.5.0-Zw96hA6XbRIHRKFWJCvXY
    aeson-2.1.2.1-GhEX0nU3rpe2rpNz8TrqEz
    auto-update-0.1.6-Bd4qvEQaUq979gQguTAj4X base-4.17.2.1
    base64-bytestring-1.2.1.0-1ZLaOmG6271EszdgVZtDyi
    bytestring-0.11.5.3 case-insensitive-1.2.1.0-4S8KsHm7tqa4BSXUqBqEFP
    cassava-0.5.4.1-e0lyQ2V2pQDWDc3VxbCay
    configurator-pg-0.2.10-DEpJCoJRzWRHhccnqvUXnE containers-0.6.7
    contravariant-extras-0.3.5.4-55ftugxfRMl5DZHT7luCXJ
    cookie-0.4.6-4shfaVKBFn0Hnep1ZY6FZw directory-1.3.7.1
    either-5.0.3-HI4XU92GWuzAurkLHewkeW
    gitrev-1.3.1-KhpMNofwsxABRoyEGWB0ci
    hasql-1.5.0.5-8uXiRCBwgAPJXAF6Tz2WoQ
    hasql-dynamic-statements-0.3.1.1-LyR6cPqWAGY8A9VMHH2NCZ
    hasql-notifications-0.2.0.5-LIhHmUfPh0k4Ic6EnzCF9b
    hasql-pool-0.5.2.2-YumbfYgsULLFyYHWR92ZI
    hasql-transaction-1.0.1.1-EfLrDAcYDNR2fev0KxJadx
    heredoc-0.2.0.0-77nW0mrU6iW6fQsJ6nWzcx
    http-types-0.12.4-8AFNw5oQ8TE9V2A9rZjrTr
    insert-ordered-containers-0.2.5.3-Hr92Hk94NCgKMKIolOkzpb
    interpolatedstring-perl6-1.0.2-HgBMK233vAHL8yEp6ZMIFA
    jose-0.10-AawcDdq5sqw8pSFXsQTcSB lens-5.3.1-Jk0s21IZQ9F7Om7ixQU7VU
    lens-aeson-1.2.3-7UjyvlHoBiQD8G78gVKOOp mtl-2.2.2
    network-3.1.4.0-GjkG889aAvvIfieaCEFwUy
    network-uri-2.6.4.2-E36L5Munrgj3tkxSsgYpcw
    optparse-applicative-0.18.1.0-LIQoJoN7TQpDnAr18DZx9V
    parsec-3.1.16.1 protolude-0.3.5-4YnnRc0gq99v6iFClFn7K
    regex-tdfa-1.3.2.4-7R3Q4g0HpHyGnQN3kqm2tU
    retry-0.9.3.1-GTnFBd8BJ0WGgSdKToWdhU
    scientific-0.3.8.0-IWovBluCcknEjldn22iWzh
    swagger2-2.8.10-3ck9CrsM5IJLBklxKob4gj text-2.0.2 time-1.12.2
    unix-2.7.3 unordered-containers-0.2.20-psp1ib8v1R5J9F619BTWH
    vault-0.3.1.5-42phqld7LtFL4LA5yusYTB
    vector-0.13.2.0-BxFNQQxQb2S1T9ycXEZ0Cs
    wai-3.2.4-7AO9d5JyralLoyfSO8kkij
    wai-cors-0.2.7-6aZY9ZpNmwCIn4ajw984rA
    wai-extra-3.1.17-DxFwVatTeNLlcKV8bcmaH
    wai-logger-2.5.0-6UgzbyMAZ9I2Rd2402DXWK
    warp-3.3.30-SQgNLAClSCLXsKRoqZBVX

haddock-interfaces:   /usr/share/doc/postgrest/html/postgrest.haddock
haddock-html:         /usr/share/doc/postgrest/html
' | '/usr/bin/ghc-pkg-9.4.8' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

