#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
printf '%s' 'name:                 postgrest
version:              10.0.0
visibility:           public
id:                   postgrest-10.0.0-1L1U2nOXPAaNd2iiz3QpB
key:                  postgrest-10.0.0-1L1U2nOXPAaNd2iiz3QpB
license:              MIT
maintainer:           Steve Chavez <stevechavezast@gmail.com>
author:               Joe Nelson, Adam Baker, Steve Chavez
homepage:             https://postgrest.org
synopsis:             REST API for any Postgres database
description:
    Reads the schema of a PostgreSQL database and creates RESTful routes
    for tables, views, and functions, supporting all HTTP methods that security
    permits.

category:             Executable, PostgreSQL, Network APIs
abi:                  975c4e5271b00b81b53bf29cf58f967c
exposed:              True
exposed-modules:
    PostgREST.Admin PostgREST.App PostgREST.AppState PostgREST.Auth
    PostgREST.CLI PostgREST.Config PostgREST.Config.Database
    PostgREST.Config.JSPath PostgREST.Config.PgVersion
    PostgREST.Config.Proxy PostgREST.Cors PostgREST.DbStructure
    PostgREST.DbStructure.Identifiers PostgREST.DbStructure.Proc
    PostgREST.DbStructure.Relationship PostgREST.DbStructure.Table
    PostgREST.Error PostgREST.GucHeader PostgREST.Logger
    PostgREST.MediaType PostgREST.Middleware PostgREST.OpenAPI
    PostgREST.Query.QueryBuilder PostgREST.Query.SqlFragment
    PostgREST.Query.Statements PostgREST.RangeQuery
    PostgREST.Request.ApiRequest PostgREST.Request.DbRequestBuilder
    PostgREST.Request.MutateQuery PostgREST.Request.Preferences
    PostgREST.Request.QueryParams PostgREST.Request.ReadQuery
    PostgREST.Request.Types PostgREST.Unix PostgREST.Version
    PostgREST.Workers

hidden-modules:       Paths_postgrest
import-dirs:          /usr/lib/ghc-9.4.8/site-local/postgrest-10.0.0
library-dirs:         /usr/lib/ghc-9.4.8/site-local/postgrest-10.0.0
library-dirs-static:  /usr/lib/ghc-9.4.8/site-local/postgrest-10.0.0
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/postgrest
hs-libraries:         HSpostgrest-10.0.0-1L1U2nOXPAaNd2iiz3QpB
depends:
    HTTP-4000.4.1-GSg3Nv0zptC9SZc5BeWBbF
    Ranged-sets-0.5.0-4KnVoIJDRuy2jFlkKlt0q0
    aeson-2.1.2.1-JflO2jKMgLf4qHLretO6v3
    auto-update-0.1.6-4G8CrEsMCVaEFiaEjRZ6qi base-4.17.2.1
    base64-bytestring-1.2.1.0-7CU13IWnWdcDMU9nDc25iT
    bytestring-0.11.5.3 case-insensitive-1.2.1.0-BbofItWtqOBJTc7ifMkeDp
    cassava-0.5.4.1-FfVtaI2LUaDCy3WzIQ79Pn
    configurator-pg-0.2.10-1DV2h2Aj1aYGIx0OPT4QLZ containers-0.6.7
    contravariant-extras-0.3.5.4-55ftugxfRMl5DZHT7luCXJ
    cookie-0.4.6-4shfaVKBFn0Hnep1ZY6FZw directory-1.3.7.1
    either-5.0.3-7spijw5YLKBGnbDzFy9xka
    gitrev-1.3.1-KhpMNofwsxABRoyEGWB0ci
    hasql-1.5.0.5-5osMhB0yPKA8EymoN75l5B
    hasql-dynamic-statements-0.3.1.1-Cmnd00vh4FeBzbFMpjm9tY
    hasql-notifications-0.2.0.5-EDLiyNRfRtzIm6EugPPwA0
    hasql-pool-0.5.2.2-KQVqr8Epdo8K7TbDRVyWl3
    hasql-transaction-1.0.1.1-6M9sl0dcTOB5sihFjsG4q8
    heredoc-0.2.0.0-77nW0mrU6iW6fQsJ6nWzcx
    http-types-0.12.4-IN69whTTZpTCgL5hadx0pQ
    insert-ordered-containers-0.2.5.3-JMcyMfgNBIZ1FmcDeSddjx
    interpolatedstring-perl6-1.0.2-JUWkFxgrobcEyrgIbzPziL
    jose-0.10-Dl2NzhH6hqlELunlfejhpL lens-5.3.1-1dHHf9jtSMJ2j1NVow6adv
    lens-aeson-1.2.3-Jnl2a0s5gCjL6djtH20iz mtl-2.2.2
    network-3.1.4.0-HEqaUi724nxGs7WtLdNH8M
    network-uri-2.6.4.2-2gUAl98MPyzDbzRsnMqG8p
    optparse-applicative-0.18.1.0-LGvZkTwKuqyFBAUogcAFyK
    parsec-3.1.16.1 protolude-0.3.5-3Fbw5wszI5gIOINa4G3nGe
    regex-tdfa-1.3.2.4-AZwqaFit2cg4MrWLIhNcyO
    retry-0.9.3.1-2ca5UIxrF0T4lPPj0z8cz3
    scientific-0.3.8.0-8fLTd8S79uT7C3Z3GpM5Vd
    swagger2-2.8.10-2beLoSF0R19JXgLSt445MO text-2.0.2 time-1.12.2
    unix-2.7.3 unordered-containers-0.2.20-Eo1ocpXri5ABLOF81VToPu
    vault-0.3.1.5-7GlvwJwn6pW6IZp1B3RRI1
    vector-0.13.2.0-ByKMfTK8tTR39fPNQcIOcc
    wai-3.2.4-5jTd0UWsGpkHy031tY6wSU
    wai-cors-0.2.7-J5opACD9Ieu4lH53kZ5BYh
    wai-extra-3.1.17-7aOaJRPpRVD3oIMcjFi9xX
    wai-logger-2.5.0-LRhOmSLOUBgGqBa84lkKve
    warp-3.3.30-4gSKOE93iSYFw6AC4opjX0

haddock-interfaces:   /usr/share/doc/postgrest/html/postgrest.haddock
haddock-html:         /usr/share/doc/postgrest/html
' | '/usr/bin/ghc-pkg-9.4.8' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

