#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
printf '%s' 'name:                 postgrest
version:              10.0.0
visibility:           public
id:                   postgrest-10.0.0-F9KXXtI6ixnLxGY8YO9RqY
key:                  postgrest-10.0.0-F9KXXtI6ixnLxGY8YO9RqY
license:              MIT
maintainer:           Steve Chavez <stevechavezast@gmail.com>
author:               Joe Nelson, Adam Baker, Steve Chavez
homepage:             https://postgrest.org
synopsis:             REST API for any Postgres database
description:
    Reads the schema of a PostgreSQL database and creates RESTful routes
    for tables, views, and functions, supporting all HTTP methods that security
    permits.

category:             Executable, PostgreSQL, Network APIs
abi:                  5262cc54d007b94c9fe4523ae7802c3a
exposed:              True
exposed-modules:
    PostgREST.Admin PostgREST.App PostgREST.AppState PostgREST.Auth
    PostgREST.CLI PostgREST.Config PostgREST.Config.Database
    PostgREST.Config.JSPath PostgREST.Config.PgVersion
    PostgREST.Config.Proxy PostgREST.Cors PostgREST.DbStructure
    PostgREST.DbStructure.Identifiers PostgREST.DbStructure.Proc
    PostgREST.DbStructure.Relationship PostgREST.DbStructure.Table
    PostgREST.Error PostgREST.GucHeader PostgREST.Logger
    PostgREST.MediaType PostgREST.Middleware PostgREST.OpenAPI
    PostgREST.Query.QueryBuilder PostgREST.Query.SqlFragment
    PostgREST.Query.Statements PostgREST.RangeQuery
    PostgREST.Request.ApiRequest PostgREST.Request.DbRequestBuilder
    PostgREST.Request.MutateQuery PostgREST.Request.Preferences
    PostgREST.Request.QueryParams PostgREST.Request.ReadQuery
    PostgREST.Request.Types PostgREST.Unix PostgREST.Version
    PostgREST.Workers

hidden-modules:       Paths_postgrest
import-dirs:          /usr/lib/ghc-9.4.8/site-local/postgrest-10.0.0
library-dirs:         /usr/lib/ghc-9.4.8/site-local/postgrest-10.0.0
library-dirs-static:  /usr/lib/ghc-9.4.8/site-local/postgrest-10.0.0
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/postgrest
hs-libraries:         HSpostgrest-10.0.0-F9KXXtI6ixnLxGY8YO9RqY
depends:
    HTTP-4000.4.1-14B7e92uULi3NEdUxVKXYv
    Ranged-sets-0.5.0-9KN8j6KmsrgJU8Ywi7nt5
    aeson-2.1.2.1-AuEsVg6Hhe2CPhaLp40FYe
    auto-update-0.1.6-58cUX3eRof6DEapr1heHzL base-4.17.2.1
    base64-bytestring-1.2.1.0-AbhqXNvtZOJLR3Ub6lZ1hd
    bytestring-0.11.5.3 case-insensitive-1.2.1.0-FtXwbgcyUdT58mvaxnolJS
    cassava-0.5.4.1-3yEOjII8z199fz43wkVflY
    configurator-pg-0.2.10-GUxYMWVFGHb8uR6QNnQgmF containers-0.6.7
    contravariant-extras-0.3.5.4-55ftugxfRMl5DZHT7luCXJ
    cookie-0.4.6-4shfaVKBFn0Hnep1ZY6FZw directory-1.3.7.1
    either-5.0.3-8CcsCVCVsaj6zvyvBmbMda
    gitrev-1.3.1-KhpMNofwsxABRoyEGWB0ci
    hasql-1.5.0.5-68UAmWkZqHR3x5hNlQIii3
    hasql-dynamic-statements-0.3.1.1-FCwHeWGRlPVFbU2xolpMBe
    hasql-notifications-0.2.0.5-JF0IJ8kjzWWHWy4twbOQpW
    hasql-pool-0.5.2.2-622nIJwoQjGBPEPQ2GkLxZ
    hasql-transaction-1.0.1.1-7Gz9TS5t4km8niAfdeVOqy
    heredoc-0.2.0.0-77nW0mrU6iW6fQsJ6nWzcx
    http-types-0.12.4-KxfEKIoLDdBKlrGUyHct4y
    insert-ordered-containers-0.2.5.3-AJvg69AW09iKzEEFvmVMzF
    interpolatedstring-perl6-1.0.2-FckF6AcsZdpILuOodYDpba
    jose-0.10-CERewkdJFXH3Fw2lduGH43 lens-5.3.1-DW98VpYgL8e3Qofq450fQJ
    lens-aeson-1.2.3-AkP0Poybm0TDtjqlirWZwI mtl-2.2.2
    network-3.1.4.0-HbZCj3UHcZsFvn6ftFrD4m
    network-uri-2.6.4.2-BuPsn3YVnowHuszetfOccY
    optparse-applicative-0.18.1.0-79DXPPhnqn915zrePmz04b
    parsec-3.1.16.1 protolude-0.3.5-5M3GhmgA3m5As7KmxnGIui
    regex-tdfa-1.3.2.4-2tggK3dv6qG2BQKi0Zlyyt
    retry-0.9.3.1-FvtjzzsOnDrD9RLLJSZJKo
    scientific-0.3.8.0-LCs3zqD3ZVT6NyF8Z7YnMi
    swagger2-2.8.10-BEEt7oHyrQoHbuHRlw8Msl text-2.0.2 time-1.12.2
    unix-2.7.3 unordered-containers-0.2.20-FOY8P5Y3sqjANbVUEJi9Vi
    vault-0.3.1.5-BQ3GCz3hemaFHrE1GoYhu4
    vector-0.13.2.0-6oLw41loWTIuQEg8iaHmr
    wai-3.2.4-5eTAAfrYzv8Cj5jt7kPDLd
    wai-cors-0.2.7-4aK95z55DfODMvZCoVbeUn
    wai-extra-3.1.17-725EK6xKvUCJXMQKiZrmau
    wai-logger-2.5.0-4JniSRwdOQj4BLnAV7YhN4
    warp-3.3.30-6f86FwsrA0q9gyhbhZhd7N

haddock-interfaces:   /usr/share/doc/postgrest/html/postgrest.haddock
haddock-html:         /usr/share/doc/postgrest/html
' | '/usr/bin/ghc-pkg-9.4.8' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

