#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
printf '%s' 'name:                 postgrest
version:              10.0.0
visibility:           public
id:                   postgrest-10.0.0-107M5XspjVBHb09cOqkwsX
key:                  postgrest-10.0.0-107M5XspjVBHb09cOqkwsX
license:              MIT
maintainer:           Steve Chavez <stevechavezast@gmail.com>
author:               Joe Nelson, Adam Baker, Steve Chavez
homepage:             https://postgrest.org
synopsis:             REST API for any Postgres database
description:
    Reads the schema of a PostgreSQL database and creates RESTful routes
    for tables, views, and functions, supporting all HTTP methods that security
    permits.

category:             Executable, PostgreSQL, Network APIs
abi:                  8f415c3811f92ee91d939f6059ec6726
exposed:              True
exposed-modules:
    PostgREST.Admin PostgREST.App PostgREST.AppState PostgREST.Auth
    PostgREST.CLI PostgREST.Config PostgREST.Config.Database
    PostgREST.Config.JSPath PostgREST.Config.PgVersion
    PostgREST.Config.Proxy PostgREST.Cors PostgREST.DbStructure
    PostgREST.DbStructure.Identifiers PostgREST.DbStructure.Proc
    PostgREST.DbStructure.Relationship PostgREST.DbStructure.Table
    PostgREST.Error PostgREST.GucHeader PostgREST.Logger
    PostgREST.MediaType PostgREST.Middleware PostgREST.OpenAPI
    PostgREST.Query.QueryBuilder PostgREST.Query.SqlFragment
    PostgREST.Query.Statements PostgREST.RangeQuery
    PostgREST.Request.ApiRequest PostgREST.Request.DbRequestBuilder
    PostgREST.Request.MutateQuery PostgREST.Request.Preferences
    PostgREST.Request.QueryParams PostgREST.Request.ReadQuery
    PostgREST.Request.Types PostgREST.Unix PostgREST.Version
    PostgREST.Workers

hidden-modules:       Paths_postgrest
import-dirs:          /usr/lib/ghc-9.4.8/site-local/postgrest-10.0.0
library-dirs:         /usr/lib/ghc-9.4.8/site-local/postgrest-10.0.0
library-dirs-static:  /usr/lib/ghc-9.4.8/site-local/postgrest-10.0.0
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/postgrest
hs-libraries:         HSpostgrest-10.0.0-107M5XspjVBHb09cOqkwsX
depends:
    HTTP-4000.4.1-9SogL1ploXw5esj5RJ2575
    Ranged-sets-0.5.0-Kjkl91GnaNc9iL4oV8sJ6S
    aeson-2.1.2.1-9cza8YJPY5Z8Ze3x8zf5ig
    auto-update-0.1.6-CRDIDCa093777oh8r2dtw6 base-4.17.2.1
    base64-bytestring-1.2.1.0-Cf5znIQf1Nf25Cl2XqzapR
    bytestring-0.11.5.3 case-insensitive-1.2.1.0-9yImpzTIYpBJ0v1fZqtWOj
    cassava-0.5.4.1-Am7I90DshtWFMbJHsNdSBr
    configurator-pg-0.2.10-HW18P2lHQHOIkuZ2mHG56k containers-0.6.7
    contravariant-extras-0.3.5.4-55ftugxfRMl5DZHT7luCXJ
    cookie-0.4.6-4shfaVKBFn0Hnep1ZY6FZw directory-1.3.7.1
    either-5.0.3-FOAbNcCNUjIJuj6gguErdR
    gitrev-1.3.1-KhpMNofwsxABRoyEGWB0ci
    hasql-1.5.0.5-1eKlqE7T7H581ic5cSl9sm
    hasql-dynamic-statements-0.3.1.1-GAlOyQcIKMSEygDcEWEnQ3
    hasql-notifications-0.2.0.5-F184mvMhbJQ4uiwrhNNsDb
    hasql-pool-0.5.2.2-Hh4DArymHaXI1GhKUjvVi8
    hasql-transaction-1.0.1.1-Jji9UYhtNRS1i9sTMB0Ido
    heredoc-0.2.0.0-77nW0mrU6iW6fQsJ6nWzcx
    http-types-0.12.4-JKUCrzdlATTa7w8tKVNt1
    insert-ordered-containers-0.2.5.3-IgitC7BL3XY9KCqdJaGOMf
    interpolatedstring-perl6-1.0.2-5kH62JH2CaO4F7uPIfHvmR
    jose-0.10-4dlDGcoWp9oJs9tQaibFO3 lens-5.3.1-39Rj9LQQhPID4B1jmyDMFk
    lens-aeson-1.2.3-ImgfeO1NDPiC4L5xLA9B3j mtl-2.2.2
    network-3.1.4.0-DD61ZgteIR5Dyq0QRyt6FX
    network-uri-2.6.4.2-IX03DIUVxPAG8S8nkSZaDU
    optparse-applicative-0.18.1.0-6vzfjdGcscpK23HoS6KcvN
    parsec-3.1.16.1 protolude-0.3.5-BWPCFWXx8LO53ZJoag3McH
    regex-tdfa-1.3.2.4-IrQPD9ooo505JdGPODvYYe
    retry-0.9.3.1-G8xlPGNUlTC5GfDfTXIz1h
    scientific-0.3.8.0-5VCcSe8kMhaKTje3aOa6OL
    swagger2-2.8.10-8yUr80b9FKl4P08BsC2Vew text-2.0.2 time-1.12.2
    unix-2.7.3 unordered-containers-0.2.20-8cMd7edANcDBeBDjVdjsZY
    vault-0.3.1.5-6UmuJgWVQvVCusLAgdNl2b
    vector-0.13.2.0-4gUGda2ISIbCv9ACnxMPCL
    wai-3.2.4-9F025KLztrGD7Hr5xRYA73
    wai-cors-0.2.7-GdNYcZUF8qt45NMuJQx4z3
    wai-extra-3.1.17-CEHyRGVaNjy2F1ffZ5B4e0
    wai-logger-2.5.0-Gh2gpfC4ZcSDfUKGg6Y5MV
    warp-3.3.30-72Ydn4shR1tASFwwoxKSFx

haddock-interfaces:   /usr/share/doc/postgrest/html/postgrest.haddock
haddock-html:         /usr/share/doc/postgrest/html
' | '/usr/bin/ghc-pkg-9.4.8' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

