#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
printf '%s' 'name:                 postgrest
version:              10.0.0
visibility:           public
id:                   postgrest-10.0.0-Iil83AKTlqe1DJABm84Bw6
key:                  postgrest-10.0.0-Iil83AKTlqe1DJABm84Bw6
license:              MIT
maintainer:           Steve Chavez <stevechavezast@gmail.com>
author:               Joe Nelson, Adam Baker, Steve Chavez
homepage:             https://postgrest.org
synopsis:             REST API for any Postgres database
description:
    Reads the schema of a PostgreSQL database and creates RESTful routes
    for tables, views, and functions, supporting all HTTP methods that security
    permits.

category:             Executable, PostgreSQL, Network APIs
abi:                  88df514b192326cce9f2247661091ae7
exposed:              True
exposed-modules:
    PostgREST.Admin PostgREST.App PostgREST.AppState PostgREST.Auth
    PostgREST.CLI PostgREST.Config PostgREST.Config.Database
    PostgREST.Config.JSPath PostgREST.Config.PgVersion
    PostgREST.Config.Proxy PostgREST.Cors PostgREST.DbStructure
    PostgREST.DbStructure.Identifiers PostgREST.DbStructure.Proc
    PostgREST.DbStructure.Relationship PostgREST.DbStructure.Table
    PostgREST.Error PostgREST.GucHeader PostgREST.Logger
    PostgREST.MediaType PostgREST.Middleware PostgREST.OpenAPI
    PostgREST.Query.QueryBuilder PostgREST.Query.SqlFragment
    PostgREST.Query.Statements PostgREST.RangeQuery
    PostgREST.Request.ApiRequest PostgREST.Request.DbRequestBuilder
    PostgREST.Request.MutateQuery PostgREST.Request.Preferences
    PostgREST.Request.QueryParams PostgREST.Request.ReadQuery
    PostgREST.Request.Types PostgREST.Unix PostgREST.Version
    PostgREST.Workers

hidden-modules:       Paths_postgrest
import-dirs:          /usr/lib/ghc-9.4.8/site-local/postgrest-10.0.0
library-dirs:         /usr/lib/ghc-9.4.8/site-local/postgrest-10.0.0
library-dirs-static:  /usr/lib/ghc-9.4.8/site-local/postgrest-10.0.0
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/postgrest
hs-libraries:         HSpostgrest-10.0.0-Iil83AKTlqe1DJABm84Bw6
depends:
    HTTP-4000.4.1-fhsazK8lEc3bYJPWWjSWL
    Ranged-sets-0.5.0-8fGHiaPra04C3Wt5MczuUK
    aeson-2.1.2.1-Eu0ZMA1fvZJ7acphaZ1YUp
    auto-update-0.1.6-LlVRr0TLjkdDwdz2uDRmdx base-4.17.2.1
    base64-bytestring-1.2.1.0-9yKKMU9vx4T3mbm91B7Hi9
    bytestring-0.11.5.3 case-insensitive-1.2.1.0-ELM66iRIeZm6Dg1Td1yG95
    cassava-0.5.4.1-F1QcoJtq6317FXXkU2DiVD
    configurator-pg-0.2.10-Cf25Vv56v2sAuqfqfKPLjB containers-0.6.7
    contravariant-extras-0.3.5.4-55ftugxfRMl5DZHT7luCXJ
    cookie-0.4.6-4shfaVKBFn0Hnep1ZY6FZw directory-1.3.7.1
    either-5.0.3-Dt1znj70bMfI4ry68g47tW
    gitrev-1.3.1-KhpMNofwsxABRoyEGWB0ci
    hasql-1.5.0.5-LiD7OlP0omH9llras0239g
    hasql-dynamic-statements-0.3.1.1-EbJLlnB4mraJzAj83xiXXw
    hasql-notifications-0.2.0.5-40lFqwvxgMU3D5MKhGqCxh
    hasql-pool-0.5.2.2-Bieh5fYfqsv8Uip6RRKoYl
    hasql-transaction-1.0.1.1-9OLBWlOQuzb6GSJO8dmqcT
    heredoc-0.2.0.0-77nW0mrU6iW6fQsJ6nWzcx
    http-types-0.12.4-AxSTuELtXS8Ebx20Rd9Bgd
    insert-ordered-containers-0.2.5.3-2fZfudvxd7RJ9mrOHVaUe0
    interpolatedstring-perl6-1.0.2-JXksNN7HR5C6MxImReRZp0
    jose-0.10-6jnMhsN7cOXHYdNSPXl4yt lens-5.3.1-58EqPfReeF86v3dzDdfR9b
    lens-aeson-1.2.3-BaCo9OENrt3ARivp4GXJ4n mtl-2.2.2
    network-3.1.4.0-L9DLhdoHw8O9GdA4IbhXs2
    network-uri-2.6.4.2-E8aEaRQxCxy3qJUPBltH5o
    optparse-applicative-0.18.1.0-9usJKW05Tg77TzGdDpbTqq
    parsec-3.1.16.1 protolude-0.3.5-LpNzpOyCrQ66C6Gtlpmiuy
    regex-tdfa-1.3.2.4-16fa8fV2J4jFJDn5KyghaT
    retry-0.9.3.1-8UBRDWDhzesC7PUIfSHKBk
    scientific-0.3.8.0-hGLqISimekA59HuDEk96u
    swagger2-2.8.10-5MmNEraD4Gv9jHEEnPNsnx text-2.0.2 time-1.12.2
    unix-2.7.3 unordered-containers-0.2.20-5YE9FG6zPmjDjdA4DCPpEY
    vault-0.3.1.5-J0UKMyPUHu45nzwxMS53Vf
    vector-0.13.2.0-2If6MrCrP3g55Bnhb5dowG
    wai-3.2.4-5nckpzENK0CITF1tUzznAA
    wai-cors-0.2.7-LIT1zmLFmcIGARasyzMPMT
    wai-extra-3.1.17-271UiLK3K4lFcIHbg0sbId
    wai-logger-2.5.0-DRDzCN6HV6BGiRAKoO9nYQ
    warp-3.3.30-5OdaTs6JLvo2UVMHgrNCap

haddock-interfaces:   /usr/share/doc/postgrest/html/postgrest.haddock
haddock-html:         /usr/share/doc/postgrest/html
' | '/usr/bin/ghc-pkg-9.4.8' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

