#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
printf '%s' 'name:                 postgrest
version:              10.0.0
visibility:           public
id:                   postgrest-10.0.0-2C03DQwMGEo8VJnNLc8CF2
key:                  postgrest-10.0.0-2C03DQwMGEo8VJnNLc8CF2
license:              MIT
maintainer:           Steve Chavez <stevechavezast@gmail.com>
author:               Joe Nelson, Adam Baker, Steve Chavez
homepage:             https://postgrest.org
synopsis:             REST API for any Postgres database
description:
    Reads the schema of a PostgreSQL database and creates RESTful routes
    for tables, views, and functions, supporting all HTTP methods that security
    permits.

category:             Executable, PostgreSQL, Network APIs
abi:                  7aa1df9c6804fe51f30573e2f4cff8af
exposed:              True
exposed-modules:
    PostgREST.Admin PostgREST.App PostgREST.AppState PostgREST.Auth
    PostgREST.CLI PostgREST.Config PostgREST.Config.Database
    PostgREST.Config.JSPath PostgREST.Config.PgVersion
    PostgREST.Config.Proxy PostgREST.Cors PostgREST.DbStructure
    PostgREST.DbStructure.Identifiers PostgREST.DbStructure.Proc
    PostgREST.DbStructure.Relationship PostgREST.DbStructure.Table
    PostgREST.Error PostgREST.GucHeader PostgREST.Logger
    PostgREST.MediaType PostgREST.Middleware PostgREST.OpenAPI
    PostgREST.Query.QueryBuilder PostgREST.Query.SqlFragment
    PostgREST.Query.Statements PostgREST.RangeQuery
    PostgREST.Request.ApiRequest PostgREST.Request.DbRequestBuilder
    PostgREST.Request.MutateQuery PostgREST.Request.Preferences
    PostgREST.Request.QueryParams PostgREST.Request.ReadQuery
    PostgREST.Request.Types PostgREST.Unix PostgREST.Version
    PostgREST.Workers

hidden-modules:       Paths_postgrest
import-dirs:          /usr/lib/ghc-9.4.8/site-local/postgrest-10.0.0
library-dirs:         /usr/lib/ghc-9.4.8/site-local/postgrest-10.0.0
library-dirs-static:  /usr/lib/ghc-9.4.8/site-local/postgrest-10.0.0
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/postgrest
hs-libraries:         HSpostgrest-10.0.0-2C03DQwMGEo8VJnNLc8CF2
depends:
    HTTP-4000.4.1-7z0jvPiC9TB7LhbGSk7V2F
    Ranged-sets-0.5.0-BYTIMUcFsDG7HzGPlqNg94
    aeson-2.1.2.1-J19dEw13kUOF5hLEOQVj2r
    auto-update-0.1.6-DzqdRHlgj8MKxvo08hmpuT base-4.17.2.1
    base64-bytestring-1.2.1.0-36j4xjYGwYUKFZDPcQTnk0
    bytestring-0.11.5.3 case-insensitive-1.2.1.0-A0C3sKUh8bjBoKTAh9uBrV
    cassava-0.5.4.1-BNDoLN1lMf8AZ6wmPn3FqZ
    configurator-pg-0.2.10-nYSDqMgovUDvVWSaHW2Fr containers-0.6.7
    contravariant-extras-0.3.5.4-55ftugxfRMl5DZHT7luCXJ
    cookie-0.4.6-4shfaVKBFn0Hnep1ZY6FZw directory-1.3.7.1
    either-5.0.3-27U4hIAlWIYEG8CtosP519
    gitrev-1.3.1-A894QJs696v2EtFduMnCKp
    hasql-1.5.0.5-Csu2d6Euo5KL1J4Rr59nmH
    hasql-dynamic-statements-0.3.1.1-BcZb4usnDmqLDfPmoCdkql
    hasql-notifications-0.2.0.5-CfqXvpQYOeTGN1Lkn558qH
    hasql-pool-0.5.2.2-IsDbGSE8sIjF0nNOc33gae
    hasql-transaction-1.0.1.1-3y9Y2evyF2ikbd0KAfoc3
    heredoc-0.2.0.0-77nW0mrU6iW6fQsJ6nWzcx
    http-types-0.12.4-3tEQsAXlW3W83gTXUT3vtQ
    insert-ordered-containers-0.2.5.3-x4EBRBMyKlXM7qXpcI8J
    interpolatedstring-perl6-1.0.2-JSBGKnRnbTCLiJHM2hc3Vk
    jose-0.10-ESjJLqLMUBXGGxYpwtCgFB lens-5.3.1-6s7OGBiqW0t1WJAI91dKgc
    lens-aeson-1.2.3-CJIwSE0nmg0DOtGz6PNkHl mtl-2.2.2
    network-3.1.4.0-Aot7Hsnd3no7HIoU7vrrpP
    network-uri-2.6.4.2-14hVMYCnjzx6Mshy3n2kRE
    optparse-applicative-0.18.1.0-FoUSxzMBUR5IeTMTUEotqz
    parsec-3.1.16.1 protolude-0.3.5-79T9jO64b5lCLKdsNBulRn
    regex-tdfa-1.3.2.4-It8kSvUca7pIUIDpZynqfd
    retry-0.9.3.1-L3imR22Vo0UHuKqlVJzVuw
    scientific-0.3.8.0-JD5EMEyFBUc5yMNfC55Oq6
    swagger2-2.8.10-2Q7Ufd2rZaa5o4bWOB2guF text-2.0.2 time-1.12.2
    unix-2.7.3 unordered-containers-0.2.20-1i1FNKzvn6TI2R1AzcNrcz
    vault-0.3.1.5-9F2znDF55xn4gkoElXRYZZ
    vector-0.13.2.0-FNdsFzivQrc5gVfjRMxS7n
    wai-3.2.4-FyKF4IGn0hJInObjv662sx
    wai-cors-0.2.7-9QBY3LjV73Y9QS3rcLn5k3
    wai-extra-3.1.17-GJnt0L70qq262BkWboBhQX
    wai-logger-2.5.0-LArnSwcWskkAT893JJd5io
    warp-3.3.30-CPK0BWevn9n1L9qMk5skmB

haddock-interfaces:   /usr/share/doc/postgrest/html/postgrest.haddock
haddock-html:         /usr/share/doc/postgrest/html
' | '/usr/bin/ghc-pkg-9.4.8' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

