#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
printf '%s' 'name:                 postgrest
version:              10.0.0
visibility:           public
id:                   postgrest-10.0.0-2i2hUudHqruBSyn6cj7zY6
key:                  postgrest-10.0.0-2i2hUudHqruBSyn6cj7zY6
license:              MIT
maintainer:           Steve Chavez <stevechavezast@gmail.com>
author:               Joe Nelson, Adam Baker, Steve Chavez
homepage:             https://postgrest.org
synopsis:             REST API for any Postgres database
description:
    Reads the schema of a PostgreSQL database and creates RESTful routes
    for tables, views, and functions, supporting all HTTP methods that security
    permits.

category:             Executable, PostgreSQL, Network APIs
abi:                  c837105437f6bf3b3ee337e69c88676d
exposed:              True
exposed-modules:
    PostgREST.Admin PostgREST.App PostgREST.AppState PostgREST.Auth
    PostgREST.CLI PostgREST.Config PostgREST.Config.Database
    PostgREST.Config.JSPath PostgREST.Config.PgVersion
    PostgREST.Config.Proxy PostgREST.Cors PostgREST.DbStructure
    PostgREST.DbStructure.Identifiers PostgREST.DbStructure.Proc
    PostgREST.DbStructure.Relationship PostgREST.DbStructure.Table
    PostgREST.Error PostgREST.GucHeader PostgREST.Logger
    PostgREST.MediaType PostgREST.Middleware PostgREST.OpenAPI
    PostgREST.Query.QueryBuilder PostgREST.Query.SqlFragment
    PostgREST.Query.Statements PostgREST.RangeQuery
    PostgREST.Request.ApiRequest PostgREST.Request.DbRequestBuilder
    PostgREST.Request.MutateQuery PostgREST.Request.Preferences
    PostgREST.Request.QueryParams PostgREST.Request.ReadQuery
    PostgREST.Request.Types PostgREST.Unix PostgREST.Version
    PostgREST.Workers

hidden-modules:       Paths_postgrest
import-dirs:          /usr/lib/ghc-9.4.8/site-local/postgrest-10.0.0
library-dirs:         /usr/lib/ghc-9.4.8/site-local/postgrest-10.0.0
library-dirs-static:  /usr/lib/ghc-9.4.8/site-local/postgrest-10.0.0
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/postgrest
hs-libraries:         HSpostgrest-10.0.0-2i2hUudHqruBSyn6cj7zY6
depends:
    HTTP-4000.4.1-IL47zdgJJ1J9eJ3SFNbkxB
    Ranged-sets-0.5.0-HiTIRtaYEtXEz8N70UL9nn
    aeson-2.1.2.1-4ODQ1UQyjV4HqW8vjPOsEA
    auto-update-0.1.6-9I0nptitzgj4nyG03C8kv4 base-4.17.2.1
    base64-bytestring-1.2.1.0-LWeAHO93Hqh8w1c79M45du
    bytestring-0.11.5.3 case-insensitive-1.2.1.0-6fVgEt7vrFc1sDHTeWeWXd
    cassava-0.5.4.1-Glq4i28JePC4SrwZhjXu49
    configurator-pg-0.2.10-theFDRSpSlItChZebPhqq containers-0.6.7
    contravariant-extras-0.3.5.4-55ftugxfRMl5DZHT7luCXJ
    cookie-0.4.6-GZOZqzUDn152OuhEYvht8s directory-1.3.7.1
    either-5.0.3-9LFBcehmdk7BiW9XTQtRz2
    gitrev-1.3.1-A894QJs696v2EtFduMnCKp
    hasql-1.5.0.5-DjDwrSlZvVDGo2JSnqIHOG
    hasql-dynamic-statements-0.3.1.1-83OlJuAbejp2pEX8kEwAWa
    hasql-notifications-0.2.0.5-BqzwwdnzpBr7IEgdTmIxf2
    hasql-pool-0.5.2.2-HnqJEhaWwuc31gr5hAqHvb
    hasql-transaction-1.0.1.1-CBIeyUNQ7UUHIxZAT9jEzb
    heredoc-0.2.0.0-77nW0mrU6iW6fQsJ6nWzcx
    http-types-0.12.4-ALPJWcgMeIc83stb9QW9Gl
    insert-ordered-containers-0.2.5.3-11EcRIoAymsDLwQIjocJtz
    interpolatedstring-perl6-1.0.2-Hfyb4Wl0p9wCrWGsIIdCA4
    jose-0.10-G5FHxgFpF7AGMVWgitwo3m lens-5.3.1-9oQplfPnoWr2g52V8zm4go
    lens-aeson-1.2.3-3uAjlWHiETy1EeUzLubJgn mtl-2.2.2
    network-3.1.4.0-9ZkyLgutzTZFWrHs4BgIgX
    network-uri-2.6.4.2-HOjMWSH0yhpFPW7mMXqod2
    optparse-applicative-0.18.1.0-LtQWPLKmjlx59fIGxpWSti
    parsec-3.1.16.1 protolude-0.3.5-Ef0UA824PLaDazc2S1OMAQ
    regex-tdfa-1.3.2.4-F7fHSRmw2rGDNk5aODvyIV
    retry-0.9.3.1-Gij1gMwmZpjCIdOmgjG0V4
    scientific-0.3.8.0-KN45uED49ez8IbcjYjrLBN
    swagger2-2.8.10-BfXsdYdLnIa9MglqzWI3YP text-2.0.2 time-1.12.2
    unix-2.7.3 unordered-containers-0.2.20-7dvM9aaOf5JATet72j0BPX
    vault-0.3.1.5-CTjOjF3XCYQ6kwMWZaG9wF
    vector-0.13.2.0-JDMr93x2QgFDQPvksTJZzq
    wai-3.2.4-1yop7BvplydTH1djBo1do
    wai-cors-0.2.7-9bCH1NveGicFjiBDsjSJu7
    wai-extra-3.1.17-BqkJjRoAdGnJ0inpYtyqgr
    wai-logger-2.5.0-Bm7gYwxMLa88eyg9o3QemB
    warp-3.3.30-8OpZYlaRw56DjKQnzqAXnQ

haddock-interfaces:   /usr/share/doc/postgrest/html/postgrest.haddock
haddock-html:         /usr/share/doc/postgrest/html
' | '/usr/bin/ghc-pkg-9.4.8' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

