#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
printf '%s' 'name:                 postgrest
version:              10.0.0
visibility:           public
id:                   postgrest-10.0.0-Z9Cq75QUCT5rXDVUmmmxI
key:                  postgrest-10.0.0-Z9Cq75QUCT5rXDVUmmmxI
license:              MIT
maintainer:           Steve Chavez <stevechavezast@gmail.com>
author:               Joe Nelson, Adam Baker, Steve Chavez
homepage:             https://postgrest.org
synopsis:             REST API for any Postgres database
description:
    Reads the schema of a PostgreSQL database and creates RESTful routes
    for tables, views, and functions, supporting all HTTP methods that security
    permits.

category:             Executable, PostgreSQL, Network APIs
abi:                  3d328a3e6ed29fff019897cc764a0dd1
exposed:              True
exposed-modules:
    PostgREST.Admin PostgREST.App PostgREST.AppState PostgREST.Auth
    PostgREST.CLI PostgREST.Config PostgREST.Config.Database
    PostgREST.Config.JSPath PostgREST.Config.PgVersion
    PostgREST.Config.Proxy PostgREST.Cors PostgREST.DbStructure
    PostgREST.DbStructure.Identifiers PostgREST.DbStructure.Proc
    PostgREST.DbStructure.Relationship PostgREST.DbStructure.Table
    PostgREST.Error PostgREST.GucHeader PostgREST.Logger
    PostgREST.MediaType PostgREST.Middleware PostgREST.OpenAPI
    PostgREST.Query.QueryBuilder PostgREST.Query.SqlFragment
    PostgREST.Query.Statements PostgREST.RangeQuery
    PostgREST.Request.ApiRequest PostgREST.Request.DbRequestBuilder
    PostgREST.Request.MutateQuery PostgREST.Request.Preferences
    PostgREST.Request.QueryParams PostgREST.Request.ReadQuery
    PostgREST.Request.Types PostgREST.Unix PostgREST.Version
    PostgREST.Workers

hidden-modules:       Paths_postgrest
import-dirs:          /usr/lib/ghc-9.4.8/site-local/postgrest-10.0.0
library-dirs:         /usr/lib/ghc-9.4.8/site-local/postgrest-10.0.0
library-dirs-static:  /usr/lib/ghc-9.4.8/site-local/postgrest-10.0.0
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/postgrest
hs-libraries:         HSpostgrest-10.0.0-Z9Cq75QUCT5rXDVUmmmxI
depends:
    HTTP-4000.4.1-K9z9SDe9mMBASKCmqGLgM1
    Ranged-sets-0.5.0-DifAo6lgZ925202DwNnBTp
    aeson-2.1.2.1-BWqAP5DPS0iMNSAJtMWSf
    auto-update-0.1.6-D40UjkBlvMhDm4ql9hejYm base-4.17.2.1
    base64-bytestring-1.2.1.0-3xTWh9pwP9a781vByOHbcb
    bytestring-0.11.5.3 case-insensitive-1.2.1.0-GKEaqjX3nXNEZmMRebSTRD
    cassava-0.5.4.0-KuoNFxrtELQCIk2ofC4m3P
    configurator-pg-0.2.10-BbRgTeGs9vY1Ke4WJr8xlo containers-0.6.7
    contravariant-extras-0.3.5.4-55ftugxfRMl5DZHT7luCXJ
    cookie-0.4.6-GZOZqzUDn152OuhEYvht8s directory-1.3.7.1
    either-5.0.3-Jcf6sU2rPLkCKL4N9yh4Qm
    gitrev-1.3.1-A894QJs696v2EtFduMnCKp
    hasql-1.5.0.5-HP2n9fKVzrRC6UjAvL52TB
    hasql-dynamic-statements-0.3.1.1-3mBfc8GS2L47hUTmquPjY7
    hasql-notifications-0.2.0.5-6TXL4kB64kBCuNqYqoVMfP
    hasql-pool-0.5.2.2-AbHLTfp01SzuNQVbfgdfr
    hasql-transaction-1.0.1.1-2VW3HzB7Jn6B8L0vFUFDh7
    heredoc-0.2.0.0-77nW0mrU6iW6fQsJ6nWzcx
    http-types-0.12.4-JotGc98QwUtHuX8PPdlxoe
    insert-ordered-containers-0.2.5.3-FZcAVKSYbCW6DJP9tau6z9
    interpolatedstring-perl6-1.0.2-1CzGnnjHK1CafTH9PugzU
    jose-0.10-CVPlChHyapxEwcc4toOvgX lens-5.3.1-L3T26fDKV8KAh84K9wN8lF
    lens-aeson-1.2.3-KWiYOe6FBiU7YWlmSdru4U mtl-2.2.2
    network-3.1.4.0-Be19ySMD4vC3IuDyb1IMcQ
    network-uri-2.6.4.2-CScpRPfTOboAxTStoroPUs
    optparse-applicative-0.18.1.0-3iEgSETSoiB1QksrTAD8kN
    parsec-3.1.16.1 protolude-0.3.5-GYlX9KFqwoBFDOOmzKsYBl
    regex-tdfa-1.3.2.4-JxlpWSNK7Gn8iVLoEpbxIK
    retry-0.9.3.1-9lnD42PXd6vItPsL1GUodX
    scientific-0.3.8.0-Lr1UPzAneM96vFGoFLDTYK
    swagger2-2.8.10-1Bbe9bxnpN01azByIi9Xjb text-2.0.2 time-1.12.2
    unix-2.7.3 unordered-containers-0.2.20-G9Xtyt8hv5K8HhfrH8JX1r
    vault-0.3.1.5-D4MACXKrN3LKGrCzCwFbMF
    vector-0.13.2.0-K0fBmK5qd7y3388236ZS0A
    wai-3.2.4-Jw3By0RvhPE8QsBvrL71Dx
    wai-cors-0.2.7-DbSV6gjVc1qCE4NhpqdKqO
    wai-extra-3.1.17-IcD7nw8NdejnVPbndikWQ
    wai-logger-2.5.0-2K7fRabkLQv8af8yJpv0qT
    warp-3.3.30-EhWqzNAs6m6FYN5Vdmx4dq

haddock-interfaces:   /usr/share/doc/postgrest/html/postgrest.haddock
haddock-html:         /usr/share/doc/postgrest/html
' | '/usr/bin/ghc-pkg-9.4.8' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

