#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
printf '%s' 'name:                 postgrest
version:              10.0.0
visibility:           public
id:                   postgrest-10.0.0-U2KAt3xANg94UKEWIIPYy
key:                  postgrest-10.0.0-U2KAt3xANg94UKEWIIPYy
license:              MIT
maintainer:           Steve Chavez <stevechavezast@gmail.com>
author:               Joe Nelson, Adam Baker, Steve Chavez
homepage:             https://postgrest.org
synopsis:             REST API for any Postgres database
description:
    Reads the schema of a PostgreSQL database and creates RESTful routes
    for tables, views, and functions, supporting all HTTP methods that security
    permits.

category:             Executable, PostgreSQL, Network APIs
abi:                  8620ad7bcb2a248bb34314d2a9998a1d
exposed:              True
exposed-modules:
    PostgREST.Admin PostgREST.App PostgREST.AppState PostgREST.Auth
    PostgREST.CLI PostgREST.Config PostgREST.Config.Database
    PostgREST.Config.JSPath PostgREST.Config.PgVersion
    PostgREST.Config.Proxy PostgREST.Cors PostgREST.DbStructure
    PostgREST.DbStructure.Identifiers PostgREST.DbStructure.Proc
    PostgREST.DbStructure.Relationship PostgREST.DbStructure.Table
    PostgREST.Error PostgREST.GucHeader PostgREST.Logger
    PostgREST.MediaType PostgREST.Middleware PostgREST.OpenAPI
    PostgREST.Query.QueryBuilder PostgREST.Query.SqlFragment
    PostgREST.Query.Statements PostgREST.RangeQuery
    PostgREST.Request.ApiRequest PostgREST.Request.DbRequestBuilder
    PostgREST.Request.MutateQuery PostgREST.Request.Preferences
    PostgREST.Request.QueryParams PostgREST.Request.ReadQuery
    PostgREST.Request.Types PostgREST.Unix PostgREST.Version
    PostgREST.Workers

hidden-modules:       Paths_postgrest
import-dirs:          /usr/lib/ghc-9.4.8/site-local/postgrest-10.0.0
library-dirs:         /usr/lib/ghc-9.4.8/site-local/postgrest-10.0.0
library-dirs-static:  /usr/lib/ghc-9.4.8/site-local/postgrest-10.0.0
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/postgrest
hs-libraries:         HSpostgrest-10.0.0-U2KAt3xANg94UKEWIIPYy
depends:
    HTTP-4000.4.1-AlxJrh8RSQCFQJop57pPCp
    Ranged-sets-0.5.0-E84eRNVsrL12X1P0oYgBJc
    aeson-2.1.2.1-2383fjET7FWJSHJW4VQuW
    auto-update-0.1.6-8m1PndiJkSTGePllfwmdtl base-4.17.2.1
    base64-bytestring-1.2.1.0-G53UOvB3pKB2mwL6yBWItW
    bytestring-0.11.5.3 case-insensitive-1.2.1.0-L5gSnJGPP5IIfg5Ct42zAo
    cassava-0.5.4.0-98LDwLZz10l6jrRwSpQAa8
    configurator-pg-0.2.10-JanT6Y57mnk9JZHLUpCcGt containers-0.6.7
    contravariant-extras-0.3.5.4-55ftugxfRMl5DZHT7luCXJ
    cookie-0.4.6-GZOZqzUDn152OuhEYvht8s directory-1.3.7.1
    either-5.0.3-Ff5UFzCu5N6FfWf3LTb21i
    gitrev-1.3.1-A894QJs696v2EtFduMnCKp
    hasql-1.5.0.5-Gq4SPMTcX2sFUYoFWBdV7r
    hasql-dynamic-statements-0.3.1.1-3tdKszcN8Yt9xRihHshXIm
    hasql-notifications-0.2.0.5-4u8EzeGnYEqGjxPvwUMFuK
    hasql-pool-0.5.2.2-Cr8Qlst788hHxKAcBIe5Qa
    hasql-transaction-1.0.1.1-AWBWCVJFHrWHvAi8brBfMU
    heredoc-0.2.0.0-77nW0mrU6iW6fQsJ6nWzcx
    http-types-0.12.4-J468GPAKalzFHPyn7Dxh3c
    insert-ordered-containers-0.2.5.3-5sDu2g7KmiN9dEFV8mZcS6
    interpolatedstring-perl6-1.0.2-KBU1pXWf5XE51EIkGKYapw
    jose-0.10-FB0KGHjezr8DNCm3VxtMps lens-5.3.1-1UDi0CjALHfJ5iQ7KsOF6H
    lens-aeson-1.2.3-D8dFjuAidnUC6bprkBHiFD mtl-2.2.2
    network-3.1.4.0-AsoxBmMP1pfJSzv0IgKvnl
    network-uri-2.6.4.2-JT5mjmfFxkg6DEC2jAgmZ6
    optparse-applicative-0.18.1.0-2d5KBqGSFxr6w2uOa2AvYP
    parsec-3.1.16.1 protolude-0.3.5-DnhN5Xkr1mO6ifpwGP6Xb0
    regex-tdfa-1.3.2.4-I1xViAJsheQFW1DER7LPSU
    retry-0.9.3.1-1kE7AFXGCIEKtcoICuE0mj
    scientific-0.3.8.0-IYXDhI1DsbO4omE9hYw4Ya
    swagger2-2.8.10-AstQmqwhyAGWfKU1BQwxo text-2.0.2 time-1.12.2
    unix-2.7.3 unordered-containers-0.2.20-AeV3HTkHtCc6BQ9fzLSSB8
    vault-0.3.1.5-3n1wOeCJswO3w8MM4Gys5M
    vector-0.13.2.0-52P7Ozt5w3I6hi4WvheJB9
    wai-3.2.4-9Kksr2P6n2618XIJvAeWn8
    wai-cors-0.2.7-UdEIerj4JC56dZHPKg7Na
    wai-extra-3.1.17-DbbspRqBNn1Hu4DLX8i4Mp
    wai-logger-2.5.0-IkF4j3cIAVeIGzDppsaJGt
    warp-3.3.30-Lffo76YbSESHPABPHs3Lg6

haddock-interfaces:   /usr/share/doc/postgrest/html/postgrest.haddock
haddock-html:         /usr/share/doc/postgrest/html
' | '/usr/bin/ghc-pkg-9.4.8' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

