#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
printf '%s' 'name:                 postgrest
version:              10.0.0
visibility:           public
id:                   postgrest-10.0.0-4r6Egk4mgKODHz1IA3E8Ny
key:                  postgrest-10.0.0-4r6Egk4mgKODHz1IA3E8Ny
license:              MIT
maintainer:           Steve Chavez <stevechavezast@gmail.com>
author:               Joe Nelson, Adam Baker, Steve Chavez
homepage:             https://postgrest.org
synopsis:             REST API for any Postgres database
description:
    Reads the schema of a PostgreSQL database and creates RESTful routes
    for tables, views, and functions, supporting all HTTP methods that security
    permits.

category:             Executable, PostgreSQL, Network APIs
abi:                  7417826c5ec5d207932db6cc0d636895
exposed:              True
exposed-modules:
    PostgREST.Admin PostgREST.App PostgREST.AppState PostgREST.Auth
    PostgREST.CLI PostgREST.Config PostgREST.Config.Database
    PostgREST.Config.JSPath PostgREST.Config.PgVersion
    PostgREST.Config.Proxy PostgREST.Cors PostgREST.DbStructure
    PostgREST.DbStructure.Identifiers PostgREST.DbStructure.Proc
    PostgREST.DbStructure.Relationship PostgREST.DbStructure.Table
    PostgREST.Error PostgREST.GucHeader PostgREST.Logger
    PostgREST.MediaType PostgREST.Middleware PostgREST.OpenAPI
    PostgREST.Query.QueryBuilder PostgREST.Query.SqlFragment
    PostgREST.Query.Statements PostgREST.RangeQuery
    PostgREST.Request.ApiRequest PostgREST.Request.DbRequestBuilder
    PostgREST.Request.MutateQuery PostgREST.Request.Preferences
    PostgREST.Request.QueryParams PostgREST.Request.ReadQuery
    PostgREST.Request.Types PostgREST.Unix PostgREST.Version
    PostgREST.Workers

hidden-modules:       Paths_postgrest
import-dirs:          /usr/lib/ghc-9.4.8/site-local/postgrest-10.0.0
library-dirs:         /usr/lib/ghc-9.4.8/site-local/postgrest-10.0.0
library-dirs-static:  /usr/lib/ghc-9.4.8/site-local/postgrest-10.0.0
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/postgrest
hs-libraries:         HSpostgrest-10.0.0-4r6Egk4mgKODHz1IA3E8Ny
depends:
    HTTP-4000.4.1-cxESqnQ5INHUQLfhPMkmP
    Ranged-sets-0.5.0-CG8R1zQO3z21Cor9UlsMaf
    aeson-2.1.2.1-8kv8xeVfmZaCzdZG9aqfKb
    auto-update-0.1.6-C3wX8nShst79DdbxYLc1Sj base-4.17.2.1
    base64-bytestring-1.2.1.0-3cCVQioh572KzPLHpOFxfQ
    bytestring-0.11.5.3 case-insensitive-1.2.1.0-KEDJwVxaVqqI97A4XPwej0
    cassava-0.5.4.0-IZdI51lC6AAJY71Z71Afbz
    configurator-pg-0.2.10-B9axTjo6eC0H291XOxoF7t containers-0.6.7
    contravariant-extras-0.3.5.4-55ftugxfRMl5DZHT7luCXJ
    cookie-0.4.6-GZOZqzUDn152OuhEYvht8s directory-1.3.7.1
    either-5.0.3-LIEalaJNK5HCYxNvsZbrPy
    gitrev-1.3.1-A894QJs696v2EtFduMnCKp
    hasql-1.5.0.5-BZHzJbVCc3X7kMw8DTWaBZ
    hasql-dynamic-statements-0.3.1.1-A8HBIHwjpMT8nyDBi3873T
    hasql-notifications-0.2.0.5-I4M2msZfIooJ8z69fP725g
    hasql-pool-0.5.2.2-91NYAm2QxyM8ODnqXqWN06
    hasql-transaction-1.0.1.1-CEAYnM5FJi1G4qZgTclIGL
    heredoc-0.2.0.0-77nW0mrU6iW6fQsJ6nWzcx
    http-types-0.12.4-5NSSMgOt7vT4e8131JaEsZ
    insert-ordered-containers-0.2.5.3-Js2dUfD2vwEDBjVT2ne9iV
    interpolatedstring-perl6-1.0.2-EJdqRX8pMI0s0DWiMJYLB
    jose-0.10-DQXzDPzr6gyBkuRNTw0aCQ lens-5.3.1-EQU0Jo6uxppBYuhl3GuXTA
    lens-aeson-1.2.3-G6reMIpkDw5JFGwdBoo7ed mtl-2.2.2
    network-3.1.4.0-HNOpCulLIRrH0UV3cvGeTA
    network-uri-2.6.4.2-4Or7NcWT1BFGL9jaSnxRbG
    optparse-applicative-0.18.1.0-6krVryETStC73hI3cDgd1Y
    parsec-3.1.16.1 protolude-0.3.5-Icd0jE3VSUX5D6rJMeZ0Ad
    regex-tdfa-1.3.2.4-4v18KqMgCkG8zIhzTwZAyQ
    retry-0.9.3.1-5xo7GcP1PGDD02FaZ43hls
    scientific-0.3.8.0-4NIM1ptKK7Y3EgpQdVTV5l
    swagger2-2.8.10-1OFDFoBOHfvAK6UPr4u20H text-2.0.2 time-1.12.2
    unix-2.7.3 unordered-containers-0.2.20-IhcdMC6aki1KSQ4zttUKBR
    vault-0.3.1.5-27fSOZWfm5zArXo1A19Jw2
    vector-0.13.2.0-B39FQf4cXUZ2GlwNF0TDTd
    wai-3.2.4-IYJEpaLCFRy2DnKDSvDPLZ
    wai-cors-0.2.7-9UOH4d0qihF7uQXLafvPzR
    wai-extra-3.1.17-34UEZRXaQ4Z4guZCTy0CSv
    wai-logger-2.5.0-KwG8tP7T7rVA1E2jG2tWJz
    warp-3.3.30-GlvU5xpqkS70ZBvoUTEZJ

haddock-interfaces:   /usr/share/doc/postgrest/html/postgrest.haddock
haddock-html:         /usr/share/doc/postgrest/html
' | '/usr/bin/ghc-pkg-9.4.8' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

