#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
printf '%s' 'name:                 postgrest
version:              10.0.0
visibility:           public
id:                   postgrest-10.0.0-HNErnBJ2x7U44Luw96vXnq
key:                  postgrest-10.0.0-HNErnBJ2x7U44Luw96vXnq
license:              MIT
maintainer:           Steve Chavez <stevechavezast@gmail.com>
author:               Joe Nelson, Adam Baker, Steve Chavez
homepage:             https://postgrest.org
synopsis:             REST API for any Postgres database
description:
    Reads the schema of a PostgreSQL database and creates RESTful routes
    for tables, views, and functions, supporting all HTTP methods that security
    permits.

category:             Executable, PostgreSQL, Network APIs
abi:                  080b4d8dd7ed1e618d7685b1ea18cd02
exposed:              True
exposed-modules:
    PostgREST.Admin PostgREST.App PostgREST.AppState PostgREST.Auth
    PostgREST.CLI PostgREST.Config PostgREST.Config.Database
    PostgREST.Config.JSPath PostgREST.Config.PgVersion
    PostgREST.Config.Proxy PostgREST.Cors PostgREST.DbStructure
    PostgREST.DbStructure.Identifiers PostgREST.DbStructure.Proc
    PostgREST.DbStructure.Relationship PostgREST.DbStructure.Table
    PostgREST.Error PostgREST.GucHeader PostgREST.Logger
    PostgREST.MediaType PostgREST.Middleware PostgREST.OpenAPI
    PostgREST.Query.QueryBuilder PostgREST.Query.SqlFragment
    PostgREST.Query.Statements PostgREST.RangeQuery
    PostgREST.Request.ApiRequest PostgREST.Request.DbRequestBuilder
    PostgREST.Request.MutateQuery PostgREST.Request.Preferences
    PostgREST.Request.QueryParams PostgREST.Request.ReadQuery
    PostgREST.Request.Types PostgREST.Unix PostgREST.Version
    PostgREST.Workers

hidden-modules:       Paths_postgrest
import-dirs:          /usr/lib/ghc-9.4.8/site-local/postgrest-10.0.0
library-dirs:         /usr/lib/ghc-9.4.8/site-local/postgrest-10.0.0
library-dirs-static:  /usr/lib/ghc-9.4.8/site-local/postgrest-10.0.0
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/postgrest
hs-libraries:         HSpostgrest-10.0.0-HNErnBJ2x7U44Luw96vXnq
depends:
    HTTP-4000.4.1-IRtsEgIm05q2nlEKgGiC4m
    Ranged-sets-0.5.0-j8a8PisHcL9HBzRADmpbd
    aeson-2.1.2.1-6q2KNYwRaL29rPm6MMaiUC
    auto-update-0.1.6-4EwojgBw75SA0JTg40OaHI base-4.17.2.1
    base64-bytestring-1.2.1.0-ITj2xakY1ml2q5A6QmvnkU
    bytestring-0.11.5.3 case-insensitive-1.2.1.0-fOfWi0N5mt64FY3ZUEjlf
    cassava-0.5.4.0-Bj1YOEnsPcG2yBOoA2RQ6M
    configurator-pg-0.2.10-Aqb1QEY9iR84Z2JUZ8L26i containers-0.6.7
    contravariant-extras-0.3.5.4-55ftugxfRMl5DZHT7luCXJ
    cookie-0.4.6-GZOZqzUDn152OuhEYvht8s directory-1.3.7.1
    either-5.0.3-KvoMqZPL24oBBecsypeEJP
    gitrev-1.3.1-HLNMuiuWFFhIgYmYImJML
    hasql-1.5.0.5-Hr5jAfW8eR9DvNojKOjNql
    hasql-dynamic-statements-0.3.1.1-KrRYgJcjJKkJtpBcHiglxf
    hasql-notifications-0.2.0.5-jOdBZHKEnrCLYxw3ymxW4
    hasql-pool-0.5.2.2-GJ0LOQzHdo2FjuSgObYaJC
    hasql-transaction-1.0.1.1-HQYCheCaKIi67nsz2XECZb
    heredoc-0.2.0.0-77nW0mrU6iW6fQsJ6nWzcx
    http-types-0.12.4-DI0pM0gIACkLbu0K6LN6Y6
    insert-ordered-containers-0.2.5.3-ACdYoIzhbNh9lVkFjldwit
    interpolatedstring-perl6-1.0.2-67o1ubKrRJhB7TcOuQ67Un
    jose-0.10-AgDH1cA2gdUFcFPeURLbAB lens-5.3.1-LF4jCoE0w776e2gq32lhyl
    lens-aeson-1.2.3-9dwUzI4oQGk3Uc8KSsgwt6 mtl-2.2.2
    network-3.1.4.0-1Bok7DDOmdQ7OlyZLPDJ7H
    network-uri-2.6.4.2-4guMK9PpDjI4XiQikAf4nE
    optparse-applicative-0.18.1.0-B5S7p3yvcpkHKfw0kuCuBU
    parsec-3.1.16.1 protolude-0.3.5-9NCprurN6HS2MRIv8k37M3
    regex-tdfa-1.3.2.4-DzgOWHlgf3T5HZBC9uVz6f
    retry-0.9.3.1-IfAYmHbTraxDSqGQg88FxE
    scientific-0.3.8.0-KXoba1fOMYH676R2WXZfYW
    swagger2-2.8.10-I2SCVwTbebf8EfOYgAkTUL text-2.0.2 time-1.12.2
    unix-2.7.3 unordered-containers-0.2.20-3NcLl7S6t7kAuh7l4Ieeoo
    vault-0.3.1.5-CExWMxr502e35RshbhnmPy
    vector-0.13.2.0-CQ8QMV1t4PN5YFZtNXivGS
    wai-3.2.4-3rFOvZ8NgHlICB5dLUJnHJ
    wai-cors-0.2.7-CTIFSUkb32w1oDWH7Pe7XG
    wai-extra-3.1.17-90f00E6MyEx2gZnYlOGtEN
    wai-logger-2.5.0-JWxVa0CPcI1rTw62M9iTY
    warp-3.3.30-KAktcEKH8PzKpPkMeOiB8Q

haddock-interfaces:   /usr/share/doc/postgrest/html/postgrest.haddock
haddock-html:         /usr/share/doc/postgrest/html
' | '/usr/bin/ghc-pkg-9.4.8' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

