#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
printf '%s' 'name:                 postgrest
version:              10.0.0
visibility:           public
id:                   postgrest-10.0.0-CoSE65Gc0Sr4vmWYdwGQrb
key:                  postgrest-10.0.0-CoSE65Gc0Sr4vmWYdwGQrb
license:              MIT
maintainer:           Steve Chavez <stevechavezast@gmail.com>
author:               Joe Nelson, Adam Baker, Steve Chavez
homepage:             https://postgrest.org
synopsis:             REST API for any Postgres database
description:
    Reads the schema of a PostgreSQL database and creates RESTful routes
    for tables, views, and functions, supporting all HTTP methods that security
    permits.

category:             Executable, PostgreSQL, Network APIs
abi:                  199093dc80a7754e057d0dc70ae6d0b2
exposed:              True
exposed-modules:
    PostgREST.Admin PostgREST.App PostgREST.AppState PostgREST.Auth
    PostgREST.CLI PostgREST.Config PostgREST.Config.Database
    PostgREST.Config.JSPath PostgREST.Config.PgVersion
    PostgREST.Config.Proxy PostgREST.Cors PostgREST.DbStructure
    PostgREST.DbStructure.Identifiers PostgREST.DbStructure.Proc
    PostgREST.DbStructure.Relationship PostgREST.DbStructure.Table
    PostgREST.Error PostgREST.GucHeader PostgREST.Logger
    PostgREST.MediaType PostgREST.Middleware PostgREST.OpenAPI
    PostgREST.Query.QueryBuilder PostgREST.Query.SqlFragment
    PostgREST.Query.Statements PostgREST.RangeQuery
    PostgREST.Request.ApiRequest PostgREST.Request.DbRequestBuilder
    PostgREST.Request.MutateQuery PostgREST.Request.Preferences
    PostgREST.Request.QueryParams PostgREST.Request.ReadQuery
    PostgREST.Request.Types PostgREST.Unix PostgREST.Version
    PostgREST.Workers

hidden-modules:       Paths_postgrest
import-dirs:          /usr/lib/ghc-9.4.8/site-local/postgrest-10.0.0
library-dirs:         /usr/lib/ghc-9.4.8/site-local/postgrest-10.0.0
library-dirs-static:  /usr/lib/ghc-9.4.8/site-local/postgrest-10.0.0
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/postgrest
hs-libraries:         HSpostgrest-10.0.0-CoSE65Gc0Sr4vmWYdwGQrb
depends:
    HTTP-4000.4.1-Ix1w0BNbLlK51NY5iY9BjB
    Ranged-sets-0.5.0-69YhwitqMvN2TwndIX5DSF
    aeson-2.1.2.1-4XssoWP8s0tKPHSv4bO4jS
    auto-update-0.1.6-G44qdKLExObEOkkcQnbOTp base-4.17.2.1
    base64-bytestring-1.2.1.0-9K52dGT2jL1Hyh8Ww36box
    bytestring-0.11.5.3 case-insensitive-1.2.1.0-DJzIJZH4DdL5KuISGpY4ML
    cassava-0.5.4.0-FnvZEQ8p9Ma3zlxKhBsuTo
    configurator-pg-0.2.10-2fiIH1rBYqRKr00lf9JngW containers-0.6.7
    contravariant-extras-0.3.5.4-55ftugxfRMl5DZHT7luCXJ
    cookie-0.4.6-GZOZqzUDn152OuhEYvht8s directory-1.3.7.1
    either-5.0.3-CQREOefkOep2j6SUg8Be0m
    gitrev-1.3.1-HLNMuiuWFFhIgYmYImJML
    hasql-1.5.0.5-4s7P4qzFMoJO5eC5BTFj
    hasql-dynamic-statements-0.3.1.1-IEgQq7D7jKdEqV7lbwHaFc
    hasql-notifications-0.2.0.5-J1nPdncUMI78TXMN6x9zUv
    hasql-pool-0.5.2.2-ISQ8s10jFKK4y1BcXVH94x
    hasql-transaction-1.0.1.1-KiumorgtxyL8cJIp5iP2sS
    heredoc-0.2.0.0-77nW0mrU6iW6fQsJ6nWzcx
    http-types-0.12.4-2RoTdpR4Maj5iH1GQnMeig
    insert-ordered-containers-0.2.5.3-AjwErXGfATD1BzJUHXwN9f
    interpolatedstring-perl6-1.0.2-A5Rla3pZa4pGZbGZT0xl2Y
    jose-0.10-6mc1b6MT4A54pP0Mz7p4MG lens-5.3.1-EJGBiJ62DpEHaBgUJVPkQg
    lens-aeson-1.2.3-4vqjxbLvUrh2eV2TLflU9G mtl-2.2.2
    network-3.1.4.0-5uK3u4RW2BBBzIyfRS5Jps
    network-uri-2.6.4.2-2wmE2uZDcqIIgHOfFlXQyo
    optparse-applicative-0.18.1.0-1qQAtHv6qKDHnowaperQhI
    parsec-3.1.16.1 protolude-0.3.5-HzCAkE054ejEWLt3RjARhc
    regex-tdfa-1.3.2.4-EhX7jCEB4hYAzMd1ZradSc
    retry-0.9.3.1-FyJYvTbguVLGH1wi9aOJHc
    scientific-0.3.8.0-7k94WWHeF91KCJJx1troIA
    swagger2-2.8.10-3YvYA2V7Z3v1G2oOOkIXDq text-2.0.2 time-1.12.2
    unix-2.7.3 unordered-containers-0.2.20-3371VA61Be1CojVrkG24uM
    vault-0.3.1.5-13501RAmESa6IWjZvLzddK
    vector-0.13.2.0-EWs7nDhBFQF5RfgCWU6KmC
    wai-3.2.4-FUHxhH9mDYMACC6LG7bc57
    wai-cors-0.2.7-IWaAcAyNlD93P8GXWYaRZQ
    wai-extra-3.1.17-F37Uz7dHy2j8W9NfORn2rV
    wai-logger-2.5.0-2BhH7wGiYvi88jio5gQJ37
    warp-3.3.30-1ABydamOwnOA3Rbg2BzTMd

haddock-interfaces:   /usr/share/doc/postgrest/html/postgrest.haddock
haddock-html:         /usr/share/doc/postgrest/html
' | '/usr/bin/ghc-pkg-9.4.8' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

