#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
printf '%s' 'name:                 postgrest
version:              10.0.0
visibility:           public
id:                   postgrest-10.0.0-JdkVLElHLoDdgGDQWqv7x
key:                  postgrest-10.0.0-JdkVLElHLoDdgGDQWqv7x
license:              MIT
maintainer:           Steve Chavez <stevechavezast@gmail.com>
author:               Joe Nelson, Adam Baker, Steve Chavez
homepage:             https://postgrest.org
synopsis:             REST API for any Postgres database
description:
    Reads the schema of a PostgreSQL database and creates RESTful routes
    for tables, views, and functions, supporting all HTTP methods that security
    permits.

category:             Executable, PostgreSQL, Network APIs
abi:                  f0e7f9a7a88c961462bb1e8959bb7aee
exposed:              True
exposed-modules:
    PostgREST.Admin PostgREST.App PostgREST.AppState PostgREST.Auth
    PostgREST.CLI PostgREST.Config PostgREST.Config.Database
    PostgREST.Config.JSPath PostgREST.Config.PgVersion
    PostgREST.Config.Proxy PostgREST.Cors PostgREST.DbStructure
    PostgREST.DbStructure.Identifiers PostgREST.DbStructure.Proc
    PostgREST.DbStructure.Relationship PostgREST.DbStructure.Table
    PostgREST.Error PostgREST.GucHeader PostgREST.Logger
    PostgREST.MediaType PostgREST.Middleware PostgREST.OpenAPI
    PostgREST.Query.QueryBuilder PostgREST.Query.SqlFragment
    PostgREST.Query.Statements PostgREST.RangeQuery
    PostgREST.Request.ApiRequest PostgREST.Request.DbRequestBuilder
    PostgREST.Request.MutateQuery PostgREST.Request.Preferences
    PostgREST.Request.QueryParams PostgREST.Request.ReadQuery
    PostgREST.Request.Types PostgREST.Unix PostgREST.Version
    PostgREST.Workers

hidden-modules:       Paths_postgrest
import-dirs:          /usr/lib/ghc-9.4.8/site-local/postgrest-10.0.0
library-dirs:         /usr/lib/ghc-9.4.8/site-local/postgrest-10.0.0
library-dirs-static:  /usr/lib/ghc-9.4.8/site-local/postgrest-10.0.0
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/postgrest
hs-libraries:         HSpostgrest-10.0.0-JdkVLElHLoDdgGDQWqv7x
depends:
    HTTP-4000.4.1-GyWDBCTmYDtCj8NhPE3XYb
    Ranged-sets-0.5.0-IMONu2d0QDt3jQipyqb3Rn
    aeson-2.1.2.1-LDc25PpdH5WHlLB8Mcp2Rh
    auto-update-0.1.6-37Xvfuet9Yb6GfANtRxUfc base-4.17.2.1
    base64-bytestring-1.2.1.0-7XHgmf0PZMy7LO91awCYGH
    bytestring-0.11.5.3 case-insensitive-1.2.1.0-1RHeXy1S6Rm5Spie3OUbmD
    cassava-0.5.4.0-8KHqa2xifEiGDVpKKEyXep
    configurator-pg-0.2.10-7zL1EZIEf6qHYUnkGYWsAV containers-0.6.7
    contravariant-extras-0.3.5.4-55ftugxfRMl5DZHT7luCXJ
    cookie-0.4.6-GZOZqzUDn152OuhEYvht8s directory-1.3.7.1
    either-5.0.3-5odMBcc62wYKnG3NIEf1TN
    gitrev-1.3.1-HLNMuiuWFFhIgYmYImJML
    hasql-1.5.0.5-Dy7naCKMSZYHVsiqB7uKLm
    hasql-dynamic-statements-0.3.1.1-H11T7VJLU37GQfrOIEquj7
    hasql-notifications-0.2.0.5-JJLTdXtQYPK3rurSdnc1KA
    hasql-pool-0.5.2.2-4yvYLJPy1Y1JYnNSbNZ8Zu
    hasql-transaction-1.0.1.1-9gmaaPDjhXGIUQb2GAZjMJ
    heredoc-0.2.0.0-77nW0mrU6iW6fQsJ6nWzcx
    http-types-0.12.4-AKSPjJIqePQLPw819bUb23
    insert-ordered-containers-0.2.5.3-9zVYXuVD6Nl8cuCg41tl9b
    interpolatedstring-perl6-1.0.2-FjvvtTGLHMZIYv5PEEiBiQ
    jose-0.10-FdDWsYiENVw3EHwrUyRpwS lens-5.3.1-3FYsDpCHEKEBLMSbQ9nAqF
    lens-aeson-1.2.3-WIFBhfh9YY2L3vu4luo7S mtl-2.2.2
    network-3.1.4.0-L5Z9Li45X29DmnCadSsbZW
    network-uri-2.6.4.2-HjnHIRdbGth3RAPPiFyOPG
    optparse-applicative-0.18.1.0-5z7uKq3kDhiFdyVMsq5grp
    parsec-3.1.16.1 protolude-0.3.5-4ooiQTdEuboEY7k1r4NwL2
    regex-tdfa-1.3.2.4-Ad5TdY6WlXxFUwxGz6iFnw
    retry-0.9.3.1-AhTEhfV1njG8AY1ydR45K2
    scientific-0.3.8.0-HUqAf4XaF5T5GawpMI5GwR
    swagger2-2.8.10-5Nr6jTQzRw42A9TCsBa81X text-2.0.2 time-1.12.2
    unix-2.7.3 unordered-containers-0.2.20-Cw2Ec4BgC4sInKE4e5RLSk
    vault-0.3.1.5-IyBAW2Ljg0WKhEAvtn2LmP
    vector-0.13.2.0-3jopdCx3MMLHVSrvHoDH9i
    wai-3.2.4-5NCCbE2MlhR8uTC9MRfmrk
    wai-cors-0.2.7-9BK8bKq5Liz6thVT45VPEg
    wai-extra-3.1.17-GxD8yd34eL3CJXZz7xIhMh
    wai-logger-2.5.0-7i8WiPDg30eE8D3u4kraql
    warp-3.3.30-yQgzpV7zRBGIgcxEF5wSw

haddock-interfaces:   /usr/share/doc/postgrest/html/postgrest.haddock
haddock-html:         /usr/share/doc/postgrest/html
' | '/usr/bin/ghc-pkg-9.4.8' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

