#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
printf '%s' 'name:                 postgrest
version:              10.0.0
visibility:           public
id:                   postgrest-10.0.0-LcalC0fBlmi5EdRAZ6Zd8t
key:                  postgrest-10.0.0-LcalC0fBlmi5EdRAZ6Zd8t
license:              MIT
maintainer:           Steve Chavez <stevechavezast@gmail.com>
author:               Joe Nelson, Adam Baker, Steve Chavez
homepage:             https://postgrest.org
synopsis:             REST API for any Postgres database
description:
    Reads the schema of a PostgreSQL database and creates RESTful routes
    for tables, views, and functions, supporting all HTTP methods that security
    permits.

category:             Executable, PostgreSQL, Network APIs
abi:                  54038c520d43e05b48f5d80f32edb844
exposed:              True
exposed-modules:
    PostgREST.Admin PostgREST.App PostgREST.AppState PostgREST.Auth
    PostgREST.CLI PostgREST.Config PostgREST.Config.Database
    PostgREST.Config.JSPath PostgREST.Config.PgVersion
    PostgREST.Config.Proxy PostgREST.Cors PostgREST.DbStructure
    PostgREST.DbStructure.Identifiers PostgREST.DbStructure.Proc
    PostgREST.DbStructure.Relationship PostgREST.DbStructure.Table
    PostgREST.Error PostgREST.GucHeader PostgREST.Logger
    PostgREST.MediaType PostgREST.Middleware PostgREST.OpenAPI
    PostgREST.Query.QueryBuilder PostgREST.Query.SqlFragment
    PostgREST.Query.Statements PostgREST.RangeQuery
    PostgREST.Request.ApiRequest PostgREST.Request.DbRequestBuilder
    PostgREST.Request.MutateQuery PostgREST.Request.Preferences
    PostgREST.Request.QueryParams PostgREST.Request.ReadQuery
    PostgREST.Request.Types PostgREST.Unix PostgREST.Version
    PostgREST.Workers

hidden-modules:       Paths_postgrest
import-dirs:          /usr/lib/ghc-9.4.8/site-local/postgrest-10.0.0
library-dirs:         /usr/lib/ghc-9.4.8/site-local/postgrest-10.0.0
library-dirs-static:  /usr/lib/ghc-9.4.8/site-local/postgrest-10.0.0
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/postgrest
hs-libraries:         HSpostgrest-10.0.0-LcalC0fBlmi5EdRAZ6Zd8t
depends:
    HTTP-4000.4.1-JDjC5ftEvPrIG7TAGh4Lza
    Ranged-sets-0.5.0-JLMFjUwRjti2m2aUsVRiTR
    aeson-2.1.2.1-9HQxGJjc2cdAmcsURaBDXL
    auto-update-0.1.6-5mYHo3pmEB67QraeKNk3qH base-4.17.2.1
    base64-bytestring-1.2.1.0-Jr4dnoqop9Z6dS9yQYn7ws
    bytestring-0.11.5.3 case-insensitive-1.2.1.0-KZI0Gb9gPGwAGX5pgA0Afl
    cassava-0.5.4.0-BXVdIWM9ICv6ujpjUuWpfX
    configurator-pg-0.2.10-AG0K5OMcl1KKkv0BBHIlxX containers-0.6.7
    contravariant-extras-0.3.5.4-55ftugxfRMl5DZHT7luCXJ
    cookie-0.4.6-GZOZqzUDn152OuhEYvht8s directory-1.3.7.1
    either-5.0.3-5mVOkpCOtMYKmn61yQAtvU
    gitrev-1.3.1-HLNMuiuWFFhIgYmYImJML
    hasql-1.5.0.5-HomVQCXKlWLElwrVHVzEfV
    hasql-dynamic-statements-0.3.1.1-JetQtEigWQpJ3DTmryVcID
    hasql-notifications-0.2.0.5-5VesMCoUTzAD8Fp46Tdz4m
    hasql-pool-0.5.2.2-DS6jizaIK2bJqLBzfqXqwd
    hasql-transaction-1.0.1.1-84bHbdvSls96KrnxnqSqhT
    heredoc-0.2.0.0-77nW0mrU6iW6fQsJ6nWzcx
    http-types-0.12.4-4OgDMOwQtyf2orXc9J8wsB
    insert-ordered-containers-0.2.5.3-8WyUOVAt8gGKfHuNTQk73b
    interpolatedstring-perl6-1.0.2-7jFuqya9ElfovaoViTFne
    jose-0.10-EeOoSyzbx5k7UtoB9GJuD7 lens-5.3-4nRD5AeUZ87C7qubjFyG6H
    lens-aeson-1.2.3-KuG6NsNnPRSEiB18VcY19S mtl-2.2.2
    network-3.1.4.0-ASj1hBk5tU17JSnFMFmeWy
    network-uri-2.6.4.2-4a4fvaL8hlS8iUTVwHnYtf
    optparse-applicative-0.18.1.0-BlJt1hxlxMsEFkCfzgQNK4
    parsec-3.1.16.1 protolude-0.3.5-LSZI0HHLnb1CGc7xLhkwoI
    regex-tdfa-1.3.2.4-5VzyiYRIxzjC7QH7QCwrYL
    retry-0.9.3.1-4k4Dh48597F10QvXR6yOJs
    scientific-0.3.8.0-3yGVBVyv6Qa6KG5OKC2ZxZ
    swagger2-2.8.10-Imsbf0N3TyBCf8vbleKery text-2.0.2 time-1.12.2
    unix-2.7.3 unordered-containers-0.2.20-3czZ5Len2GTFaAkRxFZe7E
    vault-0.3.1.5-HdgxYSuMcV15SDr26VY1xd
    vector-0.13.2.0-GTax7SJDHXyLP8P6Lzhygl
    wai-3.2.4-2xkfe4HZLaM7fVTIVWFd6J
    wai-cors-0.2.7-5mOJZ59uR7tDZLzMNYCIrJ
    wai-extra-3.1.17-GQs7pvOfSKsAfeSlozEWIr
    wai-logger-2.5.0-7IapYjqIpIzvJngZuvYMb
    warp-3.3.30-HIDLsUqSiJ7GvzYeI38eeS

haddock-interfaces:   /usr/share/doc/postgrest/html/postgrest.haddock
haddock-html:         /usr/share/doc/postgrest/html
' | '/usr/bin/ghc-pkg-9.4.8' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

