#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
printf '%s' 'name:                 postgrest
version:              10.0.0
visibility:           public
id:                   postgrest-10.0.0-6hOlSdeGPcO4hg6vzaujVv
key:                  postgrest-10.0.0-6hOlSdeGPcO4hg6vzaujVv
license:              MIT
maintainer:           Steve Chavez <stevechavezast@gmail.com>
author:               Joe Nelson, Adam Baker, Steve Chavez
homepage:             https://postgrest.org
synopsis:             REST API for any Postgres database
description:
    Reads the schema of a PostgreSQL database and creates RESTful routes
    for tables, views, and functions, supporting all HTTP methods that security
    permits.

category:             Executable, PostgreSQL, Network APIs
abi:                  96bbaee497d54385165e64ff81c7fb23
exposed:              True
exposed-modules:
    PostgREST.Admin PostgREST.App PostgREST.AppState PostgREST.Auth
    PostgREST.CLI PostgREST.Config PostgREST.Config.Database
    PostgREST.Config.JSPath PostgREST.Config.PgVersion
    PostgREST.Config.Proxy PostgREST.Cors PostgREST.DbStructure
    PostgREST.DbStructure.Identifiers PostgREST.DbStructure.Proc
    PostgREST.DbStructure.Relationship PostgREST.DbStructure.Table
    PostgREST.Error PostgREST.GucHeader PostgREST.Logger
    PostgREST.MediaType PostgREST.Middleware PostgREST.OpenAPI
    PostgREST.Query.QueryBuilder PostgREST.Query.SqlFragment
    PostgREST.Query.Statements PostgREST.RangeQuery
    PostgREST.Request.ApiRequest PostgREST.Request.DbRequestBuilder
    PostgREST.Request.MutateQuery PostgREST.Request.Preferences
    PostgREST.Request.QueryParams PostgREST.Request.ReadQuery
    PostgREST.Request.Types PostgREST.Unix PostgREST.Version
    PostgREST.Workers

hidden-modules:       Paths_postgrest
import-dirs:          /usr/lib/ghc-9.4.8/site-local/postgrest-10.0.0
library-dirs:         /usr/lib/ghc-9.4.8/site-local/postgrest-10.0.0
library-dirs-static:  /usr/lib/ghc-9.4.8/site-local/postgrest-10.0.0
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/postgrest
hs-libraries:         HSpostgrest-10.0.0-6hOlSdeGPcO4hg6vzaujVv
depends:
    HTTP-4000.4.1-ETvi70w5zfWJgueP9ScJka
    Ranged-sets-0.5.0-8lp7MJYTJ3MGojaCn0rZwO
    aeson-2.1.2.1-6LfdTurWC20A9IWYLs821k
    auto-update-0.1.6-AMi9WhCNVioBzSrb6Lfb8g base-4.17.2.1
    base64-bytestring-1.2.1.0-B7TpHxQlQ7x5xHtuAREw0z
    bytestring-0.11.5.3 case-insensitive-1.2.1.0-5l2QOpNdY1A6hVaz3nH17n
    cassava-0.5.4.0-8Q8oNf0FvCnFcuqWu3ckqC
    configurator-pg-0.2.10-6mzFdohO5iAFSHp68ubxjm containers-0.6.7
    contravariant-extras-0.3.5.4-55ftugxfRMl5DZHT7luCXJ
    cookie-0.4.6-GZOZqzUDn152OuhEYvht8s directory-1.3.7.1
    either-5.0.3-51OmDqe3WLj8XbZiB8kqF7
    gitrev-1.3.1-HLNMuiuWFFhIgYmYImJML
    hasql-1.5.0.5-9hzI1nJuJnOBUrbSel0Cty
    hasql-dynamic-statements-0.3.1.1-lZolJhlFhELqOJQNTFXfI
    hasql-notifications-0.2.0.5-FYHU4Lv96LHFHFVOUZf5GD
    hasql-pool-0.5.2.2-G9tOY0onb7WB3vKkbZZK0T
    hasql-transaction-1.0.1.1-3N74fATEd7Z4UXSCbvmpG2
    heredoc-0.2.0.0-77nW0mrU6iW6fQsJ6nWzcx
    http-types-0.12.4-1Pq1Zy5bmQBJRy3r5PsBE
    insert-ordered-containers-0.2.5.3-2EdwQcWKQhp2RUSkBELUMI
    interpolatedstring-perl6-1.0.2-AJbcTLIJkVGJnvges1Sa4M
    jose-0.10-CygHawHTLzdFiOitjqYeOY lens-5.3-LWObp7pQkqo7IU7mPMlzlm
    lens-aeson-1.2.3-EgiEJM4rUReCQidvO1LjEM mtl-2.2.2
    network-3.1.4.0-Clrm8B2IBAjIFHTKmEcInu
    network-uri-2.6.4.2-KyuZLjrVkMLH56LkxlYTeb
    optparse-applicative-0.18.1.0-iHmWlwYwvYAmLT692zZvc parsec-3.1.16.1
    protolude-0.3.5-K91l7LTt3Wt7JJOJV7G8ct
    regex-tdfa-1.3.2.4-AG3wQnDWHjR8IyIVdzEE1S
    retry-0.9.3.1-6jL2bgBJMHqGVyay5y3p5v
    scientific-0.3.8.0-4T67wgFVOmHCrVwu3HwSpM
    swagger2-2.8.10-GfzxqqNVoQBGk7wThlhGDg text-2.0.2 time-1.12.2
    unix-2.7.3 unordered-containers-0.2.20-3iRUctzIz2JCUYhLp7SKku
    vault-0.3.1.5-KS3ZUUxrQ3XCHiWodAEtwb
    vector-0.13.2.0-GniUvXn58d91eC1W7jmZ0
    wai-3.2.4-84onj9aucoXBC5yY5F84Os
    wai-cors-0.2.7-GFyBjjGyTZYDPu08iwgIS3
    wai-extra-3.1.17-3zjln46lUu21qsDbqc6ltN
    wai-logger-2.5.0-2Oe44eLnzEcHHO0qJ5FRhW
    warp-3.3.30-F9UfVPtBJ5O9bZES7zmkIL

haddock-interfaces:   /usr/share/doc/postgrest/html/postgrest.haddock
haddock-html:         /usr/share/doc/postgrest/html
' | '/usr/bin/ghc-pkg-9.4.8' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

