#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
printf '%s' 'name:                 postgrest
version:              10.0.0
visibility:           public
id:                   postgrest-10.0.0-6iIezmTtnZT6Z8o92bEWu5
key:                  postgrest-10.0.0-6iIezmTtnZT6Z8o92bEWu5
license:              MIT
maintainer:           Steve Chavez <stevechavezast@gmail.com>
author:               Joe Nelson, Adam Baker, Steve Chavez
homepage:             https://postgrest.org
synopsis:             REST API for any Postgres database
description:
    Reads the schema of a PostgreSQL database and creates RESTful routes
    for tables, views, and functions, supporting all HTTP methods that security
    permits.

category:             Executable, PostgreSQL, Network APIs
abi:                  23d26b09914ef670578f133d3d8efdbd
exposed:              True
exposed-modules:
    PostgREST.Admin PostgREST.App PostgREST.AppState PostgREST.Auth
    PostgREST.CLI PostgREST.Config PostgREST.Config.Database
    PostgREST.Config.JSPath PostgREST.Config.PgVersion
    PostgREST.Config.Proxy PostgREST.Cors PostgREST.DbStructure
    PostgREST.DbStructure.Identifiers PostgREST.DbStructure.Proc
    PostgREST.DbStructure.Relationship PostgREST.DbStructure.Table
    PostgREST.Error PostgREST.GucHeader PostgREST.Logger
    PostgREST.MediaType PostgREST.Middleware PostgREST.OpenAPI
    PostgREST.Query.QueryBuilder PostgREST.Query.SqlFragment
    PostgREST.Query.Statements PostgREST.RangeQuery
    PostgREST.Request.ApiRequest PostgREST.Request.DbRequestBuilder
    PostgREST.Request.MutateQuery PostgREST.Request.Preferences
    PostgREST.Request.QueryParams PostgREST.Request.ReadQuery
    PostgREST.Request.Types PostgREST.Unix PostgREST.Version
    PostgREST.Workers

hidden-modules:       Paths_postgrest
import-dirs:          /usr/lib/ghc-9.4.8/site-local/postgrest-10.0.0
library-dirs:         /usr/lib/ghc-9.4.8/site-local/postgrest-10.0.0
library-dirs-static:  /usr/lib/ghc-9.4.8/site-local/postgrest-10.0.0
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/postgrest
hs-libraries:         HSpostgrest-10.0.0-6iIezmTtnZT6Z8o92bEWu5
depends:
    HTTP-4000.4.1-Krzr0MEzuo1GQlLAcwFxmA
    Ranged-sets-0.5.0-EzVscX7HC3y9ZOgAr00TFQ
    aeson-2.1.2.1-7goQjQKasWuq7oOasot83
    auto-update-0.1.6-YEcfYizcyW231WNaKVz0c base-4.17.2.1
    base64-bytestring-1.2.1.0-ALlNDgCJ5uI9xkCg0LJBoH
    bytestring-0.11.5.3 case-insensitive-1.2.1.0-K9RqmTXohzcArWLcYT3z8C
    cassava-0.5.4.0-KrNcUwKkbvA9oliPW1AyZZ
    configurator-pg-0.2.10-5B073lJNcSZCU3pIEq9zJZ containers-0.6.7
    contravariant-extras-0.3.5.4-55ftugxfRMl5DZHT7luCXJ
    cookie-0.4.6-GZOZqzUDn152OuhEYvht8s directory-1.3.7.1
    either-5.0.3-Kx5w7TTJpC6LAET8edNsqP
    gitrev-1.3.1-HLNMuiuWFFhIgYmYImJML
    hasql-1.5.0.5-I3LpRXfzXVTC67F3ohwQHt
    hasql-dynamic-statements-0.3.1.1-BsRv5sW9g8nBcwaIASBY5B
    hasql-notifications-0.2.0.5-3U7f2tSqtbm9XoVjfS4f8R
    hasql-pool-0.5.2.2-KM94D2ivmKy789JOppjZRf
    hasql-transaction-1.0.1.1-29q0aaPtVqq4J90JBpgOUY
    heredoc-0.2.0.0-77nW0mrU6iW6fQsJ6nWzcx
    http-types-0.12.4-IhtLMXP6VlH4EvGJYn8uz7
    insert-ordered-containers-0.2.5.3-4tZ4fnKhDTt1bdQjSW5yzp
    interpolatedstring-perl6-1.0.2-6p5mLQxmVgSHA1i10zWj7G
    jose-0.10-6bSImq98lSxJhuJ6tn5TTo lens-5.3-19xvEa7xEEwAXxlwKeJj3v
    lens-aeson-1.2.3-6Bs1FtfrQpE2lG3lvFAXy9 mtl-2.2.2
    network-3.1.4.0-JHT56NFIotXJvLJoz7gUbr
    network-uri-2.6.4.2-5CjZ6bo06zN4C2hTxMZR32
    optparse-applicative-0.18.1.0-GDwWCLBUeEeIARGaJHYM6i
    parsec-3.1.16.1 protolude-0.3.5-GSwwswFkHiD8G3EduUMdGX
    regex-tdfa-1.3.2.4-7rACsYAdhMKLNw9nhRxHTR
    retry-0.9.3.1-EMhE6963FvK70UhLDoI6WA
    scientific-0.3.8.0-HfCn6ildxXk6zQelWj77aL
    swagger2-2.8.10-3MnsGQEgPou7wpuuRHUjR1 text-2.0.2 time-1.12.2
    unix-2.7.3 unordered-containers-0.2.20-5ChD9TF8iAH5uLARI0QLMz
    vault-0.3.1.5-6i3qUkQwpJiDyqfLuSyLRg
    vector-0.13.2.0-GjxrA8HCtQq4MGRlxeWifh
    wai-3.2.4-EOBJdwgqwP2ZRndhZ2MHb
    wai-cors-0.2.7-AXEwMTW1q2kIz1ePWz7aZ0
    wai-extra-3.1.17-5OlmeccVguC52S60ISVTO1
    wai-logger-2.5.0-32PdKevysMYHdizuLnzlYm
    warp-3.3.30-7E53fKdVIp56CZqGjn81a9

haddock-interfaces:   /usr/share/doc/postgrest/html/postgrest.haddock
haddock-html:         /usr/share/doc/postgrest/html
' | '/usr/bin/ghc-pkg-9.4.8' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

