#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
printf '%s' 'name:                 postgrest
version:              10.0.0
visibility:           public
id:                   postgrest-10.0.0-CUqTkvmeTR796P9kyglA7S
key:                  postgrest-10.0.0-CUqTkvmeTR796P9kyglA7S
license:              MIT
maintainer:           Steve Chavez <stevechavezast@gmail.com>
author:               Joe Nelson, Adam Baker, Steve Chavez
homepage:             https://postgrest.org
synopsis:             REST API for any Postgres database
description:
    Reads the schema of a PostgreSQL database and creates RESTful routes
    for tables, views, and functions, supporting all HTTP methods that security
    permits.

category:             Executable, PostgreSQL, Network APIs
abi:                  a5f5e52dce3c52cb7005a7291a8a3a4b
exposed:              True
exposed-modules:
    PostgREST.Admin PostgREST.App PostgREST.AppState PostgREST.Auth
    PostgREST.CLI PostgREST.Config PostgREST.Config.Database
    PostgREST.Config.JSPath PostgREST.Config.PgVersion
    PostgREST.Config.Proxy PostgREST.Cors PostgREST.DbStructure
    PostgREST.DbStructure.Identifiers PostgREST.DbStructure.Proc
    PostgREST.DbStructure.Relationship PostgREST.DbStructure.Table
    PostgREST.Error PostgREST.GucHeader PostgREST.Logger
    PostgREST.MediaType PostgREST.Middleware PostgREST.OpenAPI
    PostgREST.Query.QueryBuilder PostgREST.Query.SqlFragment
    PostgREST.Query.Statements PostgREST.RangeQuery
    PostgREST.Request.ApiRequest PostgREST.Request.DbRequestBuilder
    PostgREST.Request.MutateQuery PostgREST.Request.Preferences
    PostgREST.Request.QueryParams PostgREST.Request.ReadQuery
    PostgREST.Request.Types PostgREST.Unix PostgREST.Version
    PostgREST.Workers

hidden-modules:       Paths_postgrest
import-dirs:          /usr/lib/ghc-9.4.8/site-local/postgrest-10.0.0
library-dirs:         /usr/lib/ghc-9.4.8/site-local/postgrest-10.0.0
library-dirs-static:  /usr/lib/ghc-9.4.8/site-local/postgrest-10.0.0
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/postgrest
hs-libraries:         HSpostgrest-10.0.0-CUqTkvmeTR796P9kyglA7S
depends:
    HTTP-4000.4.1-5be1by8DtO3KI6fTuZctiv
    Ranged-sets-0.5.0-KPrmxuwvMgr97XwtetQxCT
    aeson-2.1.2.1-HUj8Ou2Jrr19darX8iyQt4
    auto-update-0.1.6-L2JE1p7fJFzJdkG3Jzy7RG base-4.17.2.1
    base64-bytestring-1.2.1.0-IbCUnYF5PxIJ57HxqijudZ
    bytestring-0.11.5.3 case-insensitive-1.2.1.0-JGcld4v8YDLG9iCNMxqnvW
    cassava-0.5.4.0-HqDfXsafCeGKGK7kXnSyvx
    configurator-pg-0.2.10-EFiXS7fnsPZCffD29hrKkl containers-0.6.7
    contravariant-extras-0.3.5.4-55ftugxfRMl5DZHT7luCXJ
    cookie-0.4.6-GZOZqzUDn152OuhEYvht8s directory-1.3.7.1
    either-5.0.3-3ucGpqzZEQ8FfeZNWDJLth
    gitrev-1.3.1-HLNMuiuWFFhIgYmYImJML
    hasql-1.5.0.5-7WOUcIdLsg28Ynmg26doSq
    hasql-dynamic-statements-0.3.1.1-FmMs3erDSVhDqB6Ytv3yvp
    hasql-notifications-0.2.0.5-GKepLTVcwhHFDRXdQZqL65
    hasql-pool-0.5.2.2-6rumeJUu0jeEC6tvmkAW8m
    hasql-transaction-1.0.1.1-LEVjPVizax4GdN793azQv8
    heredoc-0.2.0.0-77nW0mrU6iW6fQsJ6nWzcx
    http-types-0.12.4-22ca4VB3NcX8GYX2Ium30U
    insert-ordered-containers-0.2.5.3-30Qr7HM38iwFzA9Rrz7O66
    interpolatedstring-perl6-1.0.2-FerB3ZzX175IyF7q9CrN57
    jose-0.10-yFltzsWUVe5O8Ys54vOFB lens-5.3-6U8rnlrA3UzGhSFoVj5hOc
    lens-aeson-1.2.3-2MHR3QpU45z9mFygdRXMUn mtl-2.2.2
    network-3.1.4.0-9WwAYDZyp2nAB4XV6sI63l
    network-uri-2.6.4.2-6QHuxl9r30A5vsu5UpWUoB
    optparse-applicative-0.18.1.0-HLRS0wxhkSb4kVPN7e82uH
    parsec-3.1.16.1 protolude-0.3.5-BNu6GueRR03BIPt6e54AFw
    regex-tdfa-1.3.2.4-1rXqUz52vb5BdcUf9c7mO2
    retry-0.9.3.1-2iWKyjNiZsR5Sn4ErPylAy
    scientific-0.3.8.0-3JrZTDh3ZlGFN4TNaQrQZi
    swagger2-2.8.10-Jj4mUxxKOVm6zuraoqFez7 text-2.0.2 time-1.12.2
    unix-2.7.3 unordered-containers-0.2.20-obNV32ZSreHxgWRz6JrKP
    vault-0.3.1.5-6YWe0Eer5Lm5jZV58dLEpm
    vector-0.13.2.0-GDtmlcfK9QZ7E5AlTQVnIi
    wai-3.2.4-EhNMiHqwqcPHb2wBYuWApz
    wai-cors-0.2.7-5BNiGbnX2rv9Yzon3ik0lS
    wai-extra-3.1.17-DGSVGgYA26w7qNfLSf1QqD
    wai-logger-2.5.0-6UBVV50Shd1I1L4lPRoCAY
    warp-3.3.30-FqSE8b6njvuCT7iG6NkYg5

haddock-interfaces:   /usr/share/doc/postgrest/html/postgrest.haddock
haddock-html:         /usr/share/doc/postgrest/html
' | '/usr/bin/ghc-pkg-9.4.8' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

