#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
printf '%s' 'name:                 postgrest
version:              10.0.0
visibility:           public
id:                   postgrest-10.0.0-GpFZil1FvIXHDH3B3rDO8R
key:                  postgrest-10.0.0-GpFZil1FvIXHDH3B3rDO8R
license:              MIT
maintainer:           Steve Chavez <stevechavezast@gmail.com>
author:               Joe Nelson, Adam Baker, Steve Chavez
homepage:             https://postgrest.org
synopsis:             REST API for any Postgres database
description:
    Reads the schema of a PostgreSQL database and creates RESTful routes
    for tables, views, and functions, supporting all HTTP methods that security
    permits.

category:             Executable, PostgreSQL, Network APIs
abi:                  ee6d5b8cc2bd597a849e4dc90edbda2a
exposed:              True
exposed-modules:
    PostgREST.Admin PostgREST.App PostgREST.AppState PostgREST.Auth
    PostgREST.CLI PostgREST.Config PostgREST.Config.Database
    PostgREST.Config.JSPath PostgREST.Config.PgVersion
    PostgREST.Config.Proxy PostgREST.Cors PostgREST.DbStructure
    PostgREST.DbStructure.Identifiers PostgREST.DbStructure.Proc
    PostgREST.DbStructure.Relationship PostgREST.DbStructure.Table
    PostgREST.Error PostgREST.GucHeader PostgREST.Logger
    PostgREST.MediaType PostgREST.Middleware PostgREST.OpenAPI
    PostgREST.Query.QueryBuilder PostgREST.Query.SqlFragment
    PostgREST.Query.Statements PostgREST.RangeQuery
    PostgREST.Request.ApiRequest PostgREST.Request.DbRequestBuilder
    PostgREST.Request.MutateQuery PostgREST.Request.Preferences
    PostgREST.Request.QueryParams PostgREST.Request.ReadQuery
    PostgREST.Request.Types PostgREST.Unix PostgREST.Version
    PostgREST.Workers

hidden-modules:       Paths_postgrest
import-dirs:          /usr/lib/ghc-9.4.8/site-local/postgrest-10.0.0
library-dirs:         /usr/lib/ghc-9.4.8/site-local/postgrest-10.0.0
library-dirs-static:  /usr/lib/ghc-9.4.8/site-local/postgrest-10.0.0
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/postgrest
hs-libraries:         HSpostgrest-10.0.0-GpFZil1FvIXHDH3B3rDO8R
depends:
    HTTP-4000.4.1-JLRdpnayeie6Me4rfKmoFF
    Ranged-sets-0.5.0-8VTJethUpOX5R1Hva5QtfT
    aeson-2.1.2.1-HPwo2VO3hzcFr4fiGB5Oro
    auto-update-0.1.6-Fz4tobbH37fKgk5TCMtvlh base-4.17.2.1
    base64-bytestring-1.2.1.0-LY9UF0mrytX7ReHq71Oo2M
    bytestring-0.11.5.3 case-insensitive-1.2.1.0-1ILAtZHAjAqgINNQwApUo
    cassava-0.5.4.0-8kExPcHSsHRJKga8EL2tPy
    configurator-pg-0.2.10-3sgeCFwhoYQFIYkkc810e1 containers-0.6.7
    contravariant-extras-0.3.5.4-55ftugxfRMl5DZHT7luCXJ
    cookie-0.4.6-GZOZqzUDn152OuhEYvht8s directory-1.3.7.1
    either-5.0.3-7OqC9vdPUmx2v926gtr3Uy
    gitrev-1.3.1-HLNMuiuWFFhIgYmYImJML
    hasql-1.5.0.5-2MA0O7B5YEkJtUYwQAtsrP
    hasql-dynamic-statements-0.3.1.1-1smMLlvwfJiLLUgFuX8Hrp
    hasql-notifications-0.2.0.5-CiE8vxqbRBh555Dz76xgCH
    hasql-pool-0.5.2.2-85pIxnc5GzKLduUcnNGRKK
    hasql-transaction-1.0.1.1-DrqVjl94JDvFpramavzV27
    heredoc-0.2.0.0-77nW0mrU6iW6fQsJ6nWzcx
    http-types-0.12.4-B5DxmOwiWvxHN2hLvYjsdc
    insert-ordered-containers-0.2.5.3-9wNJT1f4tFD8drkEyVz2Z4
    interpolatedstring-perl6-1.0.2-LfBF6ZXutUQ3BGg07yZBvj
    jose-0.10-2Qe6hkgs0U63kgjzcZiFnX lens-5.3-pl18ecYYzn8sW5PtrryAE
    lens-aeson-1.2.3-1Z9uDZQvZMT7zesDZaKBAa mtl-2.2.2
    network-3.1.4.0-KV3OkCyx0pcI1DdyD3ZbeB
    network-uri-2.6.4.2-2s4BpOjYszS9lLOXbJJXzp
    optparse-applicative-0.18.1.0-DiZJ1DIwWjI1ByXXnUKInq
    parsec-3.1.16.1 protolude-0.3.5-JpiDeRqcVl5LaiNez5nOEa
    regex-tdfa-1.3.2.4-B5cBQIeZ71aKqDYYL1WMI
    retry-0.9.3.1-D8g2HtUkxwP4JhaX0wxMsS
    scientific-0.3.7.0-58CM7xG7oFa5aLaqCWIm5T
    swagger2-2.8.10-tQngbH34mEkQc5optSjQ text-2.0.2 time-1.12.2
    unix-2.7.3 unordered-containers-0.2.20-FFF0GulGLFtAHq6N1Lkm0s
    vault-0.3.1.5-2DYPbLdvpg42QmkcOZqzQH
    vector-0.13.2.0-ZKpjTfyjPa7BNElf7Ue7Z
    wai-3.2.4-9jkCTz3VUjM6XVKXhFmJSz
    wai-cors-0.2.7-YKVE0yPHyG93MIobr9pRC
    wai-extra-3.1.17-JenvNP4A5oEBbk83XAPJeH
    wai-logger-2.5.0-BUg4iv1iZlxSdb5Jo3wyH
    warp-3.3.30-KG7ckjPPkJoBng0y4YFeAf

haddock-interfaces:   /usr/share/doc/postgrest/html/postgrest.haddock
haddock-html:         /usr/share/doc/postgrest/html
' | '/usr/bin/ghc-pkg-9.4.8' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

