#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
printf '%s' 'name:                 postgrest
version:              10.0.0
visibility:           public
id:                   postgrest-10.0.0-cfnf9rMlgX7eHNAL4NS1k
key:                  postgrest-10.0.0-cfnf9rMlgX7eHNAL4NS1k
license:              MIT
maintainer:           Steve Chavez <stevechavezast@gmail.com>
author:               Joe Nelson, Adam Baker, Steve Chavez
homepage:             https://postgrest.org
synopsis:             REST API for any Postgres database
description:
    Reads the schema of a PostgreSQL database and creates RESTful routes
    for tables, views, and functions, supporting all HTTP methods that security
    permits.

category:             Executable, PostgreSQL, Network APIs
abi:                  b777e1da75f4bb2bd161b06741eb2115
exposed:              True
exposed-modules:
    PostgREST.Admin PostgREST.App PostgREST.AppState PostgREST.Auth
    PostgREST.CLI PostgREST.Config PostgREST.Config.Database
    PostgREST.Config.JSPath PostgREST.Config.PgVersion
    PostgREST.Config.Proxy PostgREST.Cors PostgREST.DbStructure
    PostgREST.DbStructure.Identifiers PostgREST.DbStructure.Proc
    PostgREST.DbStructure.Relationship PostgREST.DbStructure.Table
    PostgREST.Error PostgREST.GucHeader PostgREST.Logger
    PostgREST.MediaType PostgREST.Middleware PostgREST.OpenAPI
    PostgREST.Query.QueryBuilder PostgREST.Query.SqlFragment
    PostgREST.Query.Statements PostgREST.RangeQuery
    PostgREST.Request.ApiRequest PostgREST.Request.DbRequestBuilder
    PostgREST.Request.MutateQuery PostgREST.Request.Preferences
    PostgREST.Request.QueryParams PostgREST.Request.ReadQuery
    PostgREST.Request.Types PostgREST.Unix PostgREST.Version
    PostgREST.Workers

hidden-modules:       Paths_postgrest
import-dirs:          /usr/lib/ghc-9.4.8/site-local/postgrest-10.0.0
library-dirs:         /usr/lib/ghc-9.4.8/site-local/postgrest-10.0.0
library-dirs-static:  /usr/lib/ghc-9.4.8/site-local/postgrest-10.0.0
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/postgrest
hs-libraries:         HSpostgrest-10.0.0-cfnf9rMlgX7eHNAL4NS1k
depends:
    HTTP-4000.4.1-CTkZza62Q7vJXNs7Dnd4Yq
    Ranged-sets-0.5.0-LxDyVj7OnV9EdC6UsipTVu
    aeson-2.1.2.1-F9MXb1A8ug6GkYytoGh4jA
    auto-update-0.1.6-3k3rYda0iVTEqn1tY8uBO3 base-4.17.2.1
    base64-bytestring-1.2.1.0-7Hc8HHLesUeC50K0z9QlBv
    bytestring-0.11.5.3 case-insensitive-1.2.1.0-Az6gtf7HlYzJEXK7A4kQ5x
    cassava-0.5.4.0-7keEEP0uzEu2VmcgWbEjji
    configurator-pg-0.2.10-H437A7RgrdoEleFhk2D2Q5 containers-0.6.7
    contravariant-extras-0.3.5.4-55ftugxfRMl5DZHT7luCXJ
    cookie-0.4.6-GZOZqzUDn152OuhEYvht8s directory-1.3.7.1
    either-5.0.3-IyYh2PSUiRVI34OnkcVMxx
    gitrev-1.3.1-HLNMuiuWFFhIgYmYImJML
    hasql-1.5.0.5-6FvFZb1ciigKHtxjJ0C6rl
    hasql-dynamic-statements-0.3.1.1-3jlIDJyL0DS6djUTUDeg9F
    hasql-notifications-0.2.0.5-4NzG6UtdRPT4geRdq98XxM
    hasql-pool-0.5.2.2-K2lScM4Sciq7d8KfEV8DHw
    hasql-transaction-1.0.1.1-HJkbrVTrUDwKrfzUFCqkvd
    heredoc-0.2.0.0-77nW0mrU6iW6fQsJ6nWzcx
    http-types-0.12.4-1P1R4JUxLuAK31ciTRSGza
    insert-ordered-containers-0.2.5.3-ETD7YpxpxOKDE9pIGEU5IZ
    interpolatedstring-perl6-1.0.2-IEZgmdRiJLlKfzYnVgbhc8
    jose-0.10-kzYJgE7Ypt5eZiPjbkXbk lens-5.3-HdczP0no6IA6OsB2lfUnLL
    lens-aeson-1.2.3-LUkr4SP5UP52IeCA7OTMeC mtl-2.2.2
    network-3.1.4.0-F6j0uAI5udHBrXI4nYArv7
    network-uri-2.6.4.2-L8nDuI5zE9yEZ3pwnnu7AU
    optparse-applicative-0.18.1.0-8BM84nMNO6C3REk9JaN2lH
    parsec-3.1.16.1 protolude-0.3.5-LiI8eXooDirDIOSu98DqAJ
    regex-tdfa-1.3.2.4-A7DMPbd3mJ1EMZDc0SwwC7
    retry-0.9.3.1-3C6kMOhM6A3AFtfI1Eayax
    scientific-0.3.7.0-IuEDgnpy5lN4JI5naZeXd4
    swagger2-2.8.10-2y3zaidUhTCDaOd9VtDjOs text-2.0.2 time-1.12.2
    unix-2.7.3 unordered-containers-0.2.20-Kb1zmdIZFsX5Z4trT8w0xB
    vault-0.3.1.5-I1FXeXj102u7aUL5pvCstN
    vector-0.13.2.0-3KdUWUHYfVjDmpelwHDbn6
    wai-3.2.4-FOhUvoIDgPxHlKjxCvle7g
    wai-cors-0.2.7-4ocNNYMFAuLD6ps7w5bom2
    wai-extra-3.1.17-9OsGOx96bZlCLj3VC0G17f
    wai-logger-2.5.0-1HISeglsnl240SE1Jjojdz
    warp-3.3.30-8zeKYm2vcqZBDx4aW8oZbx

haddock-interfaces:   /usr/share/doc/postgrest/html/postgrest.haddock
haddock-html:         /usr/share/doc/postgrest/html
' | '/usr/bin/ghc-pkg-9.4.8' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

