#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
printf '%s' 'name:                 postgrest
version:              10.0.0
visibility:           public
id:                   postgrest-10.0.0-1SJVPZ95HDhBPmu5UQ6sMP
key:                  postgrest-10.0.0-1SJVPZ95HDhBPmu5UQ6sMP
license:              MIT
maintainer:           Steve Chavez <stevechavezast@gmail.com>
author:               Joe Nelson, Adam Baker, Steve Chavez
homepage:             https://postgrest.org
synopsis:             REST API for any Postgres database
description:
    Reads the schema of a PostgreSQL database and creates RESTful routes
    for tables, views, and functions, supporting all HTTP methods that security
    permits.

category:             Executable, PostgreSQL, Network APIs
abi:                  3a636f8f4de6d5d9f5e70de5e60dc1e7
exposed:              True
exposed-modules:
    PostgREST.Admin PostgREST.App PostgREST.AppState PostgREST.Auth
    PostgREST.CLI PostgREST.Config PostgREST.Config.Database
    PostgREST.Config.JSPath PostgREST.Config.PgVersion
    PostgREST.Config.Proxy PostgREST.Cors PostgREST.DbStructure
    PostgREST.DbStructure.Identifiers PostgREST.DbStructure.Proc
    PostgREST.DbStructure.Relationship PostgREST.DbStructure.Table
    PostgREST.Error PostgREST.GucHeader PostgREST.Logger
    PostgREST.MediaType PostgREST.Middleware PostgREST.OpenAPI
    PostgREST.Query.QueryBuilder PostgREST.Query.SqlFragment
    PostgREST.Query.Statements PostgREST.RangeQuery
    PostgREST.Request.ApiRequest PostgREST.Request.DbRequestBuilder
    PostgREST.Request.MutateQuery PostgREST.Request.Preferences
    PostgREST.Request.QueryParams PostgREST.Request.ReadQuery
    PostgREST.Request.Types PostgREST.Unix PostgREST.Version
    PostgREST.Workers

hidden-modules:       Paths_postgrest
import-dirs:          /usr/lib/ghc-9.4.8/site-local/postgrest-10.0.0
library-dirs:         /usr/lib/ghc-9.4.8/site-local/postgrest-10.0.0
library-dirs-static:  /usr/lib/ghc-9.4.8/site-local/postgrest-10.0.0
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/postgrest
hs-libraries:         HSpostgrest-10.0.0-1SJVPZ95HDhBPmu5UQ6sMP
depends:
    HTTP-4000.4.1-7LaE4oSg4yd9IttBkxB4yg
    Ranged-sets-0.5.0-EkHv00B9SMGCD9MLSeV9Ux
    aeson-2.1.2.1-4cRYi3WcVwTKRqMhXUztfB
    auto-update-0.1.6-ImzSmIgtqtK5NclgP8vMHq base-4.17.2.1
    base64-bytestring-1.2.1.0-3dKpuH5HS82KwnSpVDBu71
    bytestring-0.11.5.3 case-insensitive-1.2.1.0-EmvCHr7Pi0DF9aG5Som7hU
    cassava-0.5.4.0-FRBnSSGWZ1nK8u7fyAk3Ai
    configurator-pg-0.2.10-K5JnbcwbUS6IqZWNOsqNiP containers-0.6.7
    contravariant-extras-0.3.5.4-55ftugxfRMl5DZHT7luCXJ
    cookie-0.4.6-4KcZJbma3z5GIFijXOzknm directory-1.3.7.1
    either-5.0.3-JiyT1BCFVADGwhi0Kk5aEw
    gitrev-1.3.1-HLNMuiuWFFhIgYmYImJML
    hasql-1.5.0.5-8UwGGXqQgBwaKhU7CbHro
    hasql-dynamic-statements-0.3.1.1-IiMaOz4TtQtFSqjeFOnjbt
    hasql-notifications-0.2.0.5-957h95lBQkmG3gXTvoVzfF
    hasql-pool-0.5.2.2-AbRjKoKs02f5ZQY0UwBhLq
    hasql-transaction-1.0.1.1-7mMAxOFXXzBBbNoM9vMQRf
    heredoc-0.2.0.0-77nW0mrU6iW6fQsJ6nWzcx
    http-types-0.12.4-Hz1QXcCML2nIj1GeZ6O8D8
    insert-ordered-containers-0.2.5.3-9a4LHdhgJu5ukIA240Uiv
    interpolatedstring-perl6-1.0.2-FzsBWbf8FCtGHrttHLWpKH
    jose-0.10-3muCrjVlFcbIrjbxIM91AR lens-5.3-2T63PvFtwZXqnWv0im5sF
    lens-aeson-1.2.3-IZW0oVNHReiAYU62oDIF7d mtl-2.2.2
    network-3.1.4.0-2CDhKFQZ96O3njunkpEqT2
    network-uri-2.6.4.2-HPE7I962wSKDZCCiANqdpI
    optparse-applicative-0.18.1.0-FquNYXEN3Tk7yAxpGHhMRz
    parsec-3.1.16.1 protolude-0.3.5-BhCPvyZu5zwKb8iAhX9taA
    regex-tdfa-1.3.2.4-D7EB2Wsznhz2vCgXaQdDLa
    retry-0.9.3.1-5Oy5wAoOUYgD4gPToIyxfD
    scientific-0.3.7.0-K2KPplW6Nka7Ws1cS3R2Yx
    swagger2-2.8.10-AaBsrVdgaZP4KaoUuE5o75 text-2.0.2 time-1.12.2
    unix-2.7.3 unordered-containers-0.2.20-A2tjqfQXDXnFd3Ae9FP0C3
    vault-0.3.1.5-9RRuhN1k9usHHNlYjYVyhC
    vector-0.13.2.0-5H8NMvQc0Ab8bNH9ZMgAUW
    wai-3.2.4-Gif3XxAfqpyBhMnONwiLxO
    wai-cors-0.2.7-1dVUgK4Pnuga5TM0Uhn1U
    wai-extra-3.1.17-ICNUGZgrp9yCPmArX91jDJ
    wai-logger-2.5.0-JOQf2oBmNFu1XXtjJo6uEg
    warp-3.3.30-3UqF2mGeTD0SwqE0bScco

haddock-interfaces:   /usr/share/doc/postgrest/html/postgrest.haddock
haddock-html:         /usr/share/doc/postgrest/html
' | '/usr/bin/ghc-pkg-9.4.8' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

