#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
printf '%s' 'name:                 postgrest
version:              10.0.0
visibility:           public
id:                   postgrest-10.0.0-ExonvJqL2QB55Os8cOp0EY
key:                  postgrest-10.0.0-ExonvJqL2QB55Os8cOp0EY
license:              MIT
maintainer:           Steve Chavez <stevechavezast@gmail.com>
author:               Joe Nelson, Adam Baker, Steve Chavez
homepage:             https://postgrest.org
synopsis:             REST API for any Postgres database
description:
    Reads the schema of a PostgreSQL database and creates RESTful routes
    for tables, views, and functions, supporting all HTTP methods that security
    permits.

category:             Executable, PostgreSQL, Network APIs
abi:                  5f90b2633f519de1f06d004c0c879bae
exposed:              True
exposed-modules:
    PostgREST.Admin PostgREST.App PostgREST.AppState PostgREST.Auth
    PostgREST.CLI PostgREST.Config PostgREST.Config.Database
    PostgREST.Config.JSPath PostgREST.Config.PgVersion
    PostgREST.Config.Proxy PostgREST.Cors PostgREST.DbStructure
    PostgREST.DbStructure.Identifiers PostgREST.DbStructure.Proc
    PostgREST.DbStructure.Relationship PostgREST.DbStructure.Table
    PostgREST.Error PostgREST.GucHeader PostgREST.Logger
    PostgREST.MediaType PostgREST.Middleware PostgREST.OpenAPI
    PostgREST.Query.QueryBuilder PostgREST.Query.SqlFragment
    PostgREST.Query.Statements PostgREST.RangeQuery
    PostgREST.Request.ApiRequest PostgREST.Request.DbRequestBuilder
    PostgREST.Request.MutateQuery PostgREST.Request.Preferences
    PostgREST.Request.QueryParams PostgREST.Request.ReadQuery
    PostgREST.Request.Types PostgREST.Unix PostgREST.Version
    PostgREST.Workers

hidden-modules:       Paths_postgrest
import-dirs:          /usr/lib/ghc-9.4.8/site-local/postgrest-10.0.0
library-dirs:         /usr/lib/ghc-9.4.8/site-local/postgrest-10.0.0
library-dirs-static:  /usr/lib/ghc-9.4.8/site-local/postgrest-10.0.0
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/postgrest
hs-libraries:         HSpostgrest-10.0.0-ExonvJqL2QB55Os8cOp0EY
depends:
    HTTP-4000.4.1-5pjMaVn4cFSCgcg4Kl7nU2
    Ranged-sets-0.5.0-9pBlvv0am8tE0TZmqmIFk6
    aeson-2.1.2.1-5gViDrHjeNhDfT19MwgeMT
    auto-update-0.1.6-IMu6uT04UpeKvrQwPzkMbr base-4.17.2.1
    base64-bytestring-1.2.1.0-92IFzWt15c2BW0SweP4Os1
    bytestring-0.11.5.3 case-insensitive-1.2.1.0-D4Bx6jK2099tFJcppXDxv
    cassava-0.5.4.0-JmNPudAGQyv6xlcO8HvPia
    configurator-pg-0.2.10-5bvhyL2VSEnIrDyTKC5UKl containers-0.6.7
    contravariant-extras-0.3.5.4-55ftugxfRMl5DZHT7luCXJ
    cookie-0.4.6-4KcZJbma3z5GIFijXOzknm directory-1.3.7.1
    either-5.0.3-Dg8aFzMAKa97kgiVSsgEK2
    gitrev-1.3.1-HLNMuiuWFFhIgYmYImJML
    hasql-1.5.0.5-D3CWMPWYfKgFp5m4ap3Squ
    hasql-dynamic-statements-0.3.1.1-L8b2lbqtF8T3EjmYmlNcE8
    hasql-notifications-0.2.0.5-4EsI7lMF2QeBxUbTNqUk4G
    hasql-pool-0.5.2.2-G6PjSVz2R3EKQIRSyRWBfV
    hasql-transaction-1.0.1.1-HQx1DHjmfkiD0yPk2yF4dY
    heredoc-0.2.0.0-77nW0mrU6iW6fQsJ6nWzcx
    http-types-0.12.4-845zQBf8K2R8QZqh3scBqV
    insert-ordered-containers-0.2.5.3-8iXVudDoeffKfkL88hplVu
    interpolatedstring-perl6-1.0.2-KRST3IBiUZQ2Eoc27JhCdP
    jose-0.10-BPFRjrL0T48KMWCKaS7Lf5 lens-5.3-J85SWdrxBiwGIuYlY8I9aG
    lens-aeson-1.2.3-IN12Mt6bFmxJMw6JHGLZQD mtl-2.2.2
    network-3.1.4.0-EpGtkoqQTWdJPJAj8Thqiz
    network-uri-2.6.4.2-9MIvjX5zY25ED43FJsYIB3
    optparse-applicative-0.18.1.0-7KCyXOPBHhG88hE75wN8Ie
    parsec-3.1.16.1 protolude-0.3.5-3M1WnTNHf64F0Kqi6a8oax
    regex-tdfa-1.3.2.4-4bEsOyd8ZjUKkdBbrZow28
    retry-0.9.3.1-5qjq1E4dKYe3beyChieZHN
    scientific-0.3.7.0-HvL2E1otFtODq1T2dktHha
    swagger2-2.8.10-2HuPU9R7PBo6tkJIw1EAcB text-2.0.2 time-1.12.2
    unix-2.7.3 unordered-containers-0.2.20-BooESfmG3DbHMU6mBvbzIL
    vault-0.3.1.5-LDPoXEF5EXj6cZT6TUOepK
    vector-0.13.2.0-InZif5xbqP17OkTvptfKiM
    wai-3.2.4-41iNGcJSwNvEUgUKaMQRRA
    wai-cors-0.2.7-7gbHF418Wh2Ld3alANyM6K
    wai-extra-3.1.17-8nCNR940FkpGdBLxLOLRvO
    wai-logger-2.5.0-76EjVeqnyiDIz9HJaMAGG4
    warp-3.3.30-KUCEwGn4TuyLVm9l2BLxF8

haddock-interfaces:   /usr/share/doc/postgrest/html/postgrest.haddock
haddock-html:         /usr/share/doc/postgrest/html
' | '/usr/bin/ghc-pkg-9.4.8' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

