/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.chronology;

import java.util.Arrays;
import java.util.Collection;
import net.sourceforge.plantuml.chronology.ChronologyDiagram;
import net.sourceforge.plantuml.chronology.SentenceHappensChronology;
import net.sourceforge.plantuml.project.Failable;
import net.sourceforge.plantuml.project.core.Task;
import net.sourceforge.plantuml.project.core.TaskCode;
import net.sourceforge.plantuml.project.lang.SentenceSimple;
import net.sourceforge.plantuml.project.lang.Subject;
import net.sourceforge.plantuml.project.lang.Words;
import net.sourceforge.plantuml.regex.IRegex;
import net.sourceforge.plantuml.regex.RegexConcat;
import net.sourceforge.plantuml.regex.RegexLeaf;
import net.sourceforge.plantuml.regex.RegexOptional;
import net.sourceforge.plantuml.regex.RegexOr;
import net.sourceforge.plantuml.regex.RegexResult;
import net.sourceforge.plantuml.stereo.Stereotype;
import net.sourceforge.plantuml.stereo.StereotypePattern;

public class SubjectTask
implements Subject<ChronologyDiagram> {
    public static final Subject<ChronologyDiagram> ME = new SubjectTask();

    private SubjectTask() {
    }

    @Override
    public Failable<Task> getMe(ChronologyDiagram chronology, RegexResult arg) {
        String subject = arg.get("SUBJECT", 0);
        String shortName = arg.get("SHORTNAME", 0);
        String stereotype = arg.get("STEREOTYPE", 0);
        TaskCode code = TaskCode.fromIdAndDisplay(shortName, subject);
        Task result = chronology.getOrCreateTask(code, false);
        if (stereotype != null) {
            result.setStereotype(Stereotype.build(arg.get("STEREOTYPE", 0)));
        }
        return Failable.ok(result);
    }

    @Override
    public Collection<? extends SentenceSimple<ChronologyDiagram>> getSentences() {
        return Arrays.asList(new SentenceHappensChronology());
    }

    @Override
    public IRegex toRegex() {
        return new RegexOr(new RegexLeaf(1, "SUBJECT", "\\[([^\\[\\]]+?)\\]"), StereotypePattern.optional("STEREOTYPE"), new RegexOptional((IRegex)new RegexConcat(Words.exactly("as"), RegexLeaf.spaceOneOrMore(), new RegexLeaf(1, "SHORTNAME", "\\[([^\\[\\]]+?)\\]"))));
    }
}

