/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.klimt.font;

import java.awt.Font;
import java.awt.GraphicsEnvironment;
import java.util.HashSet;
import java.util.Set;
import net.sourceforge.plantuml.StringUtils;
import net.sourceforge.plantuml.klimt.font.UFontContext;

public class UFont {
    private final Font font;
    private final String family;
    private final int style;
    private final int size;
    private final int hash;
    private static final Set<String> names = new HashSet<String>();

    public String toStringDebug() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getPortableFontName());
        sb.append("/");
        sb.append(this.font.getSize());
        return sb.toString();
    }

    public static UFont build(String fontFamily, int fontStyle, int fontSize) {
        String family = UFont.getExistingFontFamily(fontFamily);
        Font font = new Font(family, fontStyle, fontSize);
        return new UFont(font, fontFamily, fontStyle, fontSize);
    }

    private UFont(Font font, String family, int style, int size) {
        this.font = font;
        this.family = family;
        this.style = style;
        this.size = size;
        this.hash = UFont.computeFontHash(family, style, size);
    }

    public static int computeFontHash(String family, int style, int size) {
        int hash = 17;
        hash = 31 * hash + family.hashCode();
        hash = 31 * hash + style;
        hash = 31 * hash + size;
        return hash;
    }

    public static String getExistingFontFamily(String fontFamily) {
        if (fontFamily.contains(",")) {
            for (String name : fontFamily.split(",")) {
                if (!UFont.doesFamilyExists(name = StringUtils.eventuallyRemoveStartingAndEndingDoubleQuote(name.trim()).trim())) continue;
                return name;
            }
            return "SansSerif";
        }
        return StringUtils.eventuallyRemoveStartingAndEndingDoubleQuote(fontFamily.trim()).trim();
    }

    private static boolean doesFamilyExists(String name) {
        return names.contains(name.toLowerCase());
    }

    public static UFont serif(int size) {
        return UFont.build("Serif", 0, size);
    }

    public static UFont sansSerif(int size) {
        return UFont.build("SansSerif", 0, size);
    }

    public static UFont courier(int size) {
        return UFont.build("Courier", 0, size);
    }

    public static UFont byDefault(int size) {
        return UFont.sansSerif(12);
    }

    public UFont goTikz(int delta) {
        return new UFont(new Font("Serif", this.getStyle(), this.getSize() + delta), "Serif", this.style, this.size + delta);
    }

    public static UFont monospaced(int size) {
        return UFont.build("Monospaced", 0, size);
    }

    public final Font getUnderlayingFont(UFontContext context) {
        return this.font;
    }

    public UFont withSize(float size) {
        return new UFont(this.font.deriveFont(size), this.family, this.style, (int)size);
    }

    public UFont withStyle(int style) {
        return new UFont(this.font.deriveFont(style), this.family, style, this.size);
    }

    public UFont bold() {
        return this.withStyle(1);
    }

    public UFont italic() {
        return this.withStyle(2);
    }

    public int getStyle() {
        return this.font.getStyle();
    }

    public int getSize() {
        return this.font.getSize();
    }

    public double getSize2D() {
        return this.font.getSize2D();
    }

    public boolean isBold() {
        return this.font.isBold();
    }

    public boolean isItalic() {
        return this.font.isItalic();
    }

    public String getFamily(UFontContext context) {
        if (context == UFontContext.EPS) {
            if (this.family == null) {
                return "Times-Roman";
            }
            return this.font.getPSName();
        }
        if (context == UFontContext.SVG) {
            String result = this.family.replace('\"', '\'');
            result = result.replaceAll("(?i)sansserif", "sans-serif");
            return result;
        }
        return this.family;
    }

    private String getPortableFontName() {
        String name = this.font.getFontName();
        if (this.font.isBold() && this.font.isItalic()) {
            return name.endsWith(".bolditalic") ? name : name + ".bolditalic";
        }
        if (this.font.isBold()) {
            return name.endsWith(".bold") ? name : name + ".bold";
        }
        if (this.font.isItalic()) {
            return name.endsWith(".italic") ? name : name + ".italic";
        }
        return name.endsWith(".plain") ? name : name + ".plain";
    }

    public String toString() {
        return this.font.toString();
    }

    public int hashCode() {
        return this.hash;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof UFont)) {
            return false;
        }
        return this.font.equals(((UFont)obj).font);
    }

    static {
        for (String name : GraphicsEnvironment.getLocalGraphicsEnvironment().getAvailableFontFamilyNames()) {
            names.add(name.toLowerCase());
        }
    }
}

