/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.security.ssl.config;

import com.google.common.collect.ImmutableList;
import java.lang.reflect.Method;
import java.security.cert.CertificateParsingException;
import java.security.cert.X509Certificate;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import java.util.TreeSet;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.bouncycastle.asn1.ASN1InputStream;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.ASN1Primitive;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.ASN1String;
import org.bouncycastle.asn1.ASN1TaggedObject;

public class Certificate {
    private static final Logger LOGGER = LogManager.getLogger(Certificate.class);
    private final X509Certificate certificate;
    private final String format;
    private final String alias;
    private final boolean hasKey;

    public Certificate(X509Certificate certificate, boolean hasKey) {
        this(certificate, "pem", null, hasKey);
    }

    public Certificate(X509Certificate certificate, String format, String alias, boolean hasKey) {
        this.certificate = certificate;
        this.format = format;
        this.alias = alias;
        this.hasKey = hasKey;
    }

    public X509Certificate x509Certificate() {
        return this.certificate;
    }

    public String format() {
        return this.format;
    }

    public String alias() {
        return this.alias;
    }

    public boolean hasPrivateKey() {
        return this.hasKey;
    }

    public String subjectAlternativeNames() {
        return this.loadSubjectAlternativeNames();
    }

    public byte[] signature() {
        return this.certificate.getSignature();
    }

    @Deprecated(since="since JDK 21", forRemoval=true)
    public String loadSubjectAlternativeNames() {
        String san = "";
        try {
            Collection<List<?>> altNames;
            Collection<List<?>> collection = altNames = this.certificate != null && this.certificate.getSubjectAlternativeNames() != null ? this.certificate.getSubjectAlternativeNames() : null;
            if (altNames != null) {
                Comparator<List> comparator = Comparator.comparing(altName -> (Integer)altName.get(0)).thenComparing(altName -> (String)altName.get(1));
                TreeSet<List> sans = new TreeSet<List>(comparator);
                for (List<?> altName2 : altNames) {
                    Integer type = (Integer)altName2.get(0);
                    if (type == 0) {
                        List<String> otherName = this.parseOtherName(altName2);
                        if (otherName == null) continue;
                        sans.add(Arrays.asList(type, otherName));
                        continue;
                    }
                    sans.add(altName2);
                }
                san = ((Object)sans).toString();
            }
        }
        catch (CertificateParsingException e) {
            LOGGER.error("Issue parsing SubjectAlternativeName:", (Throwable)e);
        }
        return san;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Deprecated(since="since JDK 21", forRemoval=true)
    private List<String> parseOtherName(List<?> altName) {
        if (altName.size() < 2) {
            LOGGER.warn("Couldn't parse subject alternative names");
            return null;
        }
        try (ASN1InputStream in = new ASN1InputStream((byte[])altName.get(1));){
            ASN1Primitive asn1Primitive = in.readObject();
            ASN1Sequence sequence = ASN1Sequence.getInstance((Object)asn1Primitive);
            ASN1ObjectIdentifier asn1ObjectIdentifier = ASN1ObjectIdentifier.getInstance((Object)sequence.getObjectAt(0));
            ASN1TaggedObject asn1TaggedObject = ASN1TaggedObject.getInstance((Object)sequence.getObjectAt(1));
            Method getObjectMethod = Certificate.getObjectMethod();
            ASN1Primitive maybeTaggedAsn1Primitive = (ASN1Primitive)getObjectMethod.invoke((Object)asn1TaggedObject, new Object[0]);
            if (maybeTaggedAsn1Primitive instanceof ASN1TaggedObject) {
                maybeTaggedAsn1Primitive = (ASN1Primitive)getObjectMethod.invoke((Object)maybeTaggedAsn1Primitive, new Object[0]);
            }
            if (maybeTaggedAsn1Primitive instanceof ASN1String) {
                ImmutableList immutableList = ImmutableList.of((Object)asn1ObjectIdentifier.getId(), (Object)maybeTaggedAsn1Primitive.toString());
                return immutableList;
            }
            LOGGER.warn("Couldn't parse subject alternative names");
            List<String> list = null;
            return list;
        }
        catch (Exception ioe) {
            throw new RuntimeException("Couldn't parse subject alternative names", ioe);
        }
    }

    static Method getObjectMethod() throws ClassNotFoundException, NoSuchMethodException {
        Class<?> asn1TaggedObjectClass = Class.forName("org.bouncycastle.asn1.ASN1TaggedObject");
        try {
            return asn1TaggedObjectClass.getMethod("getBaseObject", new Class[0]);
        }
        catch (NoSuchMethodException ex) {
            return asn1TaggedObjectClass.getMethod("getObject", new Class[0]);
        }
    }

    public String serialNumber() {
        return this.certificate.getSerialNumber().toString();
    }

    public String subject() {
        return this.certificate.getSubjectX500Principal() != null ? this.certificate.getSubjectX500Principal().getName() : null;
    }

    public String issuer() {
        return this.certificate.getIssuerX500Principal() != null ? this.certificate.getIssuerX500Principal().getName() : null;
    }

    public String notAfter() {
        return this.certificate.getNotAfter() != null ? this.certificate.getNotAfter().toInstant().toString() : null;
    }

    public String notBefore() {
        return this.certificate.getNotBefore() != null ? this.certificate.getNotBefore().toInstant().toString() : null;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Certificate that = (Certificate)o;
        return this.hasKey == that.hasKey && Objects.equals(this.certificate, that.certificate) && Objects.equals(this.format, that.format) && Objects.equals(this.alias, that.alias);
    }

    public int hashCode() {
        return Objects.hash(this.certificate, this.format, this.alias, this.hasKey);
    }

    public String toString() {
        return "Certificate{format='" + this.format + "', alias='" + this.alias + "', hasKey=" + this.hasKey + "}";
    }
}

