/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.security.resources;

import java.io.IOException;
import java.util.Objects;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.opensearch.core.action.ActionListener;
import org.opensearch.core.index.shard.ShardId;
import org.opensearch.index.engine.Engine;
import org.opensearch.index.shard.IndexingOperationListener;
import org.opensearch.security.auth.UserSubjectImpl;
import org.opensearch.security.resources.ResourceSharingIndexHandler;
import org.opensearch.security.spi.resources.sharing.CreatedBy;
import org.opensearch.security.spi.resources.sharing.ResourceSharing;
import org.opensearch.security.user.User;
import org.opensearch.threadpool.ThreadPool;
import org.opensearch.transport.client.Client;

public class ResourceIndexListener
implements IndexingOperationListener {
    private static final Logger log = LogManager.getLogger(ResourceIndexListener.class);
    private final ResourceSharingIndexHandler resourceSharingIndexHandler;
    private final ThreadPool threadPool;

    public ResourceIndexListener(ThreadPool threadPool, Client client) {
        this.threadPool = threadPool;
        this.resourceSharingIndexHandler = new ResourceSharingIndexHandler(client, threadPool);
    }

    public void postIndex(ShardId shardId, Engine.Index index, Engine.IndexResult result) {
        String resourceIndex = shardId.getIndexName();
        log.debug("postIndex called on {}", (Object)resourceIndex);
        String resourceId = index.id();
        if (!result.isCreated() && index.origin().equals((Object)Engine.Operation.Origin.PRIMARY)) {
            log.debug("Skipping resource sharing entry creation as this was an update operation for resource {}", (Object)resourceId);
            return;
        }
        UserSubjectImpl userSubject = (UserSubjectImpl)this.threadPool.getThreadContext().getPersistent("_opendistro_security_authenticated_user");
        User user = userSubject.getUser();
        try {
            Objects.requireNonNull(user);
            ResourceSharing sharing = this.resourceSharingIndexHandler.indexResourceSharing(resourceId, resourceIndex, new CreatedBy(user.getName()), null);
            log.debug("Successfully created a resource sharing entry {} for resource {} within index {}", (Object)sharing, (Object)resourceId, (Object)resourceIndex);
        }
        catch (IOException e) {
            log.debug("Failed to create a resource sharing entry for resource: {}", (Object)resourceId, (Object)e);
        }
    }

    public void postDelete(ShardId shardId, Engine.Delete delete, Engine.DeleteResult result) {
        String resourceIndex = shardId.getIndexName();
        log.debug("postDelete called on {}", (Object)resourceIndex);
        String resourceId = delete.id();
        this.resourceSharingIndexHandler.deleteResourceSharingRecord(resourceId, resourceIndex, (ActionListener<Boolean>)ActionListener.wrap(deleted -> {
            if (deleted.booleanValue()) {
                log.debug("Successfully deleted resource sharing entry for resource {}", (Object)resourceId);
            } else {
                log.debug("No resource sharing entry found for resource {}", (Object)resourceId);
            }
        }, exception -> log.error("Failed to delete resource sharing entry for resource {}", (Object)resourceId, exception)));
    }
}

