/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.security.resources;

import java.util.Set;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.opensearch.common.settings.Settings;
import org.opensearch.core.action.ActionListener;
import org.opensearch.security.resources.ResourceAccessHandler;
import org.opensearch.security.spi.resources.client.ResourceSharingClient;
import org.opensearch.security.spi.resources.sharing.ResourceSharing;
import org.opensearch.security.spi.resources.sharing.ShareWith;

public final class ResourceAccessControlClient
implements ResourceSharingClient {
    private static final Logger log = LogManager.getLogger(ResourceAccessControlClient.class);
    private final ResourceAccessHandler resourceAccessHandler;

    public ResourceAccessControlClient(ResourceAccessHandler resourceAccessHandler, Settings settings) {
        this.resourceAccessHandler = resourceAccessHandler;
    }

    public void verifyAccess(String resourceId, String resourceIndex, ActionListener<Boolean> listener) {
        this.resourceAccessHandler.hasPermission(resourceId, resourceIndex, "default", listener);
    }

    public void share(String resourceId, String resourceIndex, ShareWith target, ActionListener<ResourceSharing> listener) {
        this.resourceAccessHandler.share(resourceId, resourceIndex, target, listener);
    }

    public void revoke(String resourceId, String resourceIndex, ShareWith target, ActionListener<ResourceSharing> listener) {
        this.resourceAccessHandler.revoke(resourceId, resourceIndex, target, listener);
    }

    public void getAccessibleResourceIds(String resourceIndex, ActionListener<Set<String>> listener) {
        this.resourceAccessHandler.getAccessibleResourceIdsForCurrentUser(resourceIndex, listener);
    }
}

