/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.security.hasher;

import java.util.Set;
import org.opensearch.common.settings.Settings;
import org.opensearch.security.hasher.BCryptPasswordHasher;
import org.opensearch.security.hasher.PBKDF2PasswordHasher;
import org.opensearch.security.hasher.PasswordHasher;
import org.opensearch.security.support.ConfigConstants;

public class PasswordHasherFactory {
    private static final Set<String> ALLOWED_BCRYPT_MINORS = Set.of("A", "B", "Y");

    public static PasswordHasher createPasswordHasher(Settings settings) {
        String algorithm = settings.get("plugins.security.password.hashing.algorithm", "bcrypt");
        return switch (algorithm.toLowerCase()) {
            case "bcrypt" -> PasswordHasherFactory.getBCryptHasher(settings);
            case "pbkdf2" -> PasswordHasherFactory.getPBKDF2Hasher(settings);
            default -> throw new IllegalArgumentException(String.format("Password hashing algorithm '%s' not supported.", algorithm));
        };
    }

    private static PasswordHasher getBCryptHasher(Settings settings) {
        int rounds = settings.getAsInt("plugins.security.password.hashing.bcrypt.rounds", Integer.valueOf(12));
        String minor = settings.get("plugins.security.password.hashing.bcrypt.minor", "Y").toUpperCase();
        if (rounds < 4 || rounds > 31) {
            throw new IllegalArgumentException(String.format("BCrypt rounds must be between 4 and 31. Got: %d", rounds));
        }
        if (!ALLOWED_BCRYPT_MINORS.contains(minor)) {
            throw new IllegalArgumentException(String.format("BCrypt minor must be 'A', 'B', or 'Y'. Got: %s", minor));
        }
        return new BCryptPasswordHasher(minor, rounds);
    }

    private static PasswordHasher getPBKDF2Hasher(Settings settings) {
        String pbkdf2Function = settings.get("plugins.security.password.hashing.pbkdf2.function", ConfigConstants.SECURITY_PASSWORD_HASHING_PBKDF2_FUNCTION_DEFAULT).toUpperCase();
        int iterations = settings.getAsInt("plugins.security.password.hashing.pbkdf2.iterations", Integer.valueOf(600000));
        int length = settings.getAsInt("plugins.security.password.hashing.pbkdf2.length", Integer.valueOf(256));
        if (!pbkdf2Function.matches("SHA(1|224|256|384|512)")) {
            throw new IllegalArgumentException(String.format("PBKDF2 function must be one of SHA1, SHA224, SHA256, SHA384, or SHA512. Got: %s", pbkdf2Function));
        }
        if (iterations <= 0) {
            throw new IllegalArgumentException(String.format("PBKDF2 iterations must be a positive integer. Got: %d", iterations));
        }
        if (length <= 0) {
            throw new IllegalArgumentException(String.format("PBKDF2 length must be a positive integer. Got: %d", length));
        }
        return new PBKDF2PasswordHasher(pbkdf2Function, iterations, length);
    }
}

