/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.security.auth.internal;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.Collection;
import java.util.Map;
import java.util.Optional;
import org.greenrobot.eventbus.Subscribe;
import org.opensearch.OpenSearchSecurityException;
import org.opensearch.security.auth.AuthenticationBackend;
import org.opensearch.security.auth.AuthenticationContext;
import org.opensearch.security.auth.AuthorizationBackend;
import org.opensearch.security.auth.ImpersonationBackend;
import org.opensearch.security.hasher.PasswordHasher;
import org.opensearch.security.securityconf.InternalUsersModel;
import org.opensearch.security.user.AuthCredentials;
import org.opensearch.security.user.User;

public class InternalAuthenticationBackend
implements AuthenticationBackend,
ImpersonationBackend,
AuthorizationBackend {
    private final PasswordHasher passwordHasher;
    private InternalUsersModel internalUsersModel;

    public InternalAuthenticationBackend(PasswordHasher passwordHasher) {
        this.passwordHasher = passwordHasher;
    }

    @Override
    public Optional<User> impersonate(User user) {
        if (user == null || this.internalUsersModel == null) {
            return Optional.empty();
        }
        boolean exists = this.internalUsersModel.exists(user.getName());
        if (exists) {
            ImmutableMap<String, String> customAttributes = this.internalUsersModel.getAttributes(user.getName());
            ImmutableMap.Builder attributeMap = ImmutableMap.builder();
            for (Map.Entry attributeEntry : customAttributes.entrySet()) {
                attributeMap.put((Object)("attr.internal." + (String)attributeEntry.getKey()), (Object)((String)attributeEntry.getValue()));
            }
            return Optional.of(user.withRoles((Collection<String>)this.internalUsersModel.getBackendRoles(user.getName())).withSecurityRoles((Collection<String>)this.internalUsersModel.getSecurityRoles(user.getName())).withAttributes((Map<String, String>)attributeMap.build()));
        }
        return Optional.empty();
    }

    public boolean passwordMatchesHash(String hash, char[] array) {
        return this.passwordHasher.check(array, hash);
    }

    @Override
    public User authenticate(AuthenticationContext context) {
        String hash;
        byte[] password;
        boolean userExists;
        AuthCredentials credentials = context.getCredentials();
        if (this.internalUsersModel == null) {
            throw new OpenSearchSecurityException("Internal authentication backend not configured. May be OpenSearch is not initialized.", new Object[0]);
        }
        if (!this.internalUsersModel.exists(credentials.getUsername())) {
            userExists = false;
            password = credentials.getPassword();
            hash = "$2y$12$NmKhjNssNgSIj8iXT7SYxeXvMA1E95a9tCt4cySY9FrQ4fB18xEc2";
        } else {
            userExists = true;
            password = credentials.getPassword();
            hash = this.internalUsersModel.getHash(credentials.getUsername());
        }
        if (password == null || password.length == 0) {
            throw new OpenSearchSecurityException("empty passwords not supported", new Object[0]);
        }
        ByteBuffer wrap = ByteBuffer.wrap(password);
        CharBuffer buf = StandardCharsets.UTF_8.decode(wrap);
        char[] array = new char[buf.limit()];
        buf.get(array);
        Arrays.fill(password, (byte)0);
        try {
            if (this.passwordMatchesHash(hash, array) && userExists) {
                ImmutableSet<String> backendRoles = this.internalUsersModel.getBackendRoles(credentials.getUsername());
                ImmutableSet<String> securityRoles = this.internalUsersModel.getSecurityRoles(credentials.getUsername());
                ImmutableMap attributeMap = ImmutableMap.builder().putAll(credentials.getAttributes()).putAll(this.prefixedAttributeMap(this.internalUsersModel.getAttributes(credentials.getUsername()))).build();
                User user = new User(credentials.getUsername(), backendRoles, securityRoles, null, (ImmutableMap<String, String>)attributeMap, false);
                return user;
            }
            if (!userExists) {
                throw new OpenSearchSecurityException(credentials.getUsername() + " not found", new Object[0]);
            }
            throw new OpenSearchSecurityException("password does not match", new Object[0]);
        }
        finally {
            Arrays.fill(wrap.array(), (byte)0);
            Arrays.fill(buf.array(), '\u0000');
            Arrays.fill(array, '\u0000');
        }
    }

    @Override
    public String getType() {
        return "internal";
    }

    @Override
    public User addRoles(User user, AuthenticationContext context) throws OpenSearchSecurityException {
        if (this.internalUsersModel == null) {
            throw new OpenSearchSecurityException("Internal authentication backend not configured. May be OpenSearch Security is not initialized.", new Object[0]);
        }
        if (this.internalUsersModel.exists(user.getName())) {
            return user.withRoles((Collection<String>)this.internalUsersModel.getBackendRoles(user.getName())).withSecurityRoles((Collection<String>)this.internalUsersModel.getSecurityRoles(user.getName())).withAttributes((Map<String, String>)this.prefixedAttributeMap(this.internalUsersModel.getAttributes(user.getName())));
        }
        return user;
    }

    @Subscribe
    public void onInternalUsersModelChanged(InternalUsersModel ium) {
        this.internalUsersModel = ium;
    }

    ImmutableMap<String, String> prefixedAttributeMap(ImmutableMap<String, String> attributeMap) {
        ImmutableMap.Builder result = ImmutableMap.builder();
        for (Map.Entry attributeEntry : attributeMap.entrySet()) {
            result.put((Object)("attr.internal." + (String)attributeEntry.getKey()), (Object)((String)attributeEntry.getValue()));
        }
        return result.build();
    }
}

