/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.neuralsearch.util;

import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import lombok.Generated;
import lombok.NonNull;
import org.opensearch.cluster.metadata.IndexMetadata;
import org.opensearch.cluster.metadata.MappingMetadata;
import org.opensearch.neuralsearch.query.NeuralQueryBuilder;
import org.opensearch.neuralsearch.query.dto.NeuralQueryTargetFieldConfig;

public class SemanticMappingUtils {
    private static final int MAX_DEPTH_OF_INDEX_MAPPING = 1000;

    public static void collectSemanticField(@NonNull Map<String, Object> currentMapping, @NonNull Map<String, Map<String, Object>> semanticFieldPathToConfigMap) {
        Objects.requireNonNull(currentMapping, "currentMapping is marked non-null but is null");
        Objects.requireNonNull(semanticFieldPathToConfigMap, "semanticFieldPathToConfigMap is marked non-null but is null");
        ArrayDeque<CollectSemanticFieldStackEntry> semanticFieldEntryStack = new ArrayDeque<CollectSemanticFieldStackEntry>();
        semanticFieldEntryStack.push(new CollectSemanticFieldStackEntry(currentMapping, "", 0));
        while (!semanticFieldEntryStack.isEmpty()) {
            CollectSemanticFieldStackEntry entry = (CollectSemanticFieldStackEntry)semanticFieldEntryStack.pop();
            Map<String, Object> mapping = entry.mapping;
            String parentPath = entry.path;
            int currentDepth = entry.depth;
            if (currentDepth > 1000) {
                throw new IllegalArgumentException(String.format(Locale.ROOT, "Cannot transform the mapping for semantic fields because its depth exceeds the maximum allowed depth %d.", 1000));
            }
            for (Map.Entry<String, Object> fieldEntry : mapping.entrySet()) {
                String fullPath;
                String fieldName = fieldEntry.getKey();
                Object fieldConfig = fieldEntry.getValue();
                String string = fullPath = parentPath.isEmpty() ? fieldName : String.join((CharSequence)".", parentPath, fieldName);
                if (fieldConfig instanceof Map) {
                    Map fieldConfigMap = (Map)fieldConfig;
                    if (SemanticMappingUtils.isSemanticField(fieldConfigMap)) {
                        semanticFieldPathToConfigMap.put(fullPath, fieldConfigMap);
                    }
                    if (!fieldConfigMap.containsKey("properties")) continue;
                    Map subMapping = (Map)fieldConfigMap.get("properties");
                    semanticFieldEntryStack.push(new CollectSemanticFieldStackEntry(subMapping, fullPath, currentDepth + 1));
                    continue;
                }
                throw new IllegalArgumentException(String.format(Locale.ROOT, "Expect the field config at the path %s should be a map.", fullPath));
            }
        }
    }

    private static boolean isSemanticField(Map<String, Object> fieldConfigMap) {
        Object type = fieldConfigMap.get("type");
        return "semantic".equals(type);
    }

    public static Map<String, List<String>> extractModelIdToFieldPathMap(@NonNull Map<String, Map<String, Object>> semanticFieldPathToConfigMap) {
        Objects.requireNonNull(semanticFieldPathToConfigMap, "semanticFieldPathToConfigMap is marked non-null but is null");
        HashMap<String, List<String>> modelIdToFieldPathMap = new HashMap<String, List<String>>();
        for (Map.Entry<String, Map<String, Object>> entry : semanticFieldPathToConfigMap.entrySet()) {
            String fullPath = entry.getKey();
            Map<String, Object> fieldConfigMap = entry.getValue();
            String modelIdStr = SemanticMappingUtils.getModelId(fieldConfigMap, fullPath);
            if (!modelIdToFieldPathMap.containsKey(modelIdStr)) {
                modelIdToFieldPathMap.put(modelIdStr, new ArrayList());
            }
            ((List)modelIdToFieldPathMap.get(modelIdStr)).add(fullPath);
        }
        return modelIdToFieldPathMap;
    }

    public static String getModelId(@NonNull Map<String, Object> fieldConfigMap, @NonNull String fullPath) {
        Objects.requireNonNull(fieldConfigMap, "fieldConfigMap is marked non-null but is null");
        Objects.requireNonNull(fullPath, "fullPath is marked non-null but is null");
        String error = SemanticMappingUtils.validateModelId(fullPath, fieldConfigMap);
        if (error != null) {
            throw new IllegalArgumentException(error);
        }
        return (String)fieldConfigMap.get("model_id");
    }

    public static String getSemanticInfoFieldFullPath(@NonNull Map<String, Object> fieldConfigMap, @NonNull String baseFieldPath, @NonNull String semanticFieldFullPathInMapping) {
        String userDefinedSemanticInfoFieldName;
        Objects.requireNonNull(fieldConfigMap, "fieldConfigMap is marked non-null but is null");
        Objects.requireNonNull(baseFieldPath, "baseFieldPath is marked non-null but is null");
        Objects.requireNonNull(semanticFieldFullPathInMapping, "semanticFieldFullPathInMapping is marked non-null but is null");
        String error = SemanticMappingUtils.validateSemanticInfoFieldName(semanticFieldFullPathInMapping, fieldConfigMap);
        if (error != null) {
            throw new IllegalArgumentException(error);
        }
        Object semanticInfoFullPath = baseFieldPath + "_semantic_info";
        String string = userDefinedSemanticInfoFieldName = fieldConfigMap.containsKey("semantic_info_field_name") ? (String)fieldConfigMap.get("semantic_info_field_name") : null;
        if (userDefinedSemanticInfoFieldName != null) {
            CharSequence[] paths = ((String)semanticInfoFullPath).split("\\.");
            paths[paths.length - 1] = userDefinedSemanticInfoFieldName;
            semanticInfoFullPath = String.join((CharSequence)".", paths);
        }
        return semanticInfoFullPath;
    }

    public static Map<String, Object> getProperties(Map<String, Object> mapping) {
        if (mapping == null) {
            return new HashMap<String, Object>();
        }
        try {
            if (mapping.containsKey("_doc") && mapping.get("_doc") instanceof Map) {
                Map doc = (Map)mapping.get("_doc");
                if (doc.containsKey("properties") && doc.get("properties") instanceof Map) {
                    return (Map)doc.get("properties");
                }
            } else if (mapping.containsKey("properties") && mapping.get("properties") instanceof Map) {
                return (Map)mapping.get("properties");
            }
        }
        catch (ClassCastException e) {
            throw new IllegalArgumentException(String.format(Locale.ROOT, "Failed to get the mapping properties to process the semantic field due to %s", e.getMessage()), e);
        }
        return new HashMap<String, Object>();
    }

    public static String validateModelId(@NonNull String semanticFieldPath, @NonNull Map<String, Object> semanticFieldConfig) {
        Objects.requireNonNull(semanticFieldPath, "semanticFieldPath is marked non-null but is null");
        Objects.requireNonNull(semanticFieldConfig, "semanticFieldConfig is marked non-null but is null");
        Object modelId = semanticFieldConfig.get("model_id");
        if (modelId == null) {
            return String.format(Locale.ROOT, "%s is required for the semantic field at %s", "model_id", semanticFieldPath);
        }
        if (!(modelId instanceof String) || ((String)modelId).isEmpty()) {
            return String.format(Locale.ROOT, "%s should be a non-empty string for the semantic field at %s", "model_id", semanticFieldPath);
        }
        return null;
    }

    public static String validateSemanticInfoFieldName(@NonNull String semanticFieldPath, @NonNull Map<String, Object> semanticFieldConfig) {
        Objects.requireNonNull(semanticFieldPath, "semanticFieldPath is marked non-null but is null");
        Objects.requireNonNull(semanticFieldConfig, "semanticFieldConfig is marked non-null but is null");
        if (semanticFieldConfig.containsKey("semantic_info_field_name")) {
            Object semanticInfoFieldName = semanticFieldConfig.get("semantic_info_field_name");
            if (semanticInfoFieldName instanceof String) {
                String semanticInfoFieldNameStr = (String)semanticInfoFieldName;
                if (semanticInfoFieldNameStr.isEmpty()) {
                    return String.format(Locale.ROOT, "%s cannot be an empty string for the semantic field at %s", "semantic_info_field_name", semanticFieldPath);
                }
                if (semanticInfoFieldNameStr.contains(".")) {
                    return String.format(Locale.ROOT, "%s should not contain '.' for the semantic field at %s", "semantic_info_field_name", semanticFieldPath);
                }
            } else {
                return String.format(Locale.ROOT, "%s should be a non-empty string for the semantic field at %s", "semantic_info_field_name", semanticFieldPath);
            }
        }
        return null;
    }

    public static Map<String, Object> getFieldConfigByPath(Map<String, Object> mapping, String path) {
        String[] paths = path.split("\\.");
        Map currentMapping = SemanticMappingUtils.getProperties(mapping);
        for (int i = 0; i < paths.length; ++i) {
            if (currentMapping == null) {
                return null;
            }
            Object temp = currentMapping.get(paths[i]);
            if (temp instanceof Map) {
                currentMapping = (Map)temp;
                if (i >= paths.length - 1 || !currentMapping.containsKey("properties")) continue;
                currentMapping = (Map)currentMapping.get("properties");
                continue;
            }
            return null;
        }
        return currentMapping;
    }

    public static Map<String, NeuralQueryTargetFieldConfig> getIndexToTargetFieldConfigMapFromIndexMetadata(@NonNull String fieldName, @NonNull List<IndexMetadata> targetIndexMetadataList) {
        Objects.requireNonNull(fieldName, "fieldName is marked non-null but is null");
        Objects.requireNonNull(targetIndexMetadataList, "targetIndexMetadataList is marked non-null but is null");
        HashMap<String, NeuralQueryTargetFieldConfig> indexToTargetFieldConfigMap = new HashMap<String, NeuralQueryTargetFieldConfig>();
        for (IndexMetadata indexMetadata : targetIndexMetadataList) {
            if (indexMetadata == null) continue;
            MappingMetadata mappingMetadata = indexMetadata.mapping();
            NeuralQueryTargetFieldConfig.NeuralQueryTargetFieldConfigBuilder targetFieldConfigBuilder = NeuralQueryTargetFieldConfig.builder();
            if (mappingMetadata == null) {
                indexToTargetFieldConfigMap.put(indexMetadata.getIndex().toString(), targetFieldConfigBuilder.isUnmappedField(true).build());
                continue;
            }
            Map mappings = mappingMetadata.sourceAsMap();
            Map<String, Object> targetFieldConfig = SemanticMappingUtils.getFieldConfigByPath(mappings, fieldName);
            if (targetFieldConfig == null) {
                indexToTargetFieldConfigMap.put(indexMetadata.getIndex().toString(), targetFieldConfigBuilder.isUnmappedField(true).build());
                continue;
            }
            targetFieldConfigBuilder.isUnmappedField(false);
            Object targetFieldTypeObject = targetFieldConfig.get("type");
            if (!(targetFieldTypeObject instanceof String)) {
                throw new IllegalArgumentException(String.format(Locale.ROOT, "Failed to process the neural query against the field [%s] because it is an object field.", fieldName));
            }
            String targetFieldType = (String)targetFieldTypeObject;
            if ("semantic".equals(targetFieldType)) {
                Map<String, Object> embeddingFieldConfig = SemanticMappingUtils.getSemanticEmbeddingFieldConfig(fieldName, targetFieldConfig, mappings, targetFieldConfigBuilder);
                String embeddingFieldType = (String)embeddingFieldConfig.get("type");
                String semanticFieldSearchAnalyzer = null;
                if (targetFieldConfig.containsKey("semantic_field_search_analyzer")) {
                    semanticFieldSearchAnalyzer = (String)targetFieldConfig.get("semantic_field_search_analyzer");
                }
                String searchModelId = (String)targetFieldConfig.get("model_id");
                if (targetFieldConfig.containsKey("search_model_id")) {
                    searchModelId = (String)targetFieldConfig.get("search_model_id");
                }
                targetFieldConfigBuilder.embeddingFieldType(embeddingFieldType);
                targetFieldConfigBuilder.searchModelId(searchModelId);
                targetFieldConfigBuilder.isSemanticField(Boolean.TRUE);
                targetFieldConfigBuilder.semanticFieldSearchAnalyzer(semanticFieldSearchAnalyzer);
            } else if ("knn_vector".equals(targetFieldType)) {
                targetFieldConfigBuilder.isSemanticField(Boolean.FALSE);
                targetFieldConfigBuilder.embeddingFieldType(targetFieldType);
            } else {
                throw new IllegalArgumentException(String.format(Locale.ROOT, "Failed to process the neural query against the field %s because its type is not supported. It should be one of [%s]", fieldName, String.join((CharSequence)",", NeuralQueryBuilder.SUPPORTED_TARGET_FIELD_TYPES)));
            }
            indexToTargetFieldConfigMap.put(indexMetadata.getIndex().toString(), targetFieldConfigBuilder.build());
        }
        return indexToTargetFieldConfigMap;
    }

    private static Map<String, Object> getSemanticEmbeddingFieldConfig(@NonNull String fieldName, @NonNull Map<String, Object> targetFieldConfig, @NonNull Map<String, Object> mappings, @NonNull NeuralQueryTargetFieldConfig.NeuralQueryTargetFieldConfigBuilder targetFieldConfigBuilder) {
        Object embeddingFieldPath;
        Objects.requireNonNull(fieldName, "fieldName is marked non-null but is null");
        Objects.requireNonNull(targetFieldConfig, "targetFieldConfig is marked non-null but is null");
        Objects.requireNonNull(mappings, "mappings is marked non-null but is null");
        Objects.requireNonNull(targetFieldConfigBuilder, "targetFieldConfigBuilder is marked non-null but is null");
        String semanticInfoFieldFullPath = SemanticMappingUtils.getSemanticInfoFieldFullPath(targetFieldConfig, fieldName, fieldName);
        Boolean chunkingEnabled = SemanticMappingUtils.isChunkingEnabled(targetFieldConfig, fieldName);
        targetFieldConfigBuilder.chunkingEnabled(chunkingEnabled);
        if (Boolean.TRUE.equals(chunkingEnabled)) {
            targetFieldConfigBuilder.chunksPath(semanticInfoFieldFullPath + ".chunks");
            embeddingFieldPath = semanticInfoFieldFullPath + "." + "chunks" + "." + "embedding";
        } else {
            embeddingFieldPath = semanticInfoFieldFullPath + ".embedding";
        }
        targetFieldConfigBuilder.embeddingFieldPath((String)embeddingFieldPath);
        return SemanticMappingUtils.getFieldConfigByPath(mappings, (String)embeddingFieldPath);
    }

    public static Boolean isChunkingEnabled(@NonNull Map<String, Object> fieldConfigMap, @NonNull String semanticFieldPath) {
        Objects.requireNonNull(fieldConfigMap, "fieldConfigMap is marked non-null but is null");
        Objects.requireNonNull(semanticFieldPath, "semanticFieldPath is marked non-null but is null");
        if (fieldConfigMap.containsKey("chunking")) {
            Object chunkingEnabledObj = fieldConfigMap.get("chunking");
            if (chunkingEnabledObj instanceof Boolean) {
                return (Boolean)chunkingEnabledObj;
            }
            throw new IllegalArgumentException(String.format(Locale.ROOT, "%s should be a boolean for the semantic field at %s", "chunking", semanticFieldPath));
        }
        return false;
    }

    public static String getSemanticFieldSearchAnalyzer(@NonNull Map<String, Object> fieldConfigMap, @NonNull String semanticFieldPath) {
        Objects.requireNonNull(fieldConfigMap, "fieldConfigMap is marked non-null but is null");
        Objects.requireNonNull(semanticFieldPath, "semanticFieldPath is marked non-null but is null");
        if (fieldConfigMap.containsKey("semantic_field_search_analyzer")) {
            Object semanticFieldSearchAnalyzer = fieldConfigMap.get("semantic_field_search_analyzer");
            if (semanticFieldSearchAnalyzer instanceof String) {
                return (String)semanticFieldSearchAnalyzer;
            }
            throw new IllegalArgumentException(String.format(Locale.ROOT, "%s should be a String for the semantic field at %s", "semantic_field_search_analyzer", semanticFieldPath));
        }
        return null;
    }

    private static class CollectSemanticFieldStackEntry {
        Map<String, Object> mapping;
        String path;
        int depth;

        @Generated
        public CollectSemanticFieldStackEntry(Map<String, Object> mapping, String path, int depth) {
            this.mapping = mapping;
            this.path = path;
            this.depth = depth;
        }
    }
}

