/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.neuralsearch.mappingtransformer;

import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import lombok.NonNull;
import org.opensearch.core.xcontent.NamedXContentRegistry;
import org.opensearch.ml.common.FunctionName;
import org.opensearch.ml.common.MLModel;
import org.opensearch.ml.common.model.MLModelConfig;
import org.opensearch.ml.common.model.TextEmbeddingModelConfig;
import org.opensearch.neuralsearch.constants.SemanticInfoFieldConstants;
import org.opensearch.neuralsearch.mappingtransformer.SemanticMappingTransformer;

public class SemanticInfoConfigBuilder {
    private final NamedXContentRegistry xContentRegistry;
    private String embeddingFieldType;
    private String spaceType;
    private String knnMethodName = "hnsw";
    private Integer embeddingDimension;
    private Boolean chunkingEnabled;
    private String semanticFieldSearchAnalyzer;

    public SemanticInfoConfigBuilder(@reactor.util.annotation.NonNull NamedXContentRegistry xContentRegistry) {
        this.xContentRegistry = xContentRegistry;
    }

    public Map<String, Object> build() {
        if (this.semanticFieldSearchAnalyzer != null && !"rank_features".equals(this.embeddingFieldType)) {
            throw new IllegalArgumentException(String.format(Locale.ROOT, "Cannot build the semantic info config because the embedding field type %s cannot build with semantic field search analyzer %s", this.embeddingFieldType, this.semanticFieldSearchAnalyzer));
        }
        Map<String, Object> embeddingFieldConfig = switch (this.embeddingFieldType) {
            case "knn_vector" -> this.buildKnnFieldConfig();
            case "rank_features" -> this.buildRankFeaturesFieldConfig();
            default -> throw new IllegalArgumentException(String.format(Locale.ROOT, "Cannot build the semantic info config because the embedding field type %s is not supported.", this.embeddingFieldType));
        };
        if (this.chunkingEnabled.booleanValue()) {
            Map<String, Map<String, Map<String, Object>>> chunksConfig = Map.of("type", "nested", "properties", Map.of("text", Map.of("type", "text"), "embedding", embeddingFieldConfig));
            return Map.of("properties", Map.of("chunks", chunksConfig, "model", SemanticInfoFieldConstants.DEFAULT_MODEL_CONFIG));
        }
        return Map.of("properties", Map.of("embedding", embeddingFieldConfig, "model", SemanticInfoFieldConstants.DEFAULT_MODEL_CONFIG));
    }

    private Map<String, Object> buildKnnFieldConfig() {
        HashMap<String, Object> config = new HashMap<String, Object>();
        config.put("type", "knn_vector");
        config.put("dimension", this.embeddingDimension);
        HashMap<String, String> methodConfig = new HashMap<String, String>();
        methodConfig.put("name", this.knnMethodName);
        methodConfig.put("space_type", this.spaceType);
        config.put("method", methodConfig);
        return config;
    }

    private Map<String, Object> buildRankFeaturesFieldConfig() {
        HashMap<String, Object> config = new HashMap<String, Object>();
        config.put("type", "rank_features");
        return config;
    }

    public SemanticInfoConfigBuilder mlModel(@reactor.util.annotation.NonNull MLModel mlModel, @reactor.util.annotation.NonNull String modelId) {
        switch (mlModel.getAlgorithm()) {
            case TEXT_EMBEDDING: {
                this.extractInfoForTextEmbeddingModel(mlModel, modelId);
                break;
            }
            case SPARSE_ENCODING: 
            case SPARSE_TOKENIZE: {
                this.extractInfoForSparseModel();
                break;
            }
            case REMOTE: {
                this.extractInfoForRemoteModel(mlModel, modelId);
                break;
            }
            default: {
                throw new IllegalArgumentException(String.format(Locale.ROOT, "The algorithm %s of the model %s is not supported in the semantic field. Supported algorithms: [%s].", mlModel.getAlgorithm().name(), modelId, String.join((CharSequence)",", SemanticMappingTransformer.SUPPORTED_MODEL_ALGORITHMS)));
            }
        }
        return this;
    }

    private void extractInfoForTextEmbeddingModel(@reactor.util.annotation.NonNull MLModel mlModel, @reactor.util.annotation.NonNull String modelId) {
        Object spaceTypeObject;
        this.embeddingFieldType = "knn_vector";
        if (!(mlModel.getModelConfig() instanceof TextEmbeddingModelConfig)) {
            throw new IllegalArgumentException(String.format(Locale.ROOT, "Model %s is a remote text embedding model but model config is not a text embedding config", modelId));
        }
        TextEmbeddingModelConfig textEmbeddingModelConfig = (TextEmbeddingModelConfig)mlModel.getModelConfig();
        if (textEmbeddingModelConfig.getEmbeddingDimension() == null) {
            throw new IllegalArgumentException(String.format(Locale.ROOT, "Model %s is a remote text embedding model but the embedding dimension is not defined in the model config.", modelId));
        }
        this.embeddingDimension = textEmbeddingModelConfig.getEmbeddingDimension();
        Map additionalConfig = textEmbeddingModelConfig.getAdditionalConfig();
        if (additionalConfig != null) {
            spaceTypeObject = additionalConfig.get("space_type");
            if (!(spaceTypeObject instanceof String)) {
                throw this.createInvalidSpaceTypeException(modelId);
            }
        } else {
            throw this.createInvalidSpaceTypeException(modelId);
        }
        this.spaceType = (String)spaceTypeObject;
    }

    private IllegalArgumentException createInvalidSpaceTypeException(@reactor.util.annotation.NonNull String modelId) {
        return new IllegalArgumentException(String.format(Locale.ROOT, "space_type is not defined or not a string in the additional_config of the model %s.", modelId));
    }

    private void extractInfoForSparseModel() {
        this.embeddingFieldType = "rank_features";
    }

    private void extractInfoForRemoteModel(@reactor.util.annotation.NonNull MLModel mlModel, @reactor.util.annotation.NonNull String modelId) {
        FunctionName modelTypeFunctionName;
        MLModelConfig mlModelConfig = mlModel.getModelConfig();
        if (mlModelConfig == null) {
            throw new IllegalArgumentException(String.format(Locale.ROOT, "Model config is null for the remote model %s.", modelId));
        }
        String modelType = mlModel.getModelConfig().getModelType();
        try {
            modelTypeFunctionName = FunctionName.from((String)modelType);
        }
        catch (IllegalArgumentException e) {
            throw new IllegalArgumentException(this.getUnsupportedRemoteModelError(modelType, modelId));
        }
        switch (modelTypeFunctionName) {
            case TEXT_EMBEDDING: {
                this.extractInfoForTextEmbeddingModel(mlModel, modelId);
                break;
            }
            case SPARSE_ENCODING: 
            case SPARSE_TOKENIZE: {
                this.extractInfoForSparseModel();
                break;
            }
            default: {
                throw new IllegalArgumentException(this.getUnsupportedRemoteModelError(modelType, modelId));
            }
        }
    }

    private String getUnsupportedRemoteModelError(String modelType, @NonNull String modelId) {
        Objects.requireNonNull(modelId, "modelId is marked non-null but is null");
        return String.format(Locale.ROOT, "The model type %s of the model %s is not supported in the semantic field. Supported remote model types: [%s]", modelType, modelId, String.join((CharSequence)",", SemanticMappingTransformer.SUPPORTED_REMOTE_MODEL_TYPES));
    }

    public SemanticInfoConfigBuilder chunkingEnabled(Boolean chunkingEnabled) {
        this.chunkingEnabled = chunkingEnabled;
        return this;
    }

    public SemanticInfoConfigBuilder semanticFieldSearchAnalyzer(String semanticFieldSearchAnalyzer) {
        this.semanticFieldSearchAnalyzer = semanticFieldSearchAnalyzer;
        return this;
    }
}

