/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.indexmanagement.indexstatemanagement.validation;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.opensearch.cluster.metadata.AliasMetadata;
import org.opensearch.cluster.metadata.IndexAbstraction;
import org.opensearch.cluster.metadata.IndexMetadata;
import org.opensearch.cluster.service.ClusterService;
import org.opensearch.common.settings.Settings;
import org.opensearch.indexmanagement.indexstatemanagement.opensearchapi.OpenSearchExtensionsKt;
import org.opensearch.indexmanagement.spi.indexstatemanagement.Validate;
import org.opensearch.indexmanagement.util.OpenForTesting;
import org.opensearch.monitor.jvm.JvmService;

@OpenForTesting
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0017\u0018\u0000 \u00172\u00020\u0001:\u0001\u0017B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u001a\u0010\f\u001a\u00020\r2\b\u0010\u000e\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\u0010\u001a\u00020\u000fH\u0012J\u0010\u0010\u0011\u001a\u00020\u00012\u0006\u0010\u0010\u001a\u00020\u000fH\u0016J\u001e\u0010\u0012\u001a\u0010\u0012\u0006\u0012\u0004\u0018\u00010\u000f\u0012\u0004\u0012\u00020\r0\u00132\u0006\u0010\u0010\u001a\u00020\u000fH\u0012J\u001a\u0010\u0014\u001a\u00020\r2\b\u0010\u000e\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\u0010\u001a\u00020\u000fH\u0012J\u001a\u0010\u0015\u001a\u00020\r2\b\u0010\u000e\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\u0010\u001a\u00020\u000fH\u0012J\u0010\u0010\u0016\u001a\u00020\r2\u0006\u0010\u0010\u001a\u00020\u000fH\u0012R\u0016\u0010\t\u001a\n \u000b*\u0004\u0018\u00010\n0\nX\u0092\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Lorg/opensearch/indexmanagement/indexstatemanagement/validation/ValidateRollover;", "Lorg/opensearch/indexmanagement/spi/indexstatemanagement/Validate;", "settings", "Lorg/opensearch/common/settings/Settings;", "clusterService", "Lorg/opensearch/cluster/service/ClusterService;", "jvmService", "Lorg/opensearch/monitor/jvm/JvmService;", "(Lorg/opensearch/common/settings/Settings;Lorg/opensearch/cluster/service/ClusterService;Lorg/opensearch/monitor/jvm/JvmService;)V", "logger", "Lorg/apache/logging/log4j/Logger;", "kotlin.jvm.PlatformType", "alreadyRolledOver", "", "alias", "", "indexName", "execute", "getRolloverTargetOrUpdateInfo", "Lkotlin/Pair;", "hasAlias", "isWriteIndex", "skipRollover", "Companion", "opensearch-index-management"})
@SourceDebugExtension(value={"SMAP\nValidateRollover.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ValidateRollover.kt\norg/opensearch/indexmanagement/indexstatemanagement/validation/ValidateRollover\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,135:1\n1549#2:136\n1620#2,3:137\n*S KotlinDebug\n*F\n+ 1 ValidateRollover.kt\norg/opensearch/indexmanagement/indexstatemanagement/validation/ValidateRollover\n*L\n83#1:136\n83#1:137,3\n*E\n"})
public class ValidateRollover
extends Validate {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private final Logger logger;
    @NotNull
    public static final String name = "validate_rollover";

    public ValidateRollover(@NotNull Settings settings, @NotNull ClusterService clusterService, @NotNull JvmService jvmService) {
        Intrinsics.checkNotNullParameter((Object)settings, (String)"settings");
        Intrinsics.checkNotNullParameter((Object)clusterService, (String)"clusterService");
        Intrinsics.checkNotNullParameter((Object)jvmService, (String)"jvmService");
        super(settings, clusterService, jvmService);
        this.logger = LogManager.getLogger(((Object)((Object)this)).getClass());
    }

    @NotNull
    public Validate execute(@NotNull String indexName) {
        Intrinsics.checkNotNullParameter((Object)indexName, (String)"indexName");
        Pair<String, Boolean> pair = this.getRolloverTargetOrUpdateInfo(indexName);
        String rolloverTarget = (String)pair.component1();
        boolean isDataStream = (Boolean)pair.component2();
        if (rolloverTarget == null) {
            return this;
        }
        if (this.skipRollover(indexName) || this.alreadyRolledOver(rolloverTarget, indexName)) {
            return this;
        }
        if (!(isDataStream || this.hasAlias(rolloverTarget, indexName) && this.isWriteIndex(rolloverTarget, indexName))) {
            return this;
        }
        this.setValidationMessage(Companion.getValidationPassedMessage(indexName));
        return this;
    }

    private boolean skipRollover(String indexName) {
        IndexMetadata indexMetadata2 = this.getClusterService().state().getMetadata().index(indexName);
        Intrinsics.checkNotNullExpressionValue((Object)indexMetadata2, (String)"index(...)");
        boolean skipRollover = OpenSearchExtensionsKt.getRolloverSkip(indexMetadata2);
        if (skipRollover) {
            this.setValidationStatus(Validate.ValidationStatus.PASSED);
            this.setValidationMessage(Companion.getSkipRolloverMessage(indexName));
            return true;
        }
        return false;
    }

    private boolean alreadyRolledOver(String alias, String indexName) {
        if (this.getClusterService().state().getMetadata().index(indexName).getRolloverInfos().containsKey(alias)) {
            this.setValidationStatus(Validate.ValidationStatus.PASSED);
            this.setValidationMessage(Companion.getAlreadyRolledOverMessage(indexName, alias));
            return true;
        }
        return false;
    }

    private boolean hasAlias(String alias, String indexName) {
        org.opensearch.cluster.metadata.Metadata metadata2 = this.getClusterService().state().getMetadata();
        Object object = metadata2.index(indexName);
        AliasMetadata indexAlias = object != null && (object = object.getAliases()) != null ? (AliasMetadata)object.get(alias) : null;
        this.logger.debug("Index " + indexName + " has aliases " + indexAlias);
        if (indexAlias == null) {
            String message = Companion.getMissingAliasMessage(indexName);
            this.logger.warn(message);
            this.setValidationStatus(Validate.ValidationStatus.RE_VALIDATING);
            this.setValidationMessage(message);
            return false;
        }
        return true;
    }

    /*
     * WARNING - void declaration
     */
    private boolean isWriteIndex(String alias, String indexName) {
        Boolean isWriteIndex;
        AliasMetadata indexAlias;
        org.opensearch.cluster.metadata.Metadata metadata2 = this.getClusterService().state().getMetadata();
        Object object = metadata2.index(indexName);
        AliasMetadata aliasMetadata = indexAlias = object != null && (object = object.getAliases()) != null ? (AliasMetadata)object.get(alias) : null;
        Boolean bl = isWriteIndex = aliasMetadata != null ? aliasMetadata.writeIndex() : null;
        if (!Intrinsics.areEqual((Object)isWriteIndex, (Object)true)) {
            List list;
            Object object2 = (IndexAbstraction)metadata2.getIndicesLookup().get(alias);
            if (object2 != null && (object2 = object2.getIndices()) != null) {
                void $this$mapTo$iv$iv;
                Iterable $this$map$iv = (Iterable)object2;
                boolean $i$f$map = false;
                Iterable iterable = $this$map$iv;
                Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv) {
                    void it;
                    IndexMetadata indexMetadata2 = (IndexMetadata)item$iv$iv;
                    Collection collection = destination$iv$iv;
                    boolean bl2 = false;
                    collection.add(it.getIndex());
                }
                list = (List)destination$iv$iv;
            } else {
                list = null;
            }
            List aliasIndices = list;
            this.logger.debug("Alias " + alias + " contains indices " + aliasIndices);
            if (aliasIndices != null && aliasIndices.size() > 1) {
                String message = Companion.getFailedWriteIndexMessage(indexName);
                this.logger.warn(message);
                this.setValidationStatus(Validate.ValidationStatus.RE_VALIDATING);
                this.setValidationMessage(message);
                return false;
            }
        }
        return true;
    }

    private Pair<String, Boolean> getRolloverTargetOrUpdateInfo(String indexName) {
        String rolloverTarget;
        IndexAbstraction indexAbstraction;
        org.opensearch.cluster.metadata.Metadata metadata2 = this.getClusterService().state().metadata();
        IndexAbstraction indexAbstraction2 = indexAbstraction = (IndexAbstraction)metadata2.getIndicesLookup().get(indexName);
        boolean isDataStreamIndex = (indexAbstraction2 != null ? indexAbstraction2.getParentDataStream() : null) != null;
        if (isDataStreamIndex) {
            IndexAbstraction indexAbstraction3 = indexAbstraction;
            v2 = indexAbstraction3 != null && (indexAbstraction3 = indexAbstraction3.getParentDataStream()) != null ? indexAbstraction3.getName() : null;
        } else {
            IndexMetadata indexMetadata2 = metadata2.index(indexName);
            Intrinsics.checkNotNullExpressionValue((Object)indexMetadata2, (String)"index(...)");
            v2 = rolloverTarget = OpenSearchExtensionsKt.getRolloverAlias(indexMetadata2);
        }
        if (rolloverTarget == null) {
            String message = Companion.getFailedNoValidAliasMessage(indexName);
            this.logger.warn(message);
            this.setValidationStatus(Validate.ValidationStatus.RE_VALIDATING);
            this.setValidationMessage(message);
        }
        return TuplesKt.to((Object)rolloverTarget, (Object)isDataStreamIndex);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\t\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0006\u001a\u00020\u00042\b\u0010\u0007\u001a\u0004\u0018\u00010\u0004J\u000e\u0010\b\u001a\u00020\u00042\u0006\u0010\u0006\u001a\u00020\u0004J\u000e\u0010\t\u001a\u00020\u00042\u0006\u0010\u0006\u001a\u00020\u0004J\u000e\u0010\n\u001a\u00020\u00042\u0006\u0010\u0006\u001a\u00020\u0004J\u000e\u0010\u000b\u001a\u00020\u00042\u0006\u0010\u0006\u001a\u00020\u0004J\u000e\u0010\f\u001a\u00020\u00042\u0006\u0010\u0006\u001a\u00020\u0004R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lorg/opensearch/indexmanagement/indexstatemanagement/validation/ValidateRollover$Companion;", "", "()V", "name", "", "getAlreadyRolledOverMessage", "index", "alias", "getFailedNoValidAliasMessage", "getFailedWriteIndexMessage", "getMissingAliasMessage", "getSkipRolloverMessage", "getValidationPassedMessage", "opensearch-index-management"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final String getFailedWriteIndexMessage(@NotNull String index2) {
            Intrinsics.checkNotNullParameter((Object)index2, (String)"index");
            return "Not the write index when rollover [index=" + index2 + "]";
        }

        @NotNull
        public final String getMissingAliasMessage(@NotNull String index2) {
            Intrinsics.checkNotNullParameter((Object)index2, (String)"index");
            return "Missing alias when rollover [index=" + index2 + "]";
        }

        @NotNull
        public final String getFailedNoValidAliasMessage(@NotNull String index2) {
            Intrinsics.checkNotNullParameter((Object)index2, (String)"index");
            return "Missing rollover_alias index setting [index=" + index2 + "]";
        }

        @NotNull
        public final String getAlreadyRolledOverMessage(@NotNull String index2, @Nullable String alias) {
            Intrinsics.checkNotNullParameter((Object)index2, (String)"index");
            return "This index has already been rolled over using this alias, treating as a success [index=" + index2 + ", alias=" + alias + "]";
        }

        @NotNull
        public final String getSkipRolloverMessage(@NotNull String index2) {
            Intrinsics.checkNotNullParameter((Object)index2, (String)"index");
            return "Skipped rollover action for [index=" + index2 + "]";
        }

        @NotNull
        public final String getValidationPassedMessage(@NotNull String index2) {
            Intrinsics.checkNotNullParameter((Object)index2, (String)"index");
            return "Rollover validation passed for [index=" + index2 + "]";
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

