/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.indexmanagement.indexstatemanagement.transport.action.getpolicy;

import java.io.IOException;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.opensearch.action.ActionRequest;
import org.opensearch.action.ActionRequestValidationException;
import org.opensearch.action.ValidateActions;
import org.opensearch.core.common.io.stream.StreamInput;
import org.opensearch.core.common.io.stream.StreamOutput;
import org.opensearch.search.fetch.subphase.FetchSourceContext;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u001f\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bB\u000f\b\u0016\u0012\u0006\u0010\t\u001a\u00020\n\u00a2\u0006\u0002\u0010\u000bJ\n\u0010\u0012\u001a\u0004\u0018\u00010\u0013H\u0016J\u0010\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0017H\u0016R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011\u00a8\u0006\u0018"}, d2={"Lorg/opensearch/indexmanagement/indexstatemanagement/transport/action/getpolicy/GetPolicyRequest;", "Lorg/opensearch/action/ActionRequest;", "policyID", "", "version", "", "fetchSrcContext", "Lorg/opensearch/search/fetch/subphase/FetchSourceContext;", "(Ljava/lang/String;JLorg/opensearch/search/fetch/subphase/FetchSourceContext;)V", "sin", "Lorg/opensearch/core/common/io/stream/StreamInput;", "(Lorg/opensearch/core/common/io/stream/StreamInput;)V", "getFetchSrcContext", "()Lorg/opensearch/search/fetch/subphase/FetchSourceContext;", "getPolicyID", "()Ljava/lang/String;", "getVersion", "()J", "validate", "Lorg/opensearch/action/ActionRequestValidationException;", "writeTo", "", "out", "Lorg/opensearch/core/common/io/stream/StreamOutput;", "opensearch-index-management"})
public final class GetPolicyRequest
extends ActionRequest {
    @NotNull
    private final String policyID;
    private final long version;
    @NotNull
    private final FetchSourceContext fetchSrcContext;

    @NotNull
    public final String getPolicyID() {
        return this.policyID;
    }

    public final long getVersion() {
        return this.version;
    }

    @NotNull
    public final FetchSourceContext getFetchSrcContext() {
        return this.fetchSrcContext;
    }

    public GetPolicyRequest(@NotNull String policyID, long version, @NotNull FetchSourceContext fetchSrcContext) {
        Intrinsics.checkNotNullParameter((Object)policyID, (String)"policyID");
        Intrinsics.checkNotNullParameter((Object)fetchSrcContext, (String)"fetchSrcContext");
        this.policyID = policyID;
        this.version = version;
        this.fetchSrcContext = fetchSrcContext;
    }

    public GetPolicyRequest(@NotNull StreamInput sin) throws IOException {
        Intrinsics.checkNotNullParameter((Object)sin, (String)"sin");
        String string = sin.readString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"readString(...)");
        this(string, sin.readLong(), new FetchSourceContext(sin));
    }

    @Nullable
    public ActionRequestValidationException validate() {
        ActionRequestValidationException validationException = null;
        if (StringsKt.isBlank((CharSequence)this.policyID)) {
            validationException = ValidateActions.addValidationError((String)"Missing policy ID", validationException);
        }
        return validationException;
    }

    public void writeTo(@NotNull StreamOutput out) throws IOException {
        Intrinsics.checkNotNullParameter((Object)out, (String)"out");
        out.writeString(this.policyID);
        out.writeLong(this.version);
        this.fetchSrcContext.writeTo(out);
    }
}

