/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.indexmanagement.indexstatemanagement.transport.action.explain;

import java.io.IOException;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.opensearch.action.ActionRequest;
import org.opensearch.action.ActionRequestValidationException;
import org.opensearch.action.ValidateActions;
import org.opensearch.common.unit.TimeValue;
import org.opensearch.core.common.io.stream.StreamInput;
import org.opensearch.core.common.io.stream.StreamOutput;
import org.opensearch.core.common.io.stream.Writeable;
import org.opensearch.indexmanagement.common.model.rest.SearchParams;
import org.opensearch.indexmanagement.indexstatemanagement.model.ExplainFilter;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0010\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 (2\u00020\u0001:\u0001(BO\b\u0016\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\n\u0012\b\u0010\u000b\u001a\u0004\u0018\u00010\f\u0012\u0006\u0010\r\u001a\u00020\u0006\u0012\u0006\u0010\u000e\u001a\u00020\u0006\u0012\u0006\u0010\u000f\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0010B\u000f\b\u0016\u0012\u0006\u0010\u0011\u001a\u00020\u0012\u00a2\u0006\u0002\u0010\u0013J\n\u0010\"\u001a\u0004\u0018\u00010#H\u0016J\u0010\u0010$\u001a\u00020%2\u0006\u0010&\u001a\u00020'H\u0016R\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R\u0013\u0010\u000b\u001a\u0004\u0018\u00010\f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017R\u0011\u0010\u000f\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0019R\u0017\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u001bR\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001c\u0010\u001dR\u0011\u0010\t\u001a\u00020\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001e\u0010\u001fR\u0011\u0010\r\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b \u0010\u001dR\u0011\u0010\u000e\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b!\u0010\u001d\u00a8\u0006)"}, d2={"Lorg/opensearch/indexmanagement/indexstatemanagement/transport/action/explain/ExplainRequest;", "Lorg/opensearch/action/ActionRequest;", "indices", "", "", "local", "", "clusterManagerTimeout", "Lorg/opensearch/common/unit/TimeValue;", "searchParams", "Lorg/opensearch/indexmanagement/common/model/rest/SearchParams;", "explainFilter", "Lorg/opensearch/indexmanagement/indexstatemanagement/model/ExplainFilter;", "showPolicy", "validateAction", "indexType", "(Ljava/util/List;ZLorg/opensearch/common/unit/TimeValue;Lorg/opensearch/indexmanagement/common/model/rest/SearchParams;Lorg/opensearch/indexmanagement/indexstatemanagement/model/ExplainFilter;ZZLjava/lang/String;)V", "sin", "Lorg/opensearch/core/common/io/stream/StreamInput;", "(Lorg/opensearch/core/common/io/stream/StreamInput;)V", "getClusterManagerTimeout", "()Lorg/opensearch/common/unit/TimeValue;", "getExplainFilter", "()Lorg/opensearch/indexmanagement/indexstatemanagement/model/ExplainFilter;", "getIndexType", "()Ljava/lang/String;", "getIndices", "()Ljava/util/List;", "getLocal", "()Z", "getSearchParams", "()Lorg/opensearch/indexmanagement/common/model/rest/SearchParams;", "getShowPolicy", "getValidateAction", "validate", "Lorg/opensearch/action/ActionRequestValidationException;", "writeTo", "", "out", "Lorg/opensearch/core/common/io/stream/StreamOutput;", "Companion", "opensearch-index-management"})
public final class ExplainRequest
extends ActionRequest {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final List<String> indices;
    private final boolean local;
    @NotNull
    private final TimeValue clusterManagerTimeout;
    @NotNull
    private final SearchParams searchParams;
    @Nullable
    private final ExplainFilter explainFilter;
    private final boolean showPolicy;
    private final boolean validateAction;
    @NotNull
    private final String indexType;
    @NotNull
    public static final String MULTIPLE_INDICES_CUSTOM_INDEX_TYPE_ERROR = "Cannot call explain on more than one index name/pattern when using a custom index type";

    @NotNull
    public final List<String> getIndices() {
        return this.indices;
    }

    public final boolean getLocal() {
        return this.local;
    }

    @NotNull
    public final TimeValue getClusterManagerTimeout() {
        return this.clusterManagerTimeout;
    }

    @NotNull
    public final SearchParams getSearchParams() {
        return this.searchParams;
    }

    @Nullable
    public final ExplainFilter getExplainFilter() {
        return this.explainFilter;
    }

    public final boolean getShowPolicy() {
        return this.showPolicy;
    }

    public final boolean getValidateAction() {
        return this.validateAction;
    }

    @NotNull
    public final String getIndexType() {
        return this.indexType;
    }

    public ExplainRequest(@NotNull List<String> indices, boolean local, @NotNull TimeValue clusterManagerTimeout, @NotNull SearchParams searchParams, @Nullable ExplainFilter explainFilter, boolean showPolicy, boolean validateAction, @NotNull String indexType) {
        Intrinsics.checkNotNullParameter(indices, (String)"indices");
        Intrinsics.checkNotNullParameter((Object)clusterManagerTimeout, (String)"clusterManagerTimeout");
        Intrinsics.checkNotNullParameter((Object)searchParams, (String)"searchParams");
        Intrinsics.checkNotNullParameter((Object)indexType, (String)"indexType");
        this.indices = indices;
        this.local = local;
        this.clusterManagerTimeout = clusterManagerTimeout;
        this.searchParams = searchParams;
        this.explainFilter = explainFilter;
        this.showPolicy = showPolicy;
        this.validateAction = validateAction;
        this.indexType = indexType;
    }

    public ExplainRequest(@NotNull StreamInput sin) throws IOException {
        Intrinsics.checkNotNullParameter((Object)sin, (String)"sin");
        List list = sin.readStringList();
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"readStringList(...)");
        boolean bl = sin.readBoolean();
        TimeValue timeValue = sin.readTimeValue();
        Intrinsics.checkNotNullExpressionValue((Object)timeValue, (String)"readTimeValue(...)");
        SearchParams searchParams = new SearchParams(sin);
        ExplainFilter explainFilter = (ExplainFilter)sin.readOptionalWriteable(ExplainFilter::new);
        boolean bl2 = sin.readBoolean();
        boolean bl3 = sin.readBoolean();
        String string = sin.readString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"readString(...)");
        this(list, bl, timeValue, searchParams, explainFilter, bl2, bl3, string);
    }

    @Nullable
    public ActionRequestValidationException validate() {
        ActionRequestValidationException validationException = null;
        if (!Intrinsics.areEqual((Object)this.indexType, (Object)"_default") && this.indices.size() > 1) {
            validationException = ValidateActions.addValidationError((String)MULTIPLE_INDICES_CUSTOM_INDEX_TYPE_ERROR, validationException);
        }
        return validationException;
    }

    public void writeTo(@NotNull StreamOutput out) throws IOException {
        Intrinsics.checkNotNullParameter((Object)out, (String)"out");
        out.writeStringCollection((Collection)this.indices);
        out.writeBoolean(this.local);
        out.writeTimeValue(this.clusterManagerTimeout);
        this.searchParams.writeTo(out);
        out.writeOptionalWriteable((Writeable)this.explainFilter);
        out.writeBoolean(this.showPolicy);
        out.writeBoolean(this.validateAction);
        out.writeString(this.indexType);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lorg/opensearch/indexmanagement/indexstatemanagement/transport/action/explain/ExplainRequest$Companion;", "", "()V", "MULTIPLE_INDICES_CUSTOM_INDEX_TYPE_ERROR", "", "opensearch-index-management"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

