/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.indexmanagement.controlcenter.notification.action.get;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jdk7.AutoCloseableKt;
import kotlin.jvm.functions.Function4;
import kotlin.jvm.internal.Intrinsics;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.lucene.search.TotalHits;
import org.jetbrains.annotations.NotNull;
import org.opensearch.ExceptionsHelper;
import org.opensearch.action.search.SearchRequest;
import org.opensearch.action.search.SearchResponse;
import org.opensearch.action.support.ActionFilters;
import org.opensearch.action.support.HandledTransportAction;
import org.opensearch.cluster.routing.Preference;
import org.opensearch.common.inject.Inject;
import org.opensearch.common.util.concurrent.ThreadContext;
import org.opensearch.common.xcontent.LoggingDeprecationHandler;
import org.opensearch.common.xcontent.XContentHelper;
import org.opensearch.common.xcontent.XContentType;
import org.opensearch.core.action.ActionListener;
import org.opensearch.core.common.bytes.BytesReference;
import org.opensearch.core.xcontent.DeprecationHandler;
import org.opensearch.core.xcontent.MediaType;
import org.opensearch.core.xcontent.NamedXContentRegistry;
import org.opensearch.core.xcontent.XContentParser;
import org.opensearch.index.IndexNotFoundException;
import org.opensearch.index.query.BoolQueryBuilder;
import org.opensearch.index.query.QueryBuilder;
import org.opensearch.index.query.QueryBuilders;
import org.opensearch.indexmanagement.common.model.rest.SearchParams;
import org.opensearch.indexmanagement.controlcenter.notification.LRONConfigResponse;
import org.opensearch.indexmanagement.controlcenter.notification.action.get.GetLRONConfigRequest;
import org.opensearch.indexmanagement.controlcenter.notification.action.get.GetLRONConfigResponse;
import org.opensearch.indexmanagement.controlcenter.notification.model.LRONConfig;
import org.opensearch.indexmanagement.controlcenter.notification.util.LRONUtils;
import org.opensearch.indexmanagement.opensearchapi.OpenSearchExtensionsKt;
import org.opensearch.search.SearchHit;
import org.opensearch.search.builder.SearchSourceBuilder;
import org.opensearch.search.sort.FieldSortBuilder;
import org.opensearch.search.sort.SortBuilder;
import org.opensearch.tasks.Task;
import org.opensearch.transport.TransportService;
import org.opensearch.transport.client.node.NodeClient;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001:\u0001\u001bB'\b\u0007\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u00a2\u0006\u0002\u0010\fJ&\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00022\f\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u00030\u001aH\u0014R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0016\u0010\u000f\u001a\n \u0011*\u0004\u0018\u00010\u00100\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\n\u001a\u00020\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013\u00a8\u0006\u001c"}, d2={"Lorg/opensearch/indexmanagement/controlcenter/notification/action/get/TransportGetLRONConfigAction;", "Lorg/opensearch/action/support/HandledTransportAction;", "Lorg/opensearch/indexmanagement/controlcenter/notification/action/get/GetLRONConfigRequest;", "Lorg/opensearch/indexmanagement/controlcenter/notification/action/get/GetLRONConfigResponse;", "client", "Lorg/opensearch/transport/client/node/NodeClient;", "transportService", "Lorg/opensearch/transport/TransportService;", "actionFilters", "Lorg/opensearch/action/support/ActionFilters;", "xContentRegistry", "Lorg/opensearch/core/xcontent/NamedXContentRegistry;", "(Lorg/opensearch/transport/client/node/NodeClient;Lorg/opensearch/transport/TransportService;Lorg/opensearch/action/support/ActionFilters;Lorg/opensearch/core/xcontent/NamedXContentRegistry;)V", "getClient", "()Lorg/opensearch/transport/client/node/NodeClient;", "log", "Lorg/apache/logging/log4j/Logger;", "kotlin.jvm.PlatformType", "getXContentRegistry", "()Lorg/opensearch/core/xcontent/NamedXContentRegistry;", "doExecute", "", "task", "Lorg/opensearch/tasks/Task;", "request", "listener", "Lorg/opensearch/core/action/ActionListener;", "GetLRONConfigHandler", "opensearch-index-management"})
public final class TransportGetLRONConfigAction
extends HandledTransportAction<GetLRONConfigRequest, GetLRONConfigResponse> {
    @NotNull
    private final NodeClient client;
    @NotNull
    private final NamedXContentRegistry xContentRegistry;
    private final Logger log;

    @Inject
    public TransportGetLRONConfigAction(@NotNull NodeClient client, @NotNull TransportService transportService, @NotNull ActionFilters actionFilters, @NotNull NamedXContentRegistry xContentRegistry) {
        Intrinsics.checkNotNullParameter((Object)client, (String)"client");
        Intrinsics.checkNotNullParameter((Object)transportService, (String)"transportService");
        Intrinsics.checkNotNullParameter((Object)actionFilters, (String)"actionFilters");
        Intrinsics.checkNotNullParameter((Object)xContentRegistry, (String)"xContentRegistry");
        super("cluster:admin/opensearch/controlcenter/lron/get", transportService, actionFilters, GetLRONConfigRequest::new);
        this.client = client;
        this.xContentRegistry = xContentRegistry;
        this.log = LogManager.getLogger(((Object)((Object)this)).getClass());
    }

    @NotNull
    public final NodeClient getClient() {
        return this.client;
    }

    @NotNull
    public final NamedXContentRegistry getXContentRegistry() {
        return this.xContentRegistry;
    }

    protected void doExecute(@NotNull Task task, @NotNull GetLRONConfigRequest request, @NotNull ActionListener<GetLRONConfigResponse> listener) {
        Intrinsics.checkNotNullParameter((Object)task, (String)"task");
        Intrinsics.checkNotNullParameter((Object)((Object)request), (String)"request");
        Intrinsics.checkNotNullParameter(listener, (String)"listener");
        new GetLRONConfigHandler(this.client, listener, request).start();
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\b\u0086\u0004\u0018\u00002\u00020\u0001B#\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\tJ\b\u0010\n\u001a\u00020\u000bH\u0002J\u0006\u0010\f\u001a\u00020\u000bR\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lorg/opensearch/indexmanagement/controlcenter/notification/action/get/TransportGetLRONConfigAction$GetLRONConfigHandler;", "", "client", "Lorg/opensearch/transport/client/node/NodeClient;", "actionListener", "Lorg/opensearch/core/action/ActionListener;", "Lorg/opensearch/indexmanagement/controlcenter/notification/action/get/GetLRONConfigResponse;", "request", "Lorg/opensearch/indexmanagement/controlcenter/notification/action/get/GetLRONConfigRequest;", "(Lorg/opensearch/indexmanagement/controlcenter/notification/action/get/TransportGetLRONConfigAction;Lorg/opensearch/transport/client/node/NodeClient;Lorg/opensearch/core/action/ActionListener;Lorg/opensearch/indexmanagement/controlcenter/notification/action/get/GetLRONConfigRequest;)V", "doSearch", "", "start", "opensearch-index-management"})
    public final class GetLRONConfigHandler {
        @NotNull
        private final NodeClient client;
        @NotNull
        private final ActionListener<GetLRONConfigResponse> actionListener;
        @NotNull
        private final GetLRONConfigRequest request;

        public GetLRONConfigHandler(@NotNull NodeClient client, @NotNull ActionListener<GetLRONConfigResponse> actionListener, GetLRONConfigRequest request) {
            Intrinsics.checkNotNullParameter((Object)client, (String)"client");
            Intrinsics.checkNotNullParameter(actionListener, (String)"actionListener");
            Intrinsics.checkNotNullParameter((Object)((Object)request), (String)"request");
            this.client = client;
            this.actionListener = actionListener;
            this.request = request;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public final void start() {
            TransportGetLRONConfigAction.this.log.debug("User and roles string from thread context: " + this.client.threadPool().getThreadContext().getTransient("_opendistro_security_user_info"));
            AutoCloseable autoCloseable = (AutoCloseable)this.client.threadPool().getThreadContext().stashContext();
            TransportGetLRONConfigAction transportGetLRONConfigAction = TransportGetLRONConfigAction.this;
            Throwable throwable = null;
            try {
                ThreadContext.StoredContext it = (ThreadContext.StoredContext)autoCloseable;
                boolean bl = false;
                if (this.request.getDocId() != null) {
                    LRONUtils.getLRONConfigAndParse(this.client, this.request.getDocId(), transportGetLRONConfigAction.getXContentRegistry(), (ActionListener<LRONConfigResponse>)((ActionListener)new ActionListener<LRONConfigResponse>(this){
                        final /* synthetic */ GetLRONConfigHandler this$0;
                        {
                            this.this$0 = $receiver;
                        }

                        public void onResponse(@NotNull LRONConfigResponse response2) {
                            Intrinsics.checkNotNullParameter((Object)((Object)response2), (String)"response");
                            GetLRONConfigHandler.access$getActionListener$p(this.this$0).onResponse((Object)((Object)new GetLRONConfigResponse(CollectionsKt.listOf((Object)((Object)response2)), 1)));
                        }

                        public void onFailure(@NotNull Exception e) {
                            Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                            ActionListener actionListener = GetLRONConfigHandler.access$getActionListener$p(this.this$0);
                            Throwable throwable = ExceptionsHelper.unwrapCause((Throwable)e);
                            Intrinsics.checkNotNull((Object)throwable, (String)"null cannot be cast to non-null type java.lang.Exception{ kotlin.TypeAliasesKt.Exception }");
                            actionListener.onFailure((Exception)throwable);
                        }
                    }));
                } else {
                    this.doSearch();
                }
                Unit unit = Unit.INSTANCE;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                AutoCloseableKt.closeFinally((AutoCloseable)autoCloseable, (Throwable)throwable);
            }
        }

        private final void doSearch() {
            SearchParams params;
            SearchParams searchParams = params = this.request.getSearchParams();
            Intrinsics.checkNotNull((Object)searchParams);
            FieldSortBuilder sortBuilder = searchParams.getSortBuilder();
            BoolQueryBuilder queryBuilder = QueryBuilders.boolQuery().must((QueryBuilder)QueryBuilders.existsQuery((String)"lron_config")).must((QueryBuilder)QueryBuilders.queryStringQuery((String)params.getQueryString()));
            SearchSourceBuilder searchSourceBuilder = new SearchSourceBuilder().query((QueryBuilder)queryBuilder).sort((SortBuilder)sortBuilder).from(params.getFrom()).size(params.getSize());
            String[] stringArray = new String[]{".opensearch-control-center"};
            SearchRequest searchRequest = new SearchRequest().source(searchSourceBuilder).indices(stringArray).preference(Preference.PRIMARY_FIRST.type());
            this.client.search(searchRequest, (ActionListener)new ActionListener<SearchResponse>(this, TransportGetLRONConfigAction.this){
                final /* synthetic */ GetLRONConfigHandler this$0;
                final /* synthetic */ TransportGetLRONConfigAction this$1;
                {
                    this.this$0 = $receiver;
                    this.this$1 = $receiver2;
                }

                /*
                 * WARNING - void declaration
                 */
                public void onResponse(@NotNull SearchResponse response2) {
                    void $this$mapTo$iv$iv;
                    void $this$map$iv;
                    Intrinsics.checkNotNullParameter((Object)response2, (String)"response");
                    TotalHits totalHits = response2.getHits().getTotalHits();
                    long totalNumber = totalHits != null ? totalHits.value() : 0L;
                    SearchHit[] searchHitArray = response2.getHits().getHits();
                    Intrinsics.checkNotNullExpressionValue((Object)searchHitArray, (String)"getHits(...)");
                    Object[] objectArray = searchHitArray;
                    TransportGetLRONConfigAction transportGetLRONConfigAction = this.this$1;
                    boolean $i$f$map = false;
                    void var8_6 = $this$map$iv;
                    Collection destination$iv$iv = new ArrayList<E>(((void)$this$map$iv).length);
                    boolean $i$f$mapTo = false;
                    for (void item$iv$iv : $this$mapTo$iv$iv) {
                        void it;
                        SearchHit searchHit = (SearchHit)item$iv$iv;
                        Collection collection = destination$iv$iv;
                        boolean bl = false;
                        XContentParser xcp = XContentHelper.createParser((NamedXContentRegistry)transportGetLRONConfigAction.getXContentRegistry(), (DeprecationHandler)((DeprecationHandler)LoggingDeprecationHandler.INSTANCE), (BytesReference)it.getSourceRef(), (MediaType)((MediaType)XContentType.JSON));
                        String string = it.getId();
                        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getId(...)");
                        Intrinsics.checkNotNull((Object)xcp);
                        String string2 = it.getId();
                        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getId(...)");
                        collection.add(new LRONConfigResponse(string, (LRONConfig)OpenSearchExtensionsKt.parseWithType$default(xcp, string2, 0L, 0L, (Function4)new Function4<XContentParser, String, Long, Long, LRONConfig>((Object)LRONConfig.Companion){

                            @NotNull
                            public final LRONConfig invoke(@NotNull XContentParser p0, @NotNull String p1, long p2, long p3) {
                                Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                                Intrinsics.checkNotNullParameter((Object)p1, (String)"p1");
                                return ((LRONConfig.Companion)this.receiver).parse(p0, p1, p2, p3);
                            }
                        }, 6, null)));
                    }
                    List lronConfigResponses2 = (List)destination$iv$iv;
                    GetLRONConfigHandler.access$getActionListener$p(this.this$0).onResponse((Object)((Object)new GetLRONConfigResponse(lronConfigResponses2, (int)totalNumber)));
                }

                public void onFailure(@NotNull Exception e) {
                    Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                    if (e instanceof IndexNotFoundException) {
                        GetLRONConfigHandler.access$getActionListener$p(this.this$0).onResponse((Object)((Object)new GetLRONConfigResponse(CollectionsKt.emptyList(), 0)));
                        return;
                    }
                    ActionListener actionListener = GetLRONConfigHandler.access$getActionListener$p(this.this$0);
                    Throwable throwable = ExceptionsHelper.unwrapCause((Throwable)e);
                    Intrinsics.checkNotNull((Object)throwable, (String)"null cannot be cast to non-null type java.lang.Exception{ kotlin.TypeAliasesKt.Exception }");
                    actionListener.onFailure((Exception)throwable);
                }
            });
        }

        public static final /* synthetic */ ActionListener access$getActionListener$p(GetLRONConfigHandler $this) {
            return $this.actionListener;
        }
    }
}

