"use strict";
/*
 * Copyright OpenSearch Contributors
 * SPDX-License-Identifier: Apache-2.0
 */
Object.defineProperty(exports, "__esModule", { value: true });
const worker_store_1 = require("./worker_store");
// @ts-ignore
window.MonacoEnvironment = {
    getWorker: (_, label) => {
        const workerSrc = (0, worker_store_1.getWorker)(label);
        if (workerSrc) {
            const blob = new Blob([workerSrc], { type: 'application/javascript' });
            return new Worker(URL.createObjectURL(blob));
        }
        // Return a default worker if no specific worker is found
        return new Worker(URL.createObjectURL(new Blob([''], { type: 'application/javascript' })));
    },
};
//# sourceMappingURL=monaco_environment.js.map