/*
 * Decompiled with CFR 0.152.
 */
package net.osmand.data;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import net.osmand.data.MapObject;
import net.osmand.data.Street;

public class City
extends MapObject {
    private CityType type = null;
    private List<Street> listOfStreets = new ArrayList<Street>();
    private String postcode = null;
    private City closestCity = null;
    private static long POSTCODE_INTERNAL_ID = -1000L;
    private String isin = null;

    public static City createPostcode(String postcode) {
        return new City(postcode, POSTCODE_INTERNAL_ID--);
    }

    public City(CityType type) {
        if (type == null) {
            throw new NullPointerException();
        }
        this.type = type;
    }

    public City(String postcode, long id2) {
        this.type = null;
        this.name = this.enName = postcode;
        this.id = id2;
    }

    public String getIsInValue() {
        return this.isin;
    }

    public boolean isPostcode() {
        return this.type == null;
    }

    public String getPostcode() {
        return this.postcode;
    }

    public void setPostcode(String postcode) {
        this.postcode = postcode;
    }

    public City getClosestCity() {
        return this.closestCity;
    }

    public void setClosestCity(City closestCity) {
        this.closestCity = closestCity;
    }

    public void registerStreet(Street street) {
        this.listOfStreets.add(street);
    }

    public void unregisterStreet(Street candidate) {
        this.listOfStreets.remove(candidate);
    }

    public CityType getType() {
        return this.type;
    }

    public Collection<Street> getStreets() {
        return this.listOfStreets;
    }

    @Override
    public String toString() {
        if (this.isPostcode()) {
            return "Postcode : " + this.getName();
        }
        return "City [" + (Object)((Object)this.type) + "] " + this.getName();
    }

    public Street getStreetByName(String name) {
        for (Street s : this.listOfStreets) {
            if (!s.getName().equalsIgnoreCase(name)) continue;
            return s;
        }
        return null;
    }

    public void setIsin(String isin) {
        this.isin = isin;
    }

    public static enum CityType {
        CITY(10000.0),
        TOWN(5000.0),
        VILLAGE(1300.0),
        HAMLET(1000.0),
        SUBURB(400.0),
        DISTRICT(400.0),
        NEIGHBOURHOOD(300.0);

        private double radius;

        private CityType(double radius) {
            this.radius = radius;
        }

        public double getRadius() {
            return this.radius;
        }

        public static String valueToString(CityType t) {
            return t.toString().toLowerCase();
        }

        public static CityType valueFromString(String place) {
            if (place == null) {
                return null;
            }
            if ("township".equals(place)) {
                return TOWN;
            }
            if ("borough".equals(place)) {
                return SUBURB;
            }
            for (CityType t : CityType.values()) {
                if (!t.name().equalsIgnoreCase(place)) continue;
                return t;
            }
            return null;
        }
    }
}

