/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.document;

import java.util.Objects;
import org.apache.lucene.document.Field;
import org.apache.lucene.document.FieldType;
import org.apache.lucene.document.RangeFieldQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.NumericUtils;

public class DoubleRange
extends Field {
    public static final int BYTES = 8;

    public DoubleRange(String name, double[] min2, double[] max) {
        super(name, DoubleRange.getType(min2.length));
        this.setRangeValues(min2, max);
    }

    private static FieldType getType(int dimensions) {
        if (dimensions > 4) {
            throw new IllegalArgumentException("DoubleRange does not support greater than 4 dimensions");
        }
        FieldType ft = new FieldType();
        ft.setDimensions(dimensions * 2, 8);
        ft.freeze();
        return ft;
    }

    public void setRangeValues(double[] min2, double[] max) {
        byte[] bytes;
        DoubleRange.checkArgs(min2, max);
        if (min2.length * 2 != this.type.pointDimensionCount() || max.length * 2 != this.type.pointDimensionCount()) {
            throw new IllegalArgumentException("field (name=" + this.name + ") uses " + this.type.pointDimensionCount() / 2 + " dimensions; cannot change to (incoming) " + min2.length + " dimensions");
        }
        if (this.fieldsData == null) {
            bytes = new byte[16 * min2.length];
            this.fieldsData = new BytesRef(bytes);
        } else {
            bytes = ((BytesRef)this.fieldsData).bytes;
        }
        DoubleRange.verifyAndEncode(min2, max, bytes);
    }

    private static void checkArgs(double[] min2, double[] max) {
        if (min2 == null || max == null || min2.length == 0 || max.length == 0) {
            throw new IllegalArgumentException("min/max range values cannot be null or empty");
        }
        if (min2.length != max.length) {
            throw new IllegalArgumentException("min/max ranges must agree");
        }
        if (min2.length > 4) {
            throw new IllegalArgumentException("DoubleRange does not support greater than 4 dimensions");
        }
    }

    static byte[] encode(double[] min2, double[] max) {
        DoubleRange.checkArgs(min2, max);
        byte[] b = new byte[16 * min2.length];
        DoubleRange.verifyAndEncode(min2, max, b);
        return b;
    }

    public static void verifyAndEncode(double[] min2, double[] max, byte[] bytes) {
        int d = 0;
        int i = 0;
        int j = min2.length * 8;
        while (d < min2.length) {
            if (Double.isNaN(min2[d])) {
                throw new IllegalArgumentException("invalid min value (NaN) in DoubleRange");
            }
            if (Double.isNaN(max[d])) {
                throw new IllegalArgumentException("invalid max value (NaN) in DoubleRange");
            }
            if (min2[d] > max[d]) {
                throw new IllegalArgumentException("min value (" + min2[d] + ") is greater than max value (" + max[d] + ")");
            }
            DoubleRange.encode(min2[d], bytes, i);
            DoubleRange.encode(max[d], bytes, j);
            ++d;
            i += 8;
            j += 8;
        }
    }

    private static void encode(double val, byte[] bytes, int offset) {
        NumericUtils.longToSortableBytes(NumericUtils.doubleToSortableLong(val), bytes, offset);
    }

    public double getMin(int dimension) {
        Objects.checkIndex(dimension, this.type.pointDimensionCount() / 2);
        return DoubleRange.decodeMin(((BytesRef)this.fieldsData).bytes, dimension);
    }

    public double getMax(int dimension) {
        Objects.checkIndex(dimension, this.type.pointDimensionCount() / 2);
        return DoubleRange.decodeMax(((BytesRef)this.fieldsData).bytes, dimension);
    }

    static double decodeMin(byte[] b, int dimension) {
        int offset = dimension * 8;
        return NumericUtils.sortableLongToDouble(NumericUtils.sortableBytesToLong(b, offset));
    }

    static double decodeMax(byte[] b, int dimension) {
        int offset = b.length / 2 + dimension * 8;
        return NumericUtils.sortableLongToDouble(NumericUtils.sortableBytesToLong(b, offset));
    }

    public static Query newIntersectsQuery(String field, double[] min2, double[] max) {
        return DoubleRange.newRelationQuery(field, min2, max, RangeFieldQuery.QueryType.INTERSECTS);
    }

    public static Query newContainsQuery(String field, double[] min2, double[] max) {
        return DoubleRange.newRelationQuery(field, min2, max, RangeFieldQuery.QueryType.CONTAINS);
    }

    public static Query newWithinQuery(String field, double[] min2, double[] max) {
        return DoubleRange.newRelationQuery(field, min2, max, RangeFieldQuery.QueryType.WITHIN);
    }

    public static Query newCrossesQuery(String field, double[] min2, double[] max) {
        return DoubleRange.newRelationQuery(field, min2, max, RangeFieldQuery.QueryType.CROSSES);
    }

    private static Query newRelationQuery(String field, double[] min2, double[] max, RangeFieldQuery.QueryType relation) {
        DoubleRange.checkArgs(min2, max);
        return new RangeFieldQuery(field, DoubleRange.encode(min2, max), min2.length, relation){

            @Override
            protected String toString(byte[] ranges, int dimension) {
                return DoubleRange.toString(ranges, dimension);
            }
        };
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getClass().getSimpleName());
        sb.append(" <");
        sb.append(this.name);
        sb.append(':');
        byte[] b = ((BytesRef)this.fieldsData).bytes;
        DoubleRange.toString(b, 0);
        for (int d = 0; d < this.type.pointDimensionCount() / 2; ++d) {
            sb.append(' ');
            sb.append(DoubleRange.toString(b, d));
        }
        sb.append('>');
        return sb.toString();
    }

    private static String toString(byte[] ranges, int dimension) {
        return "[" + Double.toString(DoubleRange.decodeMin(ranges, dimension)) + " : " + Double.toString(DoubleRange.decodeMax(ranges, dimension)) + "]";
    }
}

