/*
 * Decompiled with CFR 0.152.
 */
package com.install4j.runtime.installer.platform.win32;

import com.install4j.api.Util;
import com.install4j.api.context.UserCanceledException;
import com.install4j.api.windows.RegistryRoot;
import com.install4j.api.windows.WinRegistry;
import com.install4j.runtime.beans.actions.SystemInstallOrUninstallAction;
import com.install4j.runtime.beans.actions.registry.DeleteRegistryItemAction;
import com.install4j.runtime.beans.actions.registry.SetRegistryValueAction;
import com.install4j.runtime.installer.ContextImpl;
import com.install4j.runtime.installer.ContextInt;
import com.install4j.runtime.installer.helper.Logger;
import com.install4j.runtime.installer.platform.win32.FileAssociations;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.StringTokenizer;

public class Win32UrlHandler {
    public static Collection<SystemInstallOrUninstallAction> create(String scheme, File executable) throws UserCanceledException {
        boolean success;
        SystemInstallOrUninstallAction action;
        ArrayList<SystemInstallOrUninstallAction> ret = new ArrayList<SystemInstallOrUninstallAction>();
        if (Win32UrlHandler.isInvalidScheme(scheme)) {
            Logger.getInstance().error(null, "invalid scheme: '" + scheme + "'");
            return ret;
        }
        RegistryRoot classesRoot = Util.hasFullAdminRights() ? RegistryRoot.HKEY_CLASSES_ROOT : RegistryRoot.HKEY_CURRENT_USER;
        String keyPrefix = FileAssociations.getKeyPrefix(classesRoot);
        ContextInt context = ContextImpl.getSingleContextInt();
        String keyName = keyPrefix + scheme;
        if (WinRegistry.keyExists(classesRoot, keyName)) {
            action = new DeleteRegistryItemAction(classesRoot, keyName, "", false);
            action.execute(context);
            ret.add(action);
        }
        if (!(success = (action = new SetRegistryValueAction(classesRoot, keyName, "", "URL:" + scheme + " protocol", true)).execute(context))) {
            Logger.getInstance().error(null, "error setting scheme name");
        }
        ret.add(action);
        action = new SetRegistryValueAction(classesRoot, keyName, "URL Protocol", "", true);
        success = action.execute(context);
        if (!success) {
            Logger.getInstance().error(null, "error setting url protocol");
        }
        ret.add(action);
        String executableValue = "\"" + executable.getAbsolutePath() + "\" \"%1\"";
        action = new SetRegistryValueAction(classesRoot, keyName + "\\shell\\open\\command", "", executableValue, true);
        success = action.execute(context);
        if (!success) {
            Logger.getInstance().error(null, "error setting command key");
        }
        ret.add(action);
        return ret;
    }

    private static boolean isInvalidScheme(String scheme) {
        return scheme == null || scheme.trim().isEmpty() || scheme.contains(" ");
    }

    public static String getExecutable(String scheme, RegistryRoot registryRoot) {
        if (FileAssociations.exists(scheme, registryRoot)) {
            return Win32UrlHandler.getExecutableInt(scheme, registryRoot, FileAssociations.getKeyPrefix(registryRoot));
        }
        return null;
    }

    private static String getExecutableInt(String scheme, RegistryRoot classesRoot, String keyPrefix) {
        StringTokenizer tok;
        Object command = WinRegistry.getValue(classesRoot, keyPrefix + scheme + "\\shell\\open\\command", "");
        if (command != null && (tok = new StringTokenizer(command.toString(), "\"")).hasMoreTokens()) {
            return tok.nextToken();
        }
        return null;
    }

    public static void remove(String scheme, RegistryRoot root) {
        String keyName = FileAssociations.getKeyPrefix(root) + scheme;
        if (WinRegistry.keyExists(root, keyName)) {
            WinRegistry.deleteKey(root, keyName, false);
        }
    }
}

