/*
 * Decompiled with CFR 0.152.
 */
package mediathek.tool.threads;

import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import mediathek.config.Daten;
import mediathek.daten.DatenDownload;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0006\n\u0000\b\u0016\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0007\u001a\u00020\bH\u0004R\u0014\u0010\u0003\u001a\u00020\u0004X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\t"}, d2={"Lmediathek/tool/threads/IndicatorThread;", "Ljava/lang/Thread;", "()V", "daten", "Lmediathek/config/Daten;", "getDaten", "()Lmediathek/config/Daten;", "calculateOverallPercentage", "", "MediathekView"})
public class IndicatorThread
extends Thread {
    @NotNull
    private final Daten daten;

    public IndicatorThread() {
        this.setName("IndicatorThread");
        Daten daten = Daten.getInstance();
        Intrinsics.checkNotNullExpressionValue(daten, "getInstance()");
        this.daten = daten;
    }

    @NotNull
    protected final Daten getDaten() {
        return this.daten;
    }

    protected final double calculateOverallPercentage() {
        int numOfDownloadsActive = 0;
        double accumPercentage = 0.0;
        List<DatenDownload> activeDownloadList = this.daten.getListeDownloads().getListOfStartsNotFinished(-1);
        for (DatenDownload download : activeDownloadList) {
            if (download.start.status != 2) continue;
            ++numOfDownloadsActive;
            accumPercentage += (double)download.start.percent / 10.0;
        }
        activeDownloadList.clear();
        return accumPercentage / (double)numOfDownloadsActive;
    }
}

