#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
printf '%s' 'name:                 kmonad
version:              0.4.4
visibility:           public
id:                   kmonad-0.4.4-5pHVf60Z8e44sQaOXTH52
key:                  kmonad-0.4.4-5pHVf60Z8e44sQaOXTH52
license:              MIT
maintainer:           janssen.dhj@gmail.com
author:               David Janssen
synopsis:             Advanced keyboard remapping utility
description:
    KMonad is a cross-platform command-line utility that runs as a daemon. It
    captures keyboard input (exactly how depends on the OS) and remaps it. The
    mapping is highly configurable, and provides options like (transparent) layer
    overlays, tap-mod buttons, multi-tap buttons, leader-key style buttons, and
    keyboard macros. Functionality heavily inspired by the QMK-firmware.

category:             Application
abi:                  3ed35a99344907a672a13d0863eaf1f4
exposed:              True
exposed-modules:
    KMonad.App KMonad.App.Main KMonad.App.Types KMonad.Args
    KMonad.Args.Cmd KMonad.Args.Joiner KMonad.Args.Parser
    KMonad.Args.TH KMonad.Args.Types KMonad.Gesture KMonad.Keyboard
    KMonad.Keyboard.ComposeSeq KMonad.Keyboard.IO
    KMonad.Keyboard.IO.Linux.DeviceSource
    KMonad.Keyboard.IO.Linux.Types KMonad.Keyboard.IO.Linux.UinputSink
    KMonad.Keyboard.IO.Mac.Types KMonad.Keyboard.IO.Windows.Types
    KMonad.Keyboard.Keycode KMonad.Keyboard.Ops KMonad.Keyboard.Types
    KMonad.Model KMonad.Model.Action KMonad.Model.BEnv
    KMonad.Model.Button KMonad.Model.Dispatch KMonad.Model.Hooks
    KMonad.Model.Keymap KMonad.Model.Sluice KMonad.Parsing
    KMonad.Prelude KMonad.Prelude.Definitions KMonad.Prelude.Imports
    KMonad.Util KMonad.Util.LayerStack KMonad.Util.MultiMap
    Paths_kmonad

import-dirs:          /usr/lib/ghc-9.4.8/site-local/kmonad-0.4.4
library-dirs:         /usr/lib/ghc-9.4.8/site-local/kmonad-0.4.4
library-dirs-static:  /usr/lib/ghc-9.4.8/site-local/kmonad-0.4.4
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/kmonad
hs-libraries:         HSkmonad-0.4.4-5pHVf60Z8e44sQaOXTH52
depends:
    base-4.17.2.1 cereal-0.5.8.3-H9MXf6i1TMkEAfnsx4oYbT
    lens-5.3.1-FP95Rv35No71PYJue58Hxp
    megaparsec-9.7.0-7jzSygYb9UCHSxVBa30IvK mtl-2.2.2
    optparse-applicative-0.18.1.0-2IPYcrIwIO6ByK20WziUUn
    resourcet-1.2.6-1uUyorfyzWb8h78koH6NVM
    rio-0.1.22.0-FRVl3z1YqEoDlmYLA6axyl template-haskell-2.19.0.0
    time-1.12.2 transformers-0.5.6.2 unix-2.7.3
    unliftio-0.2.25.1-JFZIPKypuxSaOakmu5k8d

haddock-interfaces:   /usr/share/doc/kmonad/html/kmonad.haddock
haddock-html:         /usr/share/doc/kmonad/html
' | '/usr/bin/ghc-pkg-9.4.8' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

