/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams;

import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.StringJoiner;
import org.apache.kafka.common.serialization.Deserializer;
import org.apache.kafka.streams.KeyValue;
import org.apache.kafka.streams.TopologyTestDriver;
import org.apache.kafka.streams.test.TestRecord;

public class TestOutputTopic<K, V> {
    private final TopologyTestDriver driver;
    private final String topic;
    private final Deserializer<K> keyDeserializer;
    private final Deserializer<V> valueDeserializer;

    TestOutputTopic(TopologyTestDriver driver, String topicName, Deserializer<K> keyDeserializer, Deserializer<V> valueDeserializer) {
        Objects.requireNonNull(driver, "TopologyTestDriver cannot be null");
        Objects.requireNonNull(topicName, "topicName cannot be null");
        Objects.requireNonNull(keyDeserializer, "keyDeserializer cannot be null");
        Objects.requireNonNull(valueDeserializer, "valueDeserializer cannot be null");
        this.driver = driver;
        this.topic = topicName;
        this.keyDeserializer = keyDeserializer;
        this.valueDeserializer = valueDeserializer;
    }

    public V readValue() {
        TestRecord<K, V> record = this.readRecord();
        return record.value();
    }

    public KeyValue<K, V> readKeyValue() {
        TestRecord<K, V> record = this.readRecord();
        return new KeyValue(record.key(), record.value());
    }

    public TestRecord<K, V> readRecord() {
        return this.driver.readRecord(this.topic, this.keyDeserializer, this.valueDeserializer);
    }

    public List<TestRecord<K, V>> readRecordsToList() {
        LinkedList<TestRecord<K, V>> output = new LinkedList<TestRecord<K, V>>();
        while (!this.isEmpty()) {
            output.add(this.readRecord());
        }
        return output;
    }

    public Map<K, V> readKeyValuesToMap() {
        HashMap<K, V> output = new HashMap<K, V>();
        while (!this.isEmpty()) {
            TestRecord<K, V> outputRow = this.readRecord();
            if (outputRow.key() == null) {
                throw new IllegalStateException("Null keys not allowed with readKeyValuesToMap method");
            }
            output.put(outputRow.key(), outputRow.value());
        }
        return output;
    }

    public List<KeyValue<K, V>> readKeyValuesToList() {
        LinkedList<KeyValue<K, V>> output = new LinkedList<KeyValue<K, V>>();
        while (!this.isEmpty()) {
            KeyValue<K, V> outputRow = this.readKeyValue();
            output.add(outputRow);
        }
        return output;
    }

    public List<V> readValuesToList() {
        LinkedList<V> output = new LinkedList<V>();
        while (!this.isEmpty()) {
            V outputValue = this.readValue();
            output.add(outputValue);
        }
        return output;
    }

    public final long getQueueSize() {
        return this.driver.queueSize(this.topic);
    }

    public final boolean isEmpty() {
        return this.driver.isEmpty(this.topic);
    }

    public String toString() {
        return new StringJoiner(", ", TestOutputTopic.class.getSimpleName() + "[", "]").add("topic='" + this.topic + "'").add("keyDeserializer=" + this.keyDeserializer.getClass().getSimpleName()).add("valueDeserializer=" + this.valueDeserializer.getClass().getSimpleName()).add("size=" + this.getQueueSize()).toString();
    }
}

