/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.shell.glob;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import org.apache.kafka.image.node.MetadataNode;
import org.apache.kafka.shell.command.CommandUtils;
import org.apache.kafka.shell.glob.GlobComponent;
import org.apache.kafka.shell.state.MetadataShellState;

public final class GlobVisitor
implements Consumer<MetadataShellState> {
    private final String glob;
    private final Consumer<Optional<MetadataNodeInfo>> handler;

    public GlobVisitor(String glob, Consumer<Optional<MetadataNodeInfo>> handler) {
        this.glob = glob;
        this.handler = handler;
    }

    @Override
    public void accept(MetadataShellState state) {
        String fullGlob = this.glob.startsWith("/") ? this.glob : state.workingDirectory() + "/" + this.glob;
        List<String> globComponents = CommandUtils.stripDotPathComponents(CommandUtils.splitPath(fullGlob));
        MetadataNode root = state.root();
        if (root == null) {
            throw new RuntimeException("Invalid null root");
        }
        if (!this.accept(globComponents, 0, root, new String[0])) {
            this.handler.accept(Optional.empty());
        }
    }

    private boolean accept(List<String> globComponents, int componentIndex, MetadataNode node, String[] path) {
        if (componentIndex >= globComponents.size()) {
            this.handler.accept(Optional.of(new MetadataNodeInfo(path, node)));
            return true;
        }
        String globComponentString = globComponents.get(componentIndex);
        GlobComponent globComponent = new GlobComponent(globComponentString);
        if (globComponent.literal()) {
            if (!node.isDirectory()) {
                return false;
            }
            MetadataNode child = node.child(globComponent.component());
            if (child == null) {
                return false;
            }
            String[] newPath = new String[path.length + 1];
            System.arraycopy(path, 0, newPath, 0, path.length);
            newPath[path.length] = globComponent.component();
            return this.accept(globComponents, componentIndex + 1, child, newPath);
        }
        if (!node.isDirectory()) {
            return false;
        }
        boolean matchedAny = false;
        ArrayList nodeChildNames = new ArrayList(node.childNames());
        nodeChildNames.sort(String::compareTo);
        for (String nodeName : nodeChildNames) {
            if (!globComponent.matches(nodeName)) continue;
            String[] newPath = new String[path.length + 1];
            System.arraycopy(path, 0, newPath, 0, path.length);
            newPath[path.length] = nodeName;
            MetadataNode child = node.child(nodeName);
            if (child == null) {
                throw new RuntimeException("Expected " + nodeName + " to be a valid child of " + String.valueOf(node.getClass()) + ", but it was not.");
            }
            if (!this.accept(globComponents, componentIndex + 1, child, newPath)) continue;
            matchedAny = true;
        }
        return matchedAny;
    }

    public static class MetadataNodeInfo {
        private final String[] path;
        private final MetadataNode node;

        MetadataNodeInfo(String[] path, MetadataNode node) {
            this.path = path;
            this.node = node;
        }

        public MetadataNode node() {
            return this.node;
        }

        public String lastPathComponent() {
            if (this.path.length == 0) {
                return "/";
            }
            return this.path[this.path.length - 1];
        }

        public String absolutePath() {
            return "/" + String.join((CharSequence)"/", this.path);
        }

        public int hashCode() {
            return Objects.hash(Arrays.hashCode(this.path), this.node);
        }

        public boolean equals(Object o) {
            if (!(o instanceof MetadataNodeInfo)) {
                return false;
            }
            MetadataNodeInfo other = (MetadataNodeInfo)o;
            if (!Arrays.equals(this.path, other.path)) {
                return false;
            }
            return this.node.equals(other.node);
        }

        public String toString() {
            StringBuilder bld = new StringBuilder("MetadataNodeInfo(path=");
            for (String s : this.path) {
                bld.append("/");
                bld.append(s);
            }
            bld.append(", node=").append(this.node).append(")");
            return bld.toString();
        }
    }
}

