/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.conflict.pair.nodes;

import java.util.ArrayList;
import java.util.Map;
import javax.swing.table.DefaultTableModel;
import org.openstreetmap.josm.command.conflict.WayNodesConflictResolverCommand;
import org.openstreetmap.josm.data.conflict.Conflict;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.PrimitiveId;
import org.openstreetmap.josm.data.osm.Way;
import org.openstreetmap.josm.gui.conflict.pair.AbstractListMergeModel;
import org.openstreetmap.josm.gui.conflict.pair.ListRole;
import org.openstreetmap.josm.tools.I18n;

public class NodeListMergeModel
extends AbstractListMergeModel<Node, WayNodesConflictResolverCommand> {
    public void populate(Way my, Way their, Map<PrimitiveId, PrimitiveId> mergedMap) {
        this.initPopulate(my, their, mergedMap);
        for (Node n : my.getNodes()) {
            this.getMyEntries().add(n);
        }
        for (Node n : their.getNodes()) {
            this.getTheirEntries().add(n);
        }
        if (this.myAndTheirEntriesEqual()) {
            this.entries.put(ListRole.MERGED_ENTRIES, new ArrayList(this.getMyEntries()));
            this.setFrozen(true);
        } else {
            this.setFrozen(false);
        }
        this.fireModelDataChanged();
    }

    @Override
    public WayNodesConflictResolverCommand buildResolveCommand(Conflict<? extends OsmPrimitive> conflict) {
        if (!this.isFrozen()) {
            throw new IllegalArgumentException(I18n.tr("Merged nodes not frozen yet. Cannot build resolution command.", new Object[0]));
        }
        return new WayNodesConflictResolverCommand(conflict, new ArrayList<Node>(this.getMergedEntries()));
    }

    @Override
    public boolean isEqualEntry(Node e1, Node e2) {
        if (!e1.isNew()) {
            return e1.getId() == e2.getId();
        }
        return e1 == e2;
    }

    @Override
    protected void setValueAt(DefaultTableModel model, Object value, int row, int col) {
    }

    @Override
    protected Node cloneEntryForMergedList(Node entry) {
        return (Node)this.getMyPrimitive(entry);
    }
}

