<?xml version="1.0" encoding="utf-8"?>
<!--

 Copyright © 2009 Intel Corporation. All rights reserved.

 The information contained herein is the exclusive property of
 Intel Corporation and may not be disclosed, examined, or reproduced in
 whole or in part without explicit written authorization from the Company.

-->
<xsl:stylesheet version="1.0"
                xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
                xmlns:exsl="http://exslt.org/common"
                exsl:keep_exsl_namespace=""
                xmlns:fnc="urn:functions"
                syntax="norules">
  <xsl:import href="config://include/gpu_common_functions.inc"/>
  <xsl:output indent="yes" method="xml"/>
  <xsl:template match="/">
    <variables>
      <isMultiGpuAdapterSystem>
        <xsl:if test="fnc:is_multi_gpu_adapter_system()">
          <xsl:text>true</xsl:text>
        </xsl:if>
      </isMultiGpuAdapterSystem>
      <isMultiGpuTileSystem>
        <xsl:if test="fnc:is_multi_gpu_tile_system()">
          <xsl:text>true</xsl:text>
        </xsl:if>
      </isMultiGpuTileSystem>
      <multiGpuGrouping>
        <xsl:value-of select="fnc:get_multi_gpu_grouping()"/>
      </multiGpuGrouping>
      <alu2Name>
        <xsl:value-of select="fnc:get_alu2_name()"/>
      </alu2Name>
      <interestingPacketTypes>
        <xsl:choose>
          <xsl:when test="exsl:is_non_empty_table_exist('dd_dma_perf_tag_type') and
                          (
                            exsl:get_row_values_list('dd_dma_perf_tag_type', 'name', ',') !=
                            'Unknown'
                          )">true</xsl:when>
          <xsl:otherwise>false</xsl:otherwise>
        </xsl:choose>
      </interestingPacketTypes>
    </variables>
  </xsl:template>
</xsl:stylesheet>
